<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BundleValidationFailureInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BundleValidationFailureInformation
 * @subpackage Structs
 */
class BundleValidationFailureInformation extends ExtensibleDataContract
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The ElementId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ElementId;
    /**
     * The FailureMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FailureMessage;
    /**
     * Constructor method for BundleValidationFailureInformation
     * @uses BundleValidationFailureInformation::setCode()
     * @uses BundleValidationFailureInformation::setElementId()
     * @uses BundleValidationFailureInformation::setFailureMessage()
     * @param string $code
     * @param string $elementId
     * @param string $failureMessage
     */
    public function __construct($code = null, $elementId = null, $failureMessage = null)
    {
        $this
            ->setCode($code)
            ->setElementId($elementId)
            ->setFailureMessage($failureMessage);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \patest\StructType\BundleValidationFailureInformation
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get ElementId value
     * @return string|null
     */
    public function getElementId()
    {
        return $this->ElementId;
    }
    /**
     * Set ElementId value
     * @param string $elementId
     * @return \patest\StructType\BundleValidationFailureInformation
     */
    public function setElementId($elementId = null)
    {
        // validation for constraint: string
        if (!is_null($elementId) && !is_string($elementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($elementId, true), gettype($elementId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($elementId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $elementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($elementId, true)), __LINE__);
        }
        $this->ElementId = $elementId;
        return $this;
    }
    /**
     * Get FailureMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailureMessage()
    {
        return isset($this->FailureMessage) ? $this->FailureMessage : null;
    }
    /**
     * Set FailureMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failureMessage
     * @return \patest\StructType\BundleValidationFailureInformation
     */
    public function setFailureMessage($failureMessage = null)
    {
        // validation for constraint: string
        if (!is_null($failureMessage) && !is_string($failureMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureMessage, true), gettype($failureMessage)), __LINE__);
        }
        if (is_null($failureMessage) || (is_array($failureMessage) && empty($failureMessage))) {
            unset($this->FailureMessage);
        } else {
            $this->FailureMessage = $failureMessage;
        }
        return $this;
    }
}
