<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BulkEventOwnership-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BulkEventOwnership-Request
 * @subpackage Structs
 */
class BulkEventOwnership_Request extends ExtensibleDataContract
{
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The MaxResultCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxResultCount;
    /**
     * The MinTicketWithVersionsLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinTicketWithVersionsLocalId;
    /**
     * Constructor method for BulkEventOwnership-Request
     * @uses BulkEventOwnership_Request::setEventGuid()
     * @uses BulkEventOwnership_Request::setMaxResultCount()
     * @uses BulkEventOwnership_Request::setMinTicketWithVersionsLocalId()
     * @param string $eventGuid
     * @param int $maxResultCount
     * @param int $minTicketWithVersionsLocalId
     */
    public function __construct($eventGuid = null, $maxResultCount = null, $minTicketWithVersionsLocalId = null)
    {
        $this
            ->setEventGuid($eventGuid)
            ->setMaxResultCount($maxResultCount)
            ->setMinTicketWithVersionsLocalId($minTicketWithVersionsLocalId);
    }
    /**
     * Get EventGuid value
     * @return string|null
     */
    public function getEventGuid()
    {
        return $this->EventGuid;
    }
    /**
     * Set EventGuid value
     * @param string $eventGuid
     * @return \patest\StructType\BulkEventOwnership_Request
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        $this->EventGuid = $eventGuid;
        return $this;
    }
    /**
     * Get MaxResultCount value
     * @return int|null
     */
    public function getMaxResultCount()
    {
        return $this->MaxResultCount;
    }
    /**
     * Set MaxResultCount value
     * @param int $maxResultCount
     * @return \patest\StructType\BulkEventOwnership_Request
     */
    public function setMaxResultCount($maxResultCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxResultCount) && !(is_int($maxResultCount) || ctype_digit($maxResultCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxResultCount, true), gettype($maxResultCount)), __LINE__);
        }
        $this->MaxResultCount = $maxResultCount;
        return $this;
    }
    /**
     * Get MinTicketWithVersionsLocalId value
     * @return int|null
     */
    public function getMinTicketWithVersionsLocalId()
    {
        return $this->MinTicketWithVersionsLocalId;
    }
    /**
     * Set MinTicketWithVersionsLocalId value
     * @param int $minTicketWithVersionsLocalId
     * @return \patest\StructType\BulkEventOwnership_Request
     */
    public function setMinTicketWithVersionsLocalId($minTicketWithVersionsLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($minTicketWithVersionsLocalId) && !(is_int($minTicketWithVersionsLocalId) || ctype_digit($minTicketWithVersionsLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minTicketWithVersionsLocalId, true), gettype($minTicketWithVersionsLocalId)), __LINE__);
        }
        $this->MinTicketWithVersionsLocalId = $minTicketWithVersionsLocalId;
        return $this;
    }
}
