<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BulkEventOwnershipEntry StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BulkEventOwnershipEntry
 * @subpackage Structs
 */
class BulkEventOwnershipEntry extends AbstractStructBase
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The EssentialSeatDataAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EssentialSeatDataAreaId;
    /**
     * The EssentialSeatDataEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EssentialSeatDataEventId;
    /**
     * The EssentialSeatDataHolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EssentialSeatDataHolderCompanyId;
    /**
     * The EssentialSeatDataRowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EssentialSeatDataRowName;
    /**
     * The EssentialSeatDataRowOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EssentialSeatDataRowOrdinal;
    /**
     * The EssentialSeatDataSeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EssentialSeatDataSeatIdInAreaMap;
    /**
     * The EssentialSeatDataSeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EssentialSeatDataSeatName;
    /**
     * The EssentialSeatDataSeatOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EssentialSeatDataSeatOrdinal;
    /**
     * The EssentialSeatDataSectorGlobalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EssentialSeatDataSectorGlobalName;
    /**
     * The EssentialSeatDataSectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EssentialSeatDataSectorId;
    /**
     * The EssentialSeatDataSectorOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EssentialSeatDataSectorOrdinal;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsLastVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsLastVersion;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsValid;
    /**
     * The LastTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastTransactionGuid;
    /**
     * The LastVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastVersionId;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LocalId;
    /**
     * The OriginalTicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalTicketId;
    /**
     * The PreviousVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PreviousVersionId;
    /**
     * The RestrictionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RestrictionGuid;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorGlobalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorGlobalName;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TicketNumber;
    /**
     * Constructor method for BulkEventOwnershipEntry
     * @uses BulkEventOwnershipEntry::setAreaId()
     * @uses BulkEventOwnershipEntry::setClientId()
     * @uses BulkEventOwnershipEntry::setEssentialSeatDataAreaId()
     * @uses BulkEventOwnershipEntry::setEssentialSeatDataEventId()
     * @uses BulkEventOwnershipEntry::setEssentialSeatDataHolderCompanyId()
     * @uses BulkEventOwnershipEntry::setEssentialSeatDataRowName()
     * @uses BulkEventOwnershipEntry::setEssentialSeatDataRowOrdinal()
     * @uses BulkEventOwnershipEntry::setEssentialSeatDataSeatIdInAreaMap()
     * @uses BulkEventOwnershipEntry::setEssentialSeatDataSeatName()
     * @uses BulkEventOwnershipEntry::setEssentialSeatDataSeatOrdinal()
     * @uses BulkEventOwnershipEntry::setEssentialSeatDataSectorGlobalName()
     * @uses BulkEventOwnershipEntry::setEssentialSeatDataSectorId()
     * @uses BulkEventOwnershipEntry::setEssentialSeatDataSectorOrdinal()
     * @uses BulkEventOwnershipEntry::setEventId()
     * @uses BulkEventOwnershipEntry::setId()
     * @uses BulkEventOwnershipEntry::setIsLastVersion()
     * @uses BulkEventOwnershipEntry::setIsValid()
     * @uses BulkEventOwnershipEntry::setLastTransactionGuid()
     * @uses BulkEventOwnershipEntry::setLastVersionId()
     * @uses BulkEventOwnershipEntry::setLocalId()
     * @uses BulkEventOwnershipEntry::setOriginalTicketId()
     * @uses BulkEventOwnershipEntry::setPreviousVersionId()
     * @uses BulkEventOwnershipEntry::setRestrictionGuid()
     * @uses BulkEventOwnershipEntry::setRowName()
     * @uses BulkEventOwnershipEntry::setSeatIdInAreaMap()
     * @uses BulkEventOwnershipEntry::setSeatName()
     * @uses BulkEventOwnershipEntry::setSectorGlobalName()
     * @uses BulkEventOwnershipEntry::setSubscriptionInstanceId()
     * @uses BulkEventOwnershipEntry::setSubscriptionNumber()
     * @uses BulkEventOwnershipEntry::setTicketNumber()
     * @param string $areaId
     * @param string $clientId
     * @param string $essentialSeatDataAreaId
     * @param string $essentialSeatDataEventId
     * @param int $essentialSeatDataHolderCompanyId
     * @param string $essentialSeatDataRowName
     * @param int $essentialSeatDataRowOrdinal
     * @param int $essentialSeatDataSeatIdInAreaMap
     * @param string $essentialSeatDataSeatName
     * @param int $essentialSeatDataSeatOrdinal
     * @param \patest\StructType\GlobalString $essentialSeatDataSectorGlobalName
     * @param string $essentialSeatDataSectorId
     * @param int $essentialSeatDataSectorOrdinal
     * @param string $eventId
     * @param string $id
     * @param bool $isLastVersion
     * @param bool $isValid
     * @param string $lastTransactionGuid
     * @param string $lastVersionId
     * @param int $localId
     * @param string $originalTicketId
     * @param string $previousVersionId
     * @param string $restrictionGuid
     * @param string $rowName
     * @param int $seatIdInAreaMap
     * @param string $seatName
     * @param \patest\StructType\GlobalString $sectorGlobalName
     * @param string $subscriptionInstanceId
     * @param string $subscriptionNumber
     * @param int $ticketNumber
     */
    public function __construct($areaId = null, $clientId = null, $essentialSeatDataAreaId = null, $essentialSeatDataEventId = null, $essentialSeatDataHolderCompanyId = null, $essentialSeatDataRowName = null, $essentialSeatDataRowOrdinal = null, $essentialSeatDataSeatIdInAreaMap = null, $essentialSeatDataSeatName = null, $essentialSeatDataSeatOrdinal = null, \patest\StructType\GlobalString $essentialSeatDataSectorGlobalName = null, $essentialSeatDataSectorId = null, $essentialSeatDataSectorOrdinal = null, $eventId = null, $id = null, $isLastVersion = null, $isValid = null, $lastTransactionGuid = null, $lastVersionId = null, $localId = null, $originalTicketId = null, $previousVersionId = null, $restrictionGuid = null, $rowName = null, $seatIdInAreaMap = null, $seatName = null, \patest\StructType\GlobalString $sectorGlobalName = null, $subscriptionInstanceId = null, $subscriptionNumber = null, $ticketNumber = null)
    {
        $this
            ->setAreaId($areaId)
            ->setClientId($clientId)
            ->setEssentialSeatDataAreaId($essentialSeatDataAreaId)
            ->setEssentialSeatDataEventId($essentialSeatDataEventId)
            ->setEssentialSeatDataHolderCompanyId($essentialSeatDataHolderCompanyId)
            ->setEssentialSeatDataRowName($essentialSeatDataRowName)
            ->setEssentialSeatDataRowOrdinal($essentialSeatDataRowOrdinal)
            ->setEssentialSeatDataSeatIdInAreaMap($essentialSeatDataSeatIdInAreaMap)
            ->setEssentialSeatDataSeatName($essentialSeatDataSeatName)
            ->setEssentialSeatDataSeatOrdinal($essentialSeatDataSeatOrdinal)
            ->setEssentialSeatDataSectorGlobalName($essentialSeatDataSectorGlobalName)
            ->setEssentialSeatDataSectorId($essentialSeatDataSectorId)
            ->setEssentialSeatDataSectorOrdinal($essentialSeatDataSectorOrdinal)
            ->setEventId($eventId)
            ->setId($id)
            ->setIsLastVersion($isLastVersion)
            ->setIsValid($isValid)
            ->setLastTransactionGuid($lastTransactionGuid)
            ->setLastVersionId($lastVersionId)
            ->setLocalId($localId)
            ->setOriginalTicketId($originalTicketId)
            ->setPreviousVersionId($previousVersionId)
            ->setRestrictionGuid($restrictionGuid)
            ->setRowName($rowName)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatName($seatName)
            ->setSectorGlobalName($sectorGlobalName)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setTicketNumber($ticketNumber);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get EssentialSeatDataAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEssentialSeatDataAreaId()
    {
        return isset($this->EssentialSeatDataAreaId) ? $this->EssentialSeatDataAreaId : null;
    }
    /**
     * Set EssentialSeatDataAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $essentialSeatDataAreaId
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setEssentialSeatDataAreaId($essentialSeatDataAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($essentialSeatDataAreaId) && !is_string($essentialSeatDataAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($essentialSeatDataAreaId, true), gettype($essentialSeatDataAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($essentialSeatDataAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $essentialSeatDataAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($essentialSeatDataAreaId, true)), __LINE__);
        }
        if (is_null($essentialSeatDataAreaId) || (is_array($essentialSeatDataAreaId) && empty($essentialSeatDataAreaId))) {
            unset($this->EssentialSeatDataAreaId);
        } else {
            $this->EssentialSeatDataAreaId = $essentialSeatDataAreaId;
        }
        return $this;
    }
    /**
     * Get EssentialSeatDataEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEssentialSeatDataEventId()
    {
        return isset($this->EssentialSeatDataEventId) ? $this->EssentialSeatDataEventId : null;
    }
    /**
     * Set EssentialSeatDataEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $essentialSeatDataEventId
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setEssentialSeatDataEventId($essentialSeatDataEventId = null)
    {
        // validation for constraint: string
        if (!is_null($essentialSeatDataEventId) && !is_string($essentialSeatDataEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($essentialSeatDataEventId, true), gettype($essentialSeatDataEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($essentialSeatDataEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $essentialSeatDataEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($essentialSeatDataEventId, true)), __LINE__);
        }
        if (is_null($essentialSeatDataEventId) || (is_array($essentialSeatDataEventId) && empty($essentialSeatDataEventId))) {
            unset($this->EssentialSeatDataEventId);
        } else {
            $this->EssentialSeatDataEventId = $essentialSeatDataEventId;
        }
        return $this;
    }
    /**
     * Get EssentialSeatDataHolderCompanyId value
     * @return int|null
     */
    public function getEssentialSeatDataHolderCompanyId()
    {
        return $this->EssentialSeatDataHolderCompanyId;
    }
    /**
     * Set EssentialSeatDataHolderCompanyId value
     * @param int $essentialSeatDataHolderCompanyId
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setEssentialSeatDataHolderCompanyId($essentialSeatDataHolderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($essentialSeatDataHolderCompanyId) && !(is_int($essentialSeatDataHolderCompanyId) || ctype_digit($essentialSeatDataHolderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($essentialSeatDataHolderCompanyId, true), gettype($essentialSeatDataHolderCompanyId)), __LINE__);
        }
        $this->EssentialSeatDataHolderCompanyId = $essentialSeatDataHolderCompanyId;
        return $this;
    }
    /**
     * Get EssentialSeatDataRowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEssentialSeatDataRowName()
    {
        return isset($this->EssentialSeatDataRowName) ? $this->EssentialSeatDataRowName : null;
    }
    /**
     * Set EssentialSeatDataRowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $essentialSeatDataRowName
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setEssentialSeatDataRowName($essentialSeatDataRowName = null)
    {
        // validation for constraint: string
        if (!is_null($essentialSeatDataRowName) && !is_string($essentialSeatDataRowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($essentialSeatDataRowName, true), gettype($essentialSeatDataRowName)), __LINE__);
        }
        if (is_null($essentialSeatDataRowName) || (is_array($essentialSeatDataRowName) && empty($essentialSeatDataRowName))) {
            unset($this->EssentialSeatDataRowName);
        } else {
            $this->EssentialSeatDataRowName = $essentialSeatDataRowName;
        }
        return $this;
    }
    /**
     * Get EssentialSeatDataRowOrdinal value
     * @return int|null
     */
    public function getEssentialSeatDataRowOrdinal()
    {
        return $this->EssentialSeatDataRowOrdinal;
    }
    /**
     * Set EssentialSeatDataRowOrdinal value
     * @param int $essentialSeatDataRowOrdinal
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setEssentialSeatDataRowOrdinal($essentialSeatDataRowOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($essentialSeatDataRowOrdinal) && !(is_int($essentialSeatDataRowOrdinal) || ctype_digit($essentialSeatDataRowOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($essentialSeatDataRowOrdinal, true), gettype($essentialSeatDataRowOrdinal)), __LINE__);
        }
        $this->EssentialSeatDataRowOrdinal = $essentialSeatDataRowOrdinal;
        return $this;
    }
    /**
     * Get EssentialSeatDataSeatIdInAreaMap value
     * @return int|null
     */
    public function getEssentialSeatDataSeatIdInAreaMap()
    {
        return $this->EssentialSeatDataSeatIdInAreaMap;
    }
    /**
     * Set EssentialSeatDataSeatIdInAreaMap value
     * @param int $essentialSeatDataSeatIdInAreaMap
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setEssentialSeatDataSeatIdInAreaMap($essentialSeatDataSeatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($essentialSeatDataSeatIdInAreaMap) && !(is_int($essentialSeatDataSeatIdInAreaMap) || ctype_digit($essentialSeatDataSeatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($essentialSeatDataSeatIdInAreaMap, true), gettype($essentialSeatDataSeatIdInAreaMap)), __LINE__);
        }
        $this->EssentialSeatDataSeatIdInAreaMap = $essentialSeatDataSeatIdInAreaMap;
        return $this;
    }
    /**
     * Get EssentialSeatDataSeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEssentialSeatDataSeatName()
    {
        return isset($this->EssentialSeatDataSeatName) ? $this->EssentialSeatDataSeatName : null;
    }
    /**
     * Set EssentialSeatDataSeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $essentialSeatDataSeatName
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setEssentialSeatDataSeatName($essentialSeatDataSeatName = null)
    {
        // validation for constraint: string
        if (!is_null($essentialSeatDataSeatName) && !is_string($essentialSeatDataSeatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($essentialSeatDataSeatName, true), gettype($essentialSeatDataSeatName)), __LINE__);
        }
        if (is_null($essentialSeatDataSeatName) || (is_array($essentialSeatDataSeatName) && empty($essentialSeatDataSeatName))) {
            unset($this->EssentialSeatDataSeatName);
        } else {
            $this->EssentialSeatDataSeatName = $essentialSeatDataSeatName;
        }
        return $this;
    }
    /**
     * Get EssentialSeatDataSeatOrdinal value
     * @return int|null
     */
    public function getEssentialSeatDataSeatOrdinal()
    {
        return $this->EssentialSeatDataSeatOrdinal;
    }
    /**
     * Set EssentialSeatDataSeatOrdinal value
     * @param int $essentialSeatDataSeatOrdinal
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setEssentialSeatDataSeatOrdinal($essentialSeatDataSeatOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($essentialSeatDataSeatOrdinal) && !(is_int($essentialSeatDataSeatOrdinal) || ctype_digit($essentialSeatDataSeatOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($essentialSeatDataSeatOrdinal, true), gettype($essentialSeatDataSeatOrdinal)), __LINE__);
        }
        $this->EssentialSeatDataSeatOrdinal = $essentialSeatDataSeatOrdinal;
        return $this;
    }
    /**
     * Get EssentialSeatDataSectorGlobalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEssentialSeatDataSectorGlobalName()
    {
        return isset($this->EssentialSeatDataSectorGlobalName) ? $this->EssentialSeatDataSectorGlobalName : null;
    }
    /**
     * Set EssentialSeatDataSectorGlobalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $essentialSeatDataSectorGlobalName
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setEssentialSeatDataSectorGlobalName(\patest\StructType\GlobalString $essentialSeatDataSectorGlobalName = null)
    {
        if (is_null($essentialSeatDataSectorGlobalName) || (is_array($essentialSeatDataSectorGlobalName) && empty($essentialSeatDataSectorGlobalName))) {
            unset($this->EssentialSeatDataSectorGlobalName);
        } else {
            $this->EssentialSeatDataSectorGlobalName = $essentialSeatDataSectorGlobalName;
        }
        return $this;
    }
    /**
     * Get EssentialSeatDataSectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEssentialSeatDataSectorId()
    {
        return isset($this->EssentialSeatDataSectorId) ? $this->EssentialSeatDataSectorId : null;
    }
    /**
     * Set EssentialSeatDataSectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $essentialSeatDataSectorId
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setEssentialSeatDataSectorId($essentialSeatDataSectorId = null)
    {
        // validation for constraint: string
        if (!is_null($essentialSeatDataSectorId) && !is_string($essentialSeatDataSectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($essentialSeatDataSectorId, true), gettype($essentialSeatDataSectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($essentialSeatDataSectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $essentialSeatDataSectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($essentialSeatDataSectorId, true)), __LINE__);
        }
        if (is_null($essentialSeatDataSectorId) || (is_array($essentialSeatDataSectorId) && empty($essentialSeatDataSectorId))) {
            unset($this->EssentialSeatDataSectorId);
        } else {
            $this->EssentialSeatDataSectorId = $essentialSeatDataSectorId;
        }
        return $this;
    }
    /**
     * Get EssentialSeatDataSectorOrdinal value
     * @return int|null
     */
    public function getEssentialSeatDataSectorOrdinal()
    {
        return $this->EssentialSeatDataSectorOrdinal;
    }
    /**
     * Set EssentialSeatDataSectorOrdinal value
     * @param int $essentialSeatDataSectorOrdinal
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setEssentialSeatDataSectorOrdinal($essentialSeatDataSectorOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($essentialSeatDataSectorOrdinal) && !(is_int($essentialSeatDataSectorOrdinal) || ctype_digit($essentialSeatDataSectorOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($essentialSeatDataSectorOrdinal, true), gettype($essentialSeatDataSectorOrdinal)), __LINE__);
        }
        $this->EssentialSeatDataSectorOrdinal = $essentialSeatDataSectorOrdinal;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsLastVersion value
     * @return bool|null
     */
    public function getIsLastVersion()
    {
        return $this->IsLastVersion;
    }
    /**
     * Set IsLastVersion value
     * @param bool $isLastVersion
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setIsLastVersion($isLastVersion = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLastVersion) && !is_bool($isLastVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLastVersion, true), gettype($isLastVersion)), __LINE__);
        }
        $this->IsLastVersion = $isLastVersion;
        return $this;
    }
    /**
     * Get IsValid value
     * @return bool|null
     */
    public function getIsValid()
    {
        return $this->IsValid;
    }
    /**
     * Set IsValid value
     * @param bool $isValid
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        $this->IsValid = $isValid;
        return $this;
    }
    /**
     * Get LastTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastTransactionGuid()
    {
        return isset($this->LastTransactionGuid) ? $this->LastTransactionGuid : null;
    }
    /**
     * Set LastTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastTransactionGuid
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setLastTransactionGuid($lastTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($lastTransactionGuid) && !is_string($lastTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastTransactionGuid, true), gettype($lastTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastTransactionGuid, true)), __LINE__);
        }
        if (is_null($lastTransactionGuid) || (is_array($lastTransactionGuid) && empty($lastTransactionGuid))) {
            unset($this->LastTransactionGuid);
        } else {
            $this->LastTransactionGuid = $lastTransactionGuid;
        }
        return $this;
    }
    /**
     * Get LastVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastVersionId()
    {
        return isset($this->LastVersionId) ? $this->LastVersionId : null;
    }
    /**
     * Set LastVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastVersionId
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setLastVersionId($lastVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($lastVersionId) && !is_string($lastVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastVersionId, true), gettype($lastVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastVersionId, true)), __LINE__);
        }
        if (is_null($lastVersionId) || (is_array($lastVersionId) && empty($lastVersionId))) {
            unset($this->LastVersionId);
        } else {
            $this->LastVersionId = $lastVersionId;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * @return int|null
     */
    public function getLocalId()
    {
        return $this->LocalId;
    }
    /**
     * Set LocalId value
     * @param int $localId
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        $this->LocalId = $localId;
        return $this;
    }
    /**
     * Get OriginalTicketId value
     * @return string|null
     */
    public function getOriginalTicketId()
    {
        return $this->OriginalTicketId;
    }
    /**
     * Set OriginalTicketId value
     * @param string $originalTicketId
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setOriginalTicketId($originalTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($originalTicketId) && !is_string($originalTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTicketId, true), gettype($originalTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalTicketId, true)), __LINE__);
        }
        $this->OriginalTicketId = $originalTicketId;
        return $this;
    }
    /**
     * Get PreviousVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviousVersionId()
    {
        return isset($this->PreviousVersionId) ? $this->PreviousVersionId : null;
    }
    /**
     * Set PreviousVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previousVersionId
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setPreviousVersionId($previousVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($previousVersionId) && !is_string($previousVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousVersionId, true), gettype($previousVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($previousVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $previousVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($previousVersionId, true)), __LINE__);
        }
        if (is_null($previousVersionId) || (is_array($previousVersionId) && empty($previousVersionId))) {
            unset($this->PreviousVersionId);
        } else {
            $this->PreviousVersionId = $previousVersionId;
        }
        return $this;
    }
    /**
     * Get RestrictionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionGuid()
    {
        return isset($this->RestrictionGuid) ? $this->RestrictionGuid : null;
    }
    /**
     * Set RestrictionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionGuid
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setRestrictionGuid($restrictionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionGuid) && !is_string($restrictionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionGuid, true), gettype($restrictionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($restrictionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $restrictionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($restrictionGuid, true)), __LINE__);
        }
        if (is_null($restrictionGuid) || (is_array($restrictionGuid) && empty($restrictionGuid))) {
            unset($this->RestrictionGuid);
        } else {
            $this->RestrictionGuid = $restrictionGuid;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return $this->SeatIdInAreaMap;
    }
    /**
     * Set SeatIdInAreaMap value
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        $this->SeatIdInAreaMap = $seatIdInAreaMap;
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorGlobalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorGlobalName()
    {
        return isset($this->SectorGlobalName) ? $this->SectorGlobalName : null;
    }
    /**
     * Set SectorGlobalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorGlobalName
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setSectorGlobalName(\patest\StructType\GlobalString $sectorGlobalName = null)
    {
        if (is_null($sectorGlobalName) || (is_array($sectorGlobalName) && empty($sectorGlobalName))) {
            unset($this->SectorGlobalName);
        } else {
            $this->SectorGlobalName = $sectorGlobalName;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return int|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param int $ticketNumber
     * @return \patest\StructType\BulkEventOwnershipEntry
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
}
