<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.OrderVisitActivityCategory StructType
 * @subpackage Structs
 */
class BizResource_OrderVisitActivityCategory extends BizResource_PersistableEntityBase
{
    /**
     * The ActivityCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActivityCategoryId;
    /**
     * The BizResourceRequestId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BizResourceRequestId;
    /**
     * The OrderVisitActivityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderVisitActivityId;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * Constructor method for BizResource.OrderVisitActivityCategory
     * @uses BizResource_OrderVisitActivityCategory::setActivityCategoryId()
     * @uses BizResource_OrderVisitActivityCategory::setBizResourceRequestId()
     * @uses BizResource_OrderVisitActivityCategory::setOrderVisitActivityId()
     * @uses BizResource_OrderVisitActivityCategory::setTypeId()
     * @param string $activityCategoryId
     * @param string $bizResourceRequestId
     * @param string $orderVisitActivityId
     * @param string $typeId
     */
    public function __construct($activityCategoryId = null, $bizResourceRequestId = null, $orderVisitActivityId = null, $typeId = null)
    {
        $this
            ->setActivityCategoryId($activityCategoryId)
            ->setBizResourceRequestId($bizResourceRequestId)
            ->setOrderVisitActivityId($orderVisitActivityId)
            ->setTypeId($typeId);
    }
    /**
     * Get ActivityCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityCategoryId()
    {
        return isset($this->ActivityCategoryId) ? $this->ActivityCategoryId : null;
    }
    /**
     * Set ActivityCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityCategoryId
     * @return \patest\StructType\BizResource_OrderVisitActivityCategory
     */
    public function setActivityCategoryId($activityCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($activityCategoryId) && !is_string($activityCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityCategoryId, true), gettype($activityCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($activityCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $activityCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($activityCategoryId, true)), __LINE__);
        }
        if (is_null($activityCategoryId) || (is_array($activityCategoryId) && empty($activityCategoryId))) {
            unset($this->ActivityCategoryId);
        } else {
            $this->ActivityCategoryId = $activityCategoryId;
        }
        return $this;
    }
    /**
     * Get BizResourceRequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBizResourceRequestId()
    {
        return isset($this->BizResourceRequestId) ? $this->BizResourceRequestId : null;
    }
    /**
     * Set BizResourceRequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bizResourceRequestId
     * @return \patest\StructType\BizResource_OrderVisitActivityCategory
     */
    public function setBizResourceRequestId($bizResourceRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($bizResourceRequestId) && !is_string($bizResourceRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bizResourceRequestId, true), gettype($bizResourceRequestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bizResourceRequestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bizResourceRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bizResourceRequestId, true)), __LINE__);
        }
        if (is_null($bizResourceRequestId) || (is_array($bizResourceRequestId) && empty($bizResourceRequestId))) {
            unset($this->BizResourceRequestId);
        } else {
            $this->BizResourceRequestId = $bizResourceRequestId;
        }
        return $this;
    }
    /**
     * Get OrderVisitActivityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitActivityId()
    {
        return isset($this->OrderVisitActivityId) ? $this->OrderVisitActivityId : null;
    }
    /**
     * Set OrderVisitActivityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitActivityId
     * @return \patest\StructType\BizResource_OrderVisitActivityCategory
     */
    public function setOrderVisitActivityId($orderVisitActivityId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitActivityId) && !is_string($orderVisitActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitActivityId, true), gettype($orderVisitActivityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderVisitActivityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderVisitActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderVisitActivityId, true)), __LINE__);
        }
        if (is_null($orderVisitActivityId) || (is_array($orderVisitActivityId) && empty($orderVisitActivityId))) {
            unset($this->OrderVisitActivityId);
        } else {
            $this->OrderVisitActivityId = $orderVisitActivityId;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\BizResource_OrderVisitActivityCategory
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
}
