<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.OrderVisit StructType
 * @subpackage Structs
 */
class BizResource_OrderVisit extends BizResource_PersistableEntityBase
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The Arrived
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Arrived;
    /**
     * The BillingItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_BillingItem
     */
    public $BillingItems;
    /**
     * The Classes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Classes;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Comment;
    /**
     * The ConfirmationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationDate;
    /**
     * The ContactId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContactId;
    /**
     * The DisplayStyleValue
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayStyleValue;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The GradeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeId;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupName;
    /**
     * The GroupSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupSize;
    /**
     * The GuideAllocationStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GuideAllocationStatus;
    /**
     * The HomePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhone;
    /**
     * The IsResourcesAllocated
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsResourcesAllocated;
    /**
     * The MinStartTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinStartTime;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mobile;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OrderDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderDate;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderId;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OrderNumber;
    /**
     * The OrderPayerAccountId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderPayerAccountId;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderType;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PayerAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayerAccountId;
    /**
     * The PreferredEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredEndDate;
    /**
     * The PreferredStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredStartDate;
    /**
     * The PricedGuidance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_VisitPricedGuidance
     */
    public $PricedGuidance;
    /**
     * The PriceToPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PriceToPay;
    /**
     * The PricingPerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PricingPerType;
    /**
     * The ProposalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ProposalAmount;
    /**
     * The ProposalDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProposalDate;
    /**
     * The ProposalExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProposalExpiryDate;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_BizService
     */
    public $Services;
    /**
     * The SkillIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SkillIds
     */
    public $SkillIds;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalPrice;
    /**
     * The VisitDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitDate;
    /**
     * The VisitEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitEndDate;
    /**
     * The VisitNatureId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitNatureId;
    /**
     * The VisitPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitPlanId;
    /**
     * The VisitPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_VisitPrice
     */
    public $VisitPrices;
    /**
     * The VisitTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitTypeId;
    /**
     * Constructor method for BizResource.OrderVisit
     * @uses BizResource_OrderVisit::setAclSchemeId()
     * @uses BizResource_OrderVisit::setArrived()
     * @uses BizResource_OrderVisit::setBillingItems()
     * @uses BizResource_OrderVisit::setClasses()
     * @uses BizResource_OrderVisit::setComment()
     * @uses BizResource_OrderVisit::setConfirmationDate()
     * @uses BizResource_OrderVisit::setContactId()
     * @uses BizResource_OrderVisit::setDisplayStyleValue()
     * @uses BizResource_OrderVisit::setEmail()
     * @uses BizResource_OrderVisit::setFax()
     * @uses BizResource_OrderVisit::setGradeId()
     * @uses BizResource_OrderVisit::setGroupName()
     * @uses BizResource_OrderVisit::setGroupSize()
     * @uses BizResource_OrderVisit::setGuideAllocationStatus()
     * @uses BizResource_OrderVisit::setHomePhone()
     * @uses BizResource_OrderVisit::setIsResourcesAllocated()
     * @uses BizResource_OrderVisit::setMinStartTime()
     * @uses BizResource_OrderVisit::setMobile()
     * @uses BizResource_OrderVisit::setName()
     * @uses BizResource_OrderVisit::setOrderDate()
     * @uses BizResource_OrderVisit::setOrderId()
     * @uses BizResource_OrderVisit::setOrderNumber()
     * @uses BizResource_OrderVisit::setOrderPayerAccountId()
     * @uses BizResource_OrderVisit::setOrderType()
     * @uses BizResource_OrderVisit::setOrganizationUnitId()
     * @uses BizResource_OrderVisit::setPayerAccountId()
     * @uses BizResource_OrderVisit::setPreferredEndDate()
     * @uses BizResource_OrderVisit::setPreferredStartDate()
     * @uses BizResource_OrderVisit::setPricedGuidance()
     * @uses BizResource_OrderVisit::setPriceToPay()
     * @uses BizResource_OrderVisit::setPricingPerType()
     * @uses BizResource_OrderVisit::setProposalAmount()
     * @uses BizResource_OrderVisit::setProposalDate()
     * @uses BizResource_OrderVisit::setProposalExpiryDate()
     * @uses BizResource_OrderVisit::setServices()
     * @uses BizResource_OrderVisit::setSkillIds()
     * @uses BizResource_OrderVisit::setStatus()
     * @uses BizResource_OrderVisit::setTotalPrice()
     * @uses BizResource_OrderVisit::setVisitDate()
     * @uses BizResource_OrderVisit::setVisitEndDate()
     * @uses BizResource_OrderVisit::setVisitNatureId()
     * @uses BizResource_OrderVisit::setVisitPlanId()
     * @uses BizResource_OrderVisit::setVisitPrices()
     * @uses BizResource_OrderVisit::setVisitTypeId()
     * @param int $aclSchemeId
     * @param int $arrived
     * @param \patest\StructType\RecordSetOfBizResource_BillingItem $billingItems
     * @param string $classes
     * @param \patest\StructType\GlobalString $comment
     * @param string $confirmationDate
     * @param string $contactId
     * @param string $displayStyleValue
     * @param string $email
     * @param string $fax
     * @param string $gradeId
     * @param string $groupName
     * @param int $groupSize
     * @param string $guideAllocationStatus
     * @param string $homePhone
     * @param bool $isResourcesAllocated
     * @param string $minStartTime
     * @param string $mobile
     * @param string $name
     * @param string $orderDate
     * @param string $orderId
     * @param int $orderNumber
     * @param string $orderPayerAccountId
     * @param string $orderType
     * @param string $organizationUnitId
     * @param string $payerAccountId
     * @param string $preferredEndDate
     * @param string $preferredStartDate
     * @param \patest\StructType\RecordSetOfBizResource_VisitPricedGuidance $pricedGuidance
     * @param float $priceToPay
     * @param string $pricingPerType
     * @param float $proposalAmount
     * @param string $proposalDate
     * @param string $proposalExpiryDate
     * @param \patest\StructType\RecordSetOfBizResource_BizService $services
     * @param \patest\StructType\SkillIds $skillIds
     * @param string $status
     * @param float $totalPrice
     * @param string $visitDate
     * @param string $visitEndDate
     * @param string $visitNatureId
     * @param string $visitPlanId
     * @param \patest\StructType\RecordSetOfBizResource_VisitPrice $visitPrices
     * @param string $visitTypeId
     */
    public function __construct($aclSchemeId = null, $arrived = null, \patest\StructType\RecordSetOfBizResource_BillingItem $billingItems = null, $classes = null, \patest\StructType\GlobalString $comment = null, $confirmationDate = null, $contactId = null, $displayStyleValue = null, $email = null, $fax = null, $gradeId = null, $groupName = null, $groupSize = null, $guideAllocationStatus = null, $homePhone = null, $isResourcesAllocated = null, $minStartTime = null, $mobile = null, $name = null, $orderDate = null, $orderId = null, $orderNumber = null, $orderPayerAccountId = null, $orderType = null, $organizationUnitId = null, $payerAccountId = null, $preferredEndDate = null, $preferredStartDate = null, \patest\StructType\RecordSetOfBizResource_VisitPricedGuidance $pricedGuidance = null, $priceToPay = null, $pricingPerType = null, $proposalAmount = null, $proposalDate = null, $proposalExpiryDate = null, \patest\StructType\RecordSetOfBizResource_BizService $services = null, \patest\StructType\SkillIds $skillIds = null, $status = null, $totalPrice = null, $visitDate = null, $visitEndDate = null, $visitNatureId = null, $visitPlanId = null, \patest\StructType\RecordSetOfBizResource_VisitPrice $visitPrices = null, $visitTypeId = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setArrived($arrived)
            ->setBillingItems($billingItems)
            ->setClasses($classes)
            ->setComment($comment)
            ->setConfirmationDate($confirmationDate)
            ->setContactId($contactId)
            ->setDisplayStyleValue($displayStyleValue)
            ->setEmail($email)
            ->setFax($fax)
            ->setGradeId($gradeId)
            ->setGroupName($groupName)
            ->setGroupSize($groupSize)
            ->setGuideAllocationStatus($guideAllocationStatus)
            ->setHomePhone($homePhone)
            ->setIsResourcesAllocated($isResourcesAllocated)
            ->setMinStartTime($minStartTime)
            ->setMobile($mobile)
            ->setName($name)
            ->setOrderDate($orderDate)
            ->setOrderId($orderId)
            ->setOrderNumber($orderNumber)
            ->setOrderPayerAccountId($orderPayerAccountId)
            ->setOrderType($orderType)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPayerAccountId($payerAccountId)
            ->setPreferredEndDate($preferredEndDate)
            ->setPreferredStartDate($preferredStartDate)
            ->setPricedGuidance($pricedGuidance)
            ->setPriceToPay($priceToPay)
            ->setPricingPerType($pricingPerType)
            ->setProposalAmount($proposalAmount)
            ->setProposalDate($proposalDate)
            ->setProposalExpiryDate($proposalExpiryDate)
            ->setServices($services)
            ->setSkillIds($skillIds)
            ->setStatus($status)
            ->setTotalPrice($totalPrice)
            ->setVisitDate($visitDate)
            ->setVisitEndDate($visitEndDate)
            ->setVisitNatureId($visitNatureId)
            ->setVisitPlanId($visitPlanId)
            ->setVisitPrices($visitPrices)
            ->setVisitTypeId($visitTypeId);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get Arrived value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArrived()
    {
        return isset($this->Arrived) ? $this->Arrived : null;
    }
    /**
     * Set Arrived value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $arrived
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setArrived($arrived = null)
    {
        // validation for constraint: int
        if (!is_null($arrived) && !(is_int($arrived) || ctype_digit($arrived))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($arrived, true), gettype($arrived)), __LINE__);
        }
        if (is_null($arrived) || (is_array($arrived) && empty($arrived))) {
            unset($this->Arrived);
        } else {
            $this->Arrived = $arrived;
        }
        return $this;
    }
    /**
     * Get BillingItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_BillingItem|null
     */
    public function getBillingItems()
    {
        return isset($this->BillingItems) ? $this->BillingItems : null;
    }
    /**
     * Set BillingItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_BillingItem $billingItems
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setBillingItems(\patest\StructType\RecordSetOfBizResource_BillingItem $billingItems = null)
    {
        if (is_null($billingItems) || (is_array($billingItems) && empty($billingItems))) {
            unset($this->BillingItems);
        } else {
            $this->BillingItems = $billingItems;
        }
        return $this;
    }
    /**
     * Get Classes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClasses()
    {
        return isset($this->Classes) ? $this->Classes : null;
    }
    /**
     * Set Classes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classes
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setClasses($classes = null)
    {
        // validation for constraint: string
        if (!is_null($classes) && !is_string($classes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classes, true), gettype($classes)), __LINE__);
        }
        if (is_null($classes) || (is_array($classes) && empty($classes))) {
            unset($this->Classes);
        } else {
            $this->Classes = $classes;
        }
        return $this;
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $comment
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setComment(\patest\StructType\GlobalString $comment = null)
    {
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get ConfirmationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationDate()
    {
        return isset($this->ConfirmationDate) ? $this->ConfirmationDate : null;
    }
    /**
     * Set ConfirmationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationDate
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setConfirmationDate($confirmationDate = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationDate) && !is_string($confirmationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationDate, true), gettype($confirmationDate)), __LINE__);
        }
        if (is_null($confirmationDate) || (is_array($confirmationDate) && empty($confirmationDate))) {
            unset($this->ConfirmationDate);
        } else {
            $this->ConfirmationDate = $confirmationDate;
        }
        return $this;
    }
    /**
     * Get ContactId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactId()
    {
        return isset($this->ContactId) ? $this->ContactId : null;
    }
    /**
     * Set ContactId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactId
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contactId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contactId, true)), __LINE__);
        }
        if (is_null($contactId) || (is_array($contactId) && empty($contactId))) {
            unset($this->ContactId);
        } else {
            $this->ContactId = $contactId;
        }
        return $this;
    }
    /**
     * Get DisplayStyleValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayStyleValue()
    {
        return isset($this->DisplayStyleValue) ? $this->DisplayStyleValue : null;
    }
    /**
     * Set DisplayStyleValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayStyleValue
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setDisplayStyleValue($displayStyleValue = null)
    {
        // validation for constraint: string
        if (!is_null($displayStyleValue) && !is_string($displayStyleValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayStyleValue, true), gettype($displayStyleValue)), __LINE__);
        }
        if (is_null($displayStyleValue) || (is_array($displayStyleValue) && empty($displayStyleValue))) {
            unset($this->DisplayStyleValue);
        } else {
            $this->DisplayStyleValue = $displayStyleValue;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get GradeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGradeId()
    {
        return isset($this->GradeId) ? $this->GradeId : null;
    }
    /**
     * Set GradeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gradeId
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setGradeId($gradeId = null)
    {
        // validation for constraint: string
        if (!is_null($gradeId) && !is_string($gradeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gradeId, true), gettype($gradeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($gradeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($gradeId, true)), __LINE__);
        }
        if (is_null($gradeId) || (is_array($gradeId) && empty($gradeId))) {
            unset($this->GradeId);
        } else {
            $this->GradeId = $gradeId;
        }
        return $this;
    }
    /**
     * Get GroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupName()
    {
        return isset($this->GroupName) ? $this->GroupName : null;
    }
    /**
     * Set GroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupName
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        if (is_null($groupName) || (is_array($groupName) && empty($groupName))) {
            unset($this->GroupName);
        } else {
            $this->GroupName = $groupName;
        }
        return $this;
    }
    /**
     * Get GroupSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupSize()
    {
        return isset($this->GroupSize) ? $this->GroupSize : null;
    }
    /**
     * Set GroupSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupSize
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setGroupSize($groupSize = null)
    {
        // validation for constraint: int
        if (!is_null($groupSize) && !(is_int($groupSize) || ctype_digit($groupSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupSize, true), gettype($groupSize)), __LINE__);
        }
        if (is_null($groupSize) || (is_array($groupSize) && empty($groupSize))) {
            unset($this->GroupSize);
        } else {
            $this->GroupSize = $groupSize;
        }
        return $this;
    }
    /**
     * Get GuideAllocationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuideAllocationStatus()
    {
        return isset($this->GuideAllocationStatus) ? $this->GuideAllocationStatus : null;
    }
    /**
     * Set GuideAllocationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AllocationStatus::valueIsValid()
     * @uses \patest\EnumType\AllocationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $guideAllocationStatus
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setGuideAllocationStatus($guideAllocationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AllocationStatus::valueIsValid($guideAllocationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AllocationStatus', is_array($guideAllocationStatus) ? implode(', ', $guideAllocationStatus) : var_export($guideAllocationStatus, true), implode(', ', \patest\EnumType\AllocationStatus::getValidValues())), __LINE__);
        }
        if (is_null($guideAllocationStatus) || (is_array($guideAllocationStatus) && empty($guideAllocationStatus))) {
            unset($this->GuideAllocationStatus);
        } else {
            $this->GuideAllocationStatus = $guideAllocationStatus;
        }
        return $this;
    }
    /**
     * Get HomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhone()
    {
        return isset($this->HomePhone) ? $this->HomePhone : null;
    }
    /**
     * Set HomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhone
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        if (is_null($homePhone) || (is_array($homePhone) && empty($homePhone))) {
            unset($this->HomePhone);
        } else {
            $this->HomePhone = $homePhone;
        }
        return $this;
    }
    /**
     * Get IsResourcesAllocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsResourcesAllocated()
    {
        return isset($this->IsResourcesAllocated) ? $this->IsResourcesAllocated : null;
    }
    /**
     * Set IsResourcesAllocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isResourcesAllocated
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setIsResourcesAllocated($isResourcesAllocated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResourcesAllocated) && !is_bool($isResourcesAllocated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResourcesAllocated, true), gettype($isResourcesAllocated)), __LINE__);
        }
        if (is_null($isResourcesAllocated) || (is_array($isResourcesAllocated) && empty($isResourcesAllocated))) {
            unset($this->IsResourcesAllocated);
        } else {
            $this->IsResourcesAllocated = $isResourcesAllocated;
        }
        return $this;
    }
    /**
     * Get MinStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinStartTime()
    {
        return isset($this->MinStartTime) ? $this->MinStartTime : null;
    }
    /**
     * Set MinStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minStartTime
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setMinStartTime($minStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($minStartTime) && !is_string($minStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minStartTime, true), gettype($minStartTime)), __LINE__);
        }
        if (is_null($minStartTime) || (is_array($minStartTime) && empty($minStartTime))) {
            unset($this->MinStartTime);
        } else {
            $this->MinStartTime = $minStartTime;
        }
        return $this;
    }
    /**
     * Get Mobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobile()
    {
        return isset($this->Mobile) ? $this->Mobile : null;
    }
    /**
     * Set Mobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobile
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        if (is_null($mobile) || (is_array($mobile) && empty($mobile))) {
            unset($this->Mobile);
        } else {
            $this->Mobile = $mobile;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrderDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderDate()
    {
        return isset($this->OrderDate) ? $this->OrderDate : null;
    }
    /**
     * Set OrderDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderDate
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDate, true), gettype($orderDate)), __LINE__);
        }
        if (is_null($orderDate) || (is_array($orderDate) && empty($orderDate))) {
            unset($this->OrderDate);
        } else {
            $this->OrderDate = $orderDate;
        }
        return $this;
    }
    /**
     * Get OrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderId()
    {
        return isset($this->OrderId) ? $this->OrderId : null;
    }
    /**
     * Set OrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderId
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderId, true)), __LINE__);
        }
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->OrderId);
        } else {
            $this->OrderId = $orderId;
        }
        return $this;
    }
    /**
     * Get OrderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderNumber()
    {
        return isset($this->OrderNumber) ? $this->OrderNumber : null;
    }
    /**
     * Set OrderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderNumber
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderNumber) && !(is_int($orderNumber) || ctype_digit($orderNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->OrderNumber);
        } else {
            $this->OrderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Get OrderPayerAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderPayerAccountId()
    {
        return isset($this->OrderPayerAccountId) ? $this->OrderPayerAccountId : null;
    }
    /**
     * Set OrderPayerAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderPayerAccountId
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setOrderPayerAccountId($orderPayerAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($orderPayerAccountId) && !is_string($orderPayerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderPayerAccountId, true), gettype($orderPayerAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderPayerAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderPayerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderPayerAccountId, true)), __LINE__);
        }
        if (is_null($orderPayerAccountId) || (is_array($orderPayerAccountId) && empty($orderPayerAccountId))) {
            unset($this->OrderPayerAccountId);
        } else {
            $this->OrderPayerAccountId = $orderPayerAccountId;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OrderType::valueIsValid()
     * @uses \patest\EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OrderType::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OrderType', is_array($orderType) ? implode(', ', $orderType) : var_export($orderType, true), implode(', ', \patest\EnumType\OrderType::getValidValues())), __LINE__);
        }
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PayerAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerAccountId()
    {
        return isset($this->PayerAccountId) ? $this->PayerAccountId : null;
    }
    /**
     * Set PayerAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerAccountId
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setPayerAccountId($payerAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($payerAccountId) && !is_string($payerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerAccountId, true), gettype($payerAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payerAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payerAccountId, true)), __LINE__);
        }
        if (is_null($payerAccountId) || (is_array($payerAccountId) && empty($payerAccountId))) {
            unset($this->PayerAccountId);
        } else {
            $this->PayerAccountId = $payerAccountId;
        }
        return $this;
    }
    /**
     * Get PreferredEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredEndDate()
    {
        return isset($this->PreferredEndDate) ? $this->PreferredEndDate : null;
    }
    /**
     * Set PreferredEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredEndDate
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setPreferredEndDate($preferredEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($preferredEndDate) && !is_string($preferredEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredEndDate, true), gettype($preferredEndDate)), __LINE__);
        }
        if (is_null($preferredEndDate) || (is_array($preferredEndDate) && empty($preferredEndDate))) {
            unset($this->PreferredEndDate);
        } else {
            $this->PreferredEndDate = $preferredEndDate;
        }
        return $this;
    }
    /**
     * Get PreferredStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredStartDate()
    {
        return isset($this->PreferredStartDate) ? $this->PreferredStartDate : null;
    }
    /**
     * Set PreferredStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredStartDate
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setPreferredStartDate($preferredStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($preferredStartDate) && !is_string($preferredStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredStartDate, true), gettype($preferredStartDate)), __LINE__);
        }
        if (is_null($preferredStartDate) || (is_array($preferredStartDate) && empty($preferredStartDate))) {
            unset($this->PreferredStartDate);
        } else {
            $this->PreferredStartDate = $preferredStartDate;
        }
        return $this;
    }
    /**
     * Get PricedGuidance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_VisitPricedGuidance|null
     */
    public function getPricedGuidance()
    {
        return isset($this->PricedGuidance) ? $this->PricedGuidance : null;
    }
    /**
     * Set PricedGuidance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_VisitPricedGuidance $pricedGuidance
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setPricedGuidance(\patest\StructType\RecordSetOfBizResource_VisitPricedGuidance $pricedGuidance = null)
    {
        if (is_null($pricedGuidance) || (is_array($pricedGuidance) && empty($pricedGuidance))) {
            unset($this->PricedGuidance);
        } else {
            $this->PricedGuidance = $pricedGuidance;
        }
        return $this;
    }
    /**
     * Get PriceToPay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPriceToPay()
    {
        return isset($this->PriceToPay) ? $this->PriceToPay : null;
    }
    /**
     * Set PriceToPay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $priceToPay
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setPriceToPay($priceToPay = null)
    {
        // validation for constraint: float
        if (!is_null($priceToPay) && !(is_float($priceToPay) || is_numeric($priceToPay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceToPay, true), gettype($priceToPay)), __LINE__);
        }
        if (is_null($priceToPay) || (is_array($priceToPay) && empty($priceToPay))) {
            unset($this->PriceToPay);
        } else {
            $this->PriceToPay = $priceToPay;
        }
        return $this;
    }
    /**
     * Get PricingPerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricingPerType()
    {
        return isset($this->PricingPerType) ? $this->PricingPerType : null;
    }
    /**
     * Set PricingPerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PricingPerType::valueIsValid()
     * @uses \patest\EnumType\PricingPerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingPerType
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setPricingPerType($pricingPerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PricingPerType::valueIsValid($pricingPerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PricingPerType', is_array($pricingPerType) ? implode(', ', $pricingPerType) : var_export($pricingPerType, true), implode(', ', \patest\EnumType\PricingPerType::getValidValues())), __LINE__);
        }
        if (is_null($pricingPerType) || (is_array($pricingPerType) && empty($pricingPerType))) {
            unset($this->PricingPerType);
        } else {
            $this->PricingPerType = $pricingPerType;
        }
        return $this;
    }
    /**
     * Get ProposalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getProposalAmount()
    {
        return isset($this->ProposalAmount) ? $this->ProposalAmount : null;
    }
    /**
     * Set ProposalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $proposalAmount
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setProposalAmount($proposalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($proposalAmount) && !(is_float($proposalAmount) || is_numeric($proposalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($proposalAmount, true), gettype($proposalAmount)), __LINE__);
        }
        if (is_null($proposalAmount) || (is_array($proposalAmount) && empty($proposalAmount))) {
            unset($this->ProposalAmount);
        } else {
            $this->ProposalAmount = $proposalAmount;
        }
        return $this;
    }
    /**
     * Get ProposalDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProposalDate()
    {
        return isset($this->ProposalDate) ? $this->ProposalDate : null;
    }
    /**
     * Set ProposalDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $proposalDate
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setProposalDate($proposalDate = null)
    {
        // validation for constraint: string
        if (!is_null($proposalDate) && !is_string($proposalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proposalDate, true), gettype($proposalDate)), __LINE__);
        }
        if (is_null($proposalDate) || (is_array($proposalDate) && empty($proposalDate))) {
            unset($this->ProposalDate);
        } else {
            $this->ProposalDate = $proposalDate;
        }
        return $this;
    }
    /**
     * Get ProposalExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProposalExpiryDate()
    {
        return isset($this->ProposalExpiryDate) ? $this->ProposalExpiryDate : null;
    }
    /**
     * Set ProposalExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $proposalExpiryDate
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setProposalExpiryDate($proposalExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($proposalExpiryDate) && !is_string($proposalExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proposalExpiryDate, true), gettype($proposalExpiryDate)), __LINE__);
        }
        if (is_null($proposalExpiryDate) || (is_array($proposalExpiryDate) && empty($proposalExpiryDate))) {
            unset($this->ProposalExpiryDate);
        } else {
            $this->ProposalExpiryDate = $proposalExpiryDate;
        }
        return $this;
    }
    /**
     * Get Services value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_BizService|null
     */
    public function getServices()
    {
        return isset($this->Services) ? $this->Services : null;
    }
    /**
     * Set Services value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_BizService $services
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setServices(\patest\StructType\RecordSetOfBizResource_BizService $services = null)
    {
        if (is_null($services) || (is_array($services) && empty($services))) {
            unset($this->Services);
        } else {
            $this->Services = $services;
        }
        return $this;
    }
    /**
     * Get SkillIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SkillIds|null
     */
    public function getSkillIds()
    {
        return isset($this->SkillIds) ? $this->SkillIds : null;
    }
    /**
     * Set SkillIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SkillIds $skillIds
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setSkillIds(\patest\StructType\SkillIds $skillIds = null)
    {
        if (is_null($skillIds) || (is_array($skillIds) && empty($skillIds))) {
            unset($this->SkillIds);
        } else {
            $this->SkillIds = $skillIds;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OrderVisitStatus::valueIsValid()
     * @uses \patest\EnumType\OrderVisitStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OrderVisitStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OrderVisitStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\OrderVisitStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalPrice
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
    /**
     * Get VisitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitDate()
    {
        return isset($this->VisitDate) ? $this->VisitDate : null;
    }
    /**
     * Set VisitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitDate
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setVisitDate($visitDate = null)
    {
        // validation for constraint: string
        if (!is_null($visitDate) && !is_string($visitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitDate, true), gettype($visitDate)), __LINE__);
        }
        if (is_null($visitDate) || (is_array($visitDate) && empty($visitDate))) {
            unset($this->VisitDate);
        } else {
            $this->VisitDate = $visitDate;
        }
        return $this;
    }
    /**
     * Get VisitEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitEndDate()
    {
        return isset($this->VisitEndDate) ? $this->VisitEndDate : null;
    }
    /**
     * Set VisitEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitEndDate
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setVisitEndDate($visitEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($visitEndDate) && !is_string($visitEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitEndDate, true), gettype($visitEndDate)), __LINE__);
        }
        if (is_null($visitEndDate) || (is_array($visitEndDate) && empty($visitEndDate))) {
            unset($this->VisitEndDate);
        } else {
            $this->VisitEndDate = $visitEndDate;
        }
        return $this;
    }
    /**
     * Get VisitNatureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitNatureId()
    {
        return isset($this->VisitNatureId) ? $this->VisitNatureId : null;
    }
    /**
     * Set VisitNatureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitNatureId
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setVisitNatureId($visitNatureId = null)
    {
        // validation for constraint: string
        if (!is_null($visitNatureId) && !is_string($visitNatureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitNatureId, true), gettype($visitNatureId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitNatureId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitNatureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitNatureId, true)), __LINE__);
        }
        if (is_null($visitNatureId) || (is_array($visitNatureId) && empty($visitNatureId))) {
            unset($this->VisitNatureId);
        } else {
            $this->VisitNatureId = $visitNatureId;
        }
        return $this;
    }
    /**
     * Get VisitPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitPlanId()
    {
        return isset($this->VisitPlanId) ? $this->VisitPlanId : null;
    }
    /**
     * Set VisitPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitPlanId
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setVisitPlanId($visitPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($visitPlanId) && !is_string($visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitPlanId, true), gettype($visitPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitPlanId, true)), __LINE__);
        }
        if (is_null($visitPlanId) || (is_array($visitPlanId) && empty($visitPlanId))) {
            unset($this->VisitPlanId);
        } else {
            $this->VisitPlanId = $visitPlanId;
        }
        return $this;
    }
    /**
     * Get VisitPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_VisitPrice|null
     */
    public function getVisitPrices()
    {
        return isset($this->VisitPrices) ? $this->VisitPrices : null;
    }
    /**
     * Set VisitPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_VisitPrice $visitPrices
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setVisitPrices(\patest\StructType\RecordSetOfBizResource_VisitPrice $visitPrices = null)
    {
        if (is_null($visitPrices) || (is_array($visitPrices) && empty($visitPrices))) {
            unset($this->VisitPrices);
        } else {
            $this->VisitPrices = $visitPrices;
        }
        return $this;
    }
    /**
     * Get VisitTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitTypeId()
    {
        return isset($this->VisitTypeId) ? $this->VisitTypeId : null;
    }
    /**
     * Set VisitTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitTypeId
     * @return \patest\StructType\BizResource_OrderVisit
     */
    public function setVisitTypeId($visitTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($visitTypeId) && !is_string($visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitTypeId, true), gettype($visitTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitTypeId, true)), __LINE__);
        }
        if (is_null($visitTypeId) || (is_array($visitTypeId) && empty($visitTypeId))) {
            unset($this->VisitTypeId);
        } else {
            $this->VisitTypeId = $visitTypeId;
        }
        return $this;
    }
}
