<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.GuideReservationFilter StructType
 * @subpackage Structs
 */
class BizResource_GuideReservationFilter extends BizResource_ReservationFilter
{
    /**
     * The GuidanceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidanceTypeId;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OrderNumber;
    /**
     * The SourceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceType;
    /**
     * Constructor method for BizResource.GuideReservationFilter
     * @uses BizResource_GuideReservationFilter::setGuidanceTypeId()
     * @uses BizResource_GuideReservationFilter::setOrderNumber()
     * @uses BizResource_GuideReservationFilter::setSourceType()
     * @param string $guidanceTypeId
     * @param int $orderNumber
     * @param string $sourceType
     */
    public function __construct($guidanceTypeId = null, $orderNumber = null, $sourceType = null)
    {
        $this
            ->setGuidanceTypeId($guidanceTypeId)
            ->setOrderNumber($orderNumber)
            ->setSourceType($sourceType);
    }
    /**
     * Get GuidanceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidanceTypeId()
    {
        return isset($this->GuidanceTypeId) ? $this->GuidanceTypeId : null;
    }
    /**
     * Set GuidanceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidanceTypeId
     * @return \patest\StructType\BizResource_GuideReservationFilter
     */
    public function setGuidanceTypeId($guidanceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($guidanceTypeId) && !is_string($guidanceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidanceTypeId, true), gettype($guidanceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidanceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidanceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidanceTypeId, true)), __LINE__);
        }
        if (is_null($guidanceTypeId) || (is_array($guidanceTypeId) && empty($guidanceTypeId))) {
            unset($this->GuidanceTypeId);
        } else {
            $this->GuidanceTypeId = $guidanceTypeId;
        }
        return $this;
    }
    /**
     * Get OrderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderNumber()
    {
        return isset($this->OrderNumber) ? $this->OrderNumber : null;
    }
    /**
     * Set OrderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderNumber
     * @return \patest\StructType\BizResource_GuideReservationFilter
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderNumber) && !(is_int($orderNumber) || ctype_digit($orderNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->OrderNumber);
        } else {
            $this->OrderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Get SourceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceType()
    {
        return isset($this->SourceType) ? $this->SourceType : null;
    }
    /**
     * Set SourceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestSourceType::valueIsValid()
     * @uses \patest\EnumType\RequestSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceType
     * @return \patest\StructType\BizResource_GuideReservationFilter
     */
    public function setSourceType($sourceType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestSourceType::valueIsValid($sourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestSourceType', is_array($sourceType) ? implode(', ', $sourceType) : var_export($sourceType, true), implode(', ', \patest\EnumType\RequestSourceType::getValidValues())), __LINE__);
        }
        if (is_null($sourceType) || (is_array($sourceType) && empty($sourceType))) {
            unset($this->SourceType);
        } else {
            $this->SourceType = $sourceType;
        }
        return $this;
    }
}
