<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.ClassVisitFilter StructType
 * @subpackage Structs
 */
class BizResource_ClassVisitFilter extends FilterEntity
{
    /**
     * The BirthYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BirthYear;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The GradeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeId;
    /**
     * Constructor method for BizResource.ClassVisitFilter
     * @uses BizResource_ClassVisitFilter::setBirthYear()
     * @uses BizResource_ClassVisitFilter::setFromDate()
     * @uses BizResource_ClassVisitFilter::setGradeId()
     * @param int $birthYear
     * @param string $fromDate
     * @param string $gradeId
     */
    public function __construct($birthYear = null, $fromDate = null, $gradeId = null)
    {
        $this
            ->setBirthYear($birthYear)
            ->setFromDate($fromDate)
            ->setGradeId($gradeId);
    }
    /**
     * Get BirthYear value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBirthYear()
    {
        return isset($this->BirthYear) ? $this->BirthYear : null;
    }
    /**
     * Set BirthYear value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $birthYear
     * @return \patest\StructType\BizResource_ClassVisitFilter
     */
    public function setBirthYear($birthYear = null)
    {
        // validation for constraint: int
        if (!is_null($birthYear) && !(is_int($birthYear) || ctype_digit($birthYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($birthYear, true), gettype($birthYear)), __LINE__);
        }
        if (is_null($birthYear) || (is_array($birthYear) && empty($birthYear))) {
            unset($this->BirthYear);
        } else {
            $this->BirthYear = $birthYear;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizResource_ClassVisitFilter
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get GradeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGradeId()
    {
        return isset($this->GradeId) ? $this->GradeId : null;
    }
    /**
     * Set GradeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gradeId
     * @return \patest\StructType\BizResource_ClassVisitFilter
     */
    public function setGradeId($gradeId = null)
    {
        // validation for constraint: string
        if (!is_null($gradeId) && !is_string($gradeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gradeId, true), gettype($gradeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($gradeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($gradeId, true)), __LINE__);
        }
        if (is_null($gradeId) || (is_array($gradeId) && empty($gradeId))) {
            unset($this->GradeId);
        } else {
            $this->GradeId = $gradeId;
        }
        return $this;
    }
}
