<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.BizResourceRequest StructType
 * @subpackage Structs
 */
class BizResource_BizResourceRequest extends BizResource_PersistableEntityBase
{
    /**
     * The BizResourceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BizResourceTypeId;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The MinutesFromStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinutesFromStart;
    /**
     * The ReservationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReservationId;
    /**
     * The SourceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourceId;
    /**
     * The SourceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceType;
    /**
     * The StartAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartAt;
    /**
     * The UntilDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilDate;
    /**
     * Constructor method for BizResource.BizResourceRequest
     * @uses BizResource_BizResourceRequest::setBizResourceTypeId()
     * @uses BizResource_BizResourceRequest::setDuration()
     * @uses BizResource_BizResourceRequest::setFromDate()
     * @uses BizResource_BizResourceRequest::setMinutesFromStart()
     * @uses BizResource_BizResourceRequest::setReservationId()
     * @uses BizResource_BizResourceRequest::setSourceId()
     * @uses BizResource_BizResourceRequest::setSourceType()
     * @uses BizResource_BizResourceRequest::setStartAt()
     * @uses BizResource_BizResourceRequest::setUntilDate()
     * @param string $bizResourceTypeId
     * @param int $duration
     * @param string $fromDate
     * @param int $minutesFromStart
     * @param string $reservationId
     * @param string $sourceId
     * @param string $sourceType
     * @param string $startAt
     * @param string $untilDate
     */
    public function __construct($bizResourceTypeId = null, $duration = null, $fromDate = null, $minutesFromStart = null, $reservationId = null, $sourceId = null, $sourceType = null, $startAt = null, $untilDate = null)
    {
        $this
            ->setBizResourceTypeId($bizResourceTypeId)
            ->setDuration($duration)
            ->setFromDate($fromDate)
            ->setMinutesFromStart($minutesFromStart)
            ->setReservationId($reservationId)
            ->setSourceId($sourceId)
            ->setSourceType($sourceType)
            ->setStartAt($startAt)
            ->setUntilDate($untilDate);
    }
    /**
     * Get BizResourceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBizResourceTypeId()
    {
        return isset($this->BizResourceTypeId) ? $this->BizResourceTypeId : null;
    }
    /**
     * Set BizResourceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bizResourceTypeId
     * @return \patest\StructType\BizResource_BizResourceRequest
     */
    public function setBizResourceTypeId($bizResourceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($bizResourceTypeId) && !is_string($bizResourceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bizResourceTypeId, true), gettype($bizResourceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bizResourceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bizResourceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bizResourceTypeId, true)), __LINE__);
        }
        if (is_null($bizResourceTypeId) || (is_array($bizResourceTypeId) && empty($bizResourceTypeId))) {
            unset($this->BizResourceTypeId);
        } else {
            $this->BizResourceTypeId = $bizResourceTypeId;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duration
     * @return \patest\StructType\BizResource_BizResourceRequest
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizResource_BizResourceRequest
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get MinutesFromStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinutesFromStart()
    {
        return isset($this->MinutesFromStart) ? $this->MinutesFromStart : null;
    }
    /**
     * Set MinutesFromStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minutesFromStart
     * @return \patest\StructType\BizResource_BizResourceRequest
     */
    public function setMinutesFromStart($minutesFromStart = null)
    {
        // validation for constraint: int
        if (!is_null($minutesFromStart) && !(is_int($minutesFromStart) || ctype_digit($minutesFromStart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minutesFromStart, true), gettype($minutesFromStart)), __LINE__);
        }
        if (is_null($minutesFromStart) || (is_array($minutesFromStart) && empty($minutesFromStart))) {
            unset($this->MinutesFromStart);
        } else {
            $this->MinutesFromStart = $minutesFromStart;
        }
        return $this;
    }
    /**
     * Get ReservationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationId()
    {
        return isset($this->ReservationId) ? $this->ReservationId : null;
    }
    /**
     * Set ReservationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationId
     * @return \patest\StructType\BizResource_BizResourceRequest
     */
    public function setReservationId($reservationId = null)
    {
        // validation for constraint: string
        if (!is_null($reservationId) && !is_string($reservationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationId, true), gettype($reservationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reservationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reservationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reservationId, true)), __LINE__);
        }
        if (is_null($reservationId) || (is_array($reservationId) && empty($reservationId))) {
            unset($this->ReservationId);
        } else {
            $this->ReservationId = $reservationId;
        }
        return $this;
    }
    /**
     * Get SourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceId()
    {
        return isset($this->SourceId) ? $this->SourceId : null;
    }
    /**
     * Set SourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceId
     * @return \patest\StructType\BizResource_BizResourceRequest
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourceId, true)), __LINE__);
        }
        if (is_null($sourceId) || (is_array($sourceId) && empty($sourceId))) {
            unset($this->SourceId);
        } else {
            $this->SourceId = $sourceId;
        }
        return $this;
    }
    /**
     * Get SourceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceType()
    {
        return isset($this->SourceType) ? $this->SourceType : null;
    }
    /**
     * Set SourceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestSourceType::valueIsValid()
     * @uses \patest\EnumType\RequestSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceType
     * @return \patest\StructType\BizResource_BizResourceRequest
     */
    public function setSourceType($sourceType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestSourceType::valueIsValid($sourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestSourceType', is_array($sourceType) ? implode(', ', $sourceType) : var_export($sourceType, true), implode(', ', \patest\EnumType\RequestSourceType::getValidValues())), __LINE__);
        }
        if (is_null($sourceType) || (is_array($sourceType) && empty($sourceType))) {
            unset($this->SourceType);
        } else {
            $this->SourceType = $sourceType;
        }
        return $this;
    }
    /**
     * Get StartAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartAt()
    {
        return isset($this->StartAt) ? $this->StartAt : null;
    }
    /**
     * Set StartAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestStartType::valueIsValid()
     * @uses \patest\EnumType\RequestStartType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startAt
     * @return \patest\StructType\BizResource_BizResourceRequest
     */
    public function setStartAt($startAt = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestStartType::valueIsValid($startAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestStartType', is_array($startAt) ? implode(', ', $startAt) : var_export($startAt, true), implode(', ', \patest\EnumType\RequestStartType::getValidValues())), __LINE__);
        }
        if (is_null($startAt) || (is_array($startAt) && empty($startAt))) {
            unset($this->StartAt);
        } else {
            $this->StartAt = $startAt;
        }
        return $this;
    }
    /**
     * Get UntilDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilDate()
    {
        return isset($this->UntilDate) ? $this->UntilDate : null;
    }
    /**
     * Set UntilDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilDate
     * @return \patest\StructType\BizResource_BizResourceRequest
     */
    public function setUntilDate($untilDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilDate) && !is_string($untilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDate, true), gettype($untilDate)), __LINE__);
        }
        if (is_null($untilDate) || (is_array($untilDate) && empty($untilDate))) {
            unset($this->UntilDate);
        } else {
            $this->UntilDate = $untilDate;
        }
        return $this;
    }
}
