<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.BizResource StructType
 * @subpackage Structs
 */
class BizResource_BizResource extends BizResource_PersistableEntityBase
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CategoryIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CategoryIds
     */
    public $CategoryIds;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The DisplayStyleValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayStyleValue;
    /**
     * The EffectiveName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EffectiveName;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsExternal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExternal;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The ManagedBy
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ManagedBy;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The SkillIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SkillIds
     */
    public $SkillIds;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for BizResource.BizResource
     * @uses BizResource_BizResource::setAclSchemeId()
     * @uses BizResource_BizResource::setCategoryId()
     * @uses BizResource_BizResource::setCategoryIds()
     * @uses BizResource_BizResource::setDescription()
     * @uses BizResource_BizResource::setDisplayStyleValue()
     * @uses BizResource_BizResource::setEffectiveName()
     * @uses BizResource_BizResource::setIsActive()
     * @uses BizResource_BizResource::setIsExternal()
     * @uses BizResource_BizResource::setLedgerId()
     * @uses BizResource_BizResource::setManagedBy()
     * @uses BizResource_BizResource::setOrganizationUnitId()
     * @uses BizResource_BizResource::setProjectIdentifierId()
     * @uses BizResource_BizResource::setQuantity()
     * @uses BizResource_BizResource::setSkillIds()
     * @uses BizResource_BizResource::setTypeId()
     * @uses BizResource_BizResource::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param string $categoryId
     * @param \patest\StructType\CategoryIds $categoryIds
     * @param \patest\StructType\GlobalString $description
     * @param string $displayStyleValue
     * @param \patest\StructType\GlobalString $effectiveName
     * @param bool $isActive
     * @param bool $isExternal
     * @param string $ledgerId
     * @param string $managedBy
     * @param string $organizationUnitId
     * @param string $projectIdentifierId
     * @param int $quantity
     * @param \patest\StructType\SkillIds $skillIds
     * @param string $typeId
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $categoryId = null, \patest\StructType\CategoryIds $categoryIds = null, \patest\StructType\GlobalString $description = null, $displayStyleValue = null, \patest\StructType\GlobalString $effectiveName = null, $isActive = null, $isExternal = null, $ledgerId = null, $managedBy = null, $organizationUnitId = null, $projectIdentifierId = null, $quantity = null, \patest\StructType\SkillIds $skillIds = null, $typeId = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setCategoryId($categoryId)
            ->setCategoryIds($categoryIds)
            ->setDescription($description)
            ->setDisplayStyleValue($displayStyleValue)
            ->setEffectiveName($effectiveName)
            ->setIsActive($isActive)
            ->setIsExternal($isExternal)
            ->setLedgerId($ledgerId)
            ->setManagedBy($managedBy)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setQuantity($quantity)
            ->setSkillIds($skillIds)
            ->setTypeId($typeId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CategoryIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CategoryIds|null
     */
    public function getCategoryIds()
    {
        return isset($this->CategoryIds) ? $this->CategoryIds : null;
    }
    /**
     * Set CategoryIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CategoryIds $categoryIds
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setCategoryIds(\patest\StructType\CategoryIds $categoryIds = null)
    {
        if (is_null($categoryIds) || (is_array($categoryIds) && empty($categoryIds))) {
            unset($this->CategoryIds);
        } else {
            $this->CategoryIds = $categoryIds;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DisplayStyleValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayStyleValue()
    {
        return isset($this->DisplayStyleValue) ? $this->DisplayStyleValue : null;
    }
    /**
     * Set DisplayStyleValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayStyleValue
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setDisplayStyleValue($displayStyleValue = null)
    {
        // validation for constraint: string
        if (!is_null($displayStyleValue) && !is_string($displayStyleValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayStyleValue, true), gettype($displayStyleValue)), __LINE__);
        }
        if (is_null($displayStyleValue) || (is_array($displayStyleValue) && empty($displayStyleValue))) {
            unset($this->DisplayStyleValue);
        } else {
            $this->DisplayStyleValue = $displayStyleValue;
        }
        return $this;
    }
    /**
     * Get EffectiveName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEffectiveName()
    {
        return isset($this->EffectiveName) ? $this->EffectiveName : null;
    }
    /**
     * Set EffectiveName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $effectiveName
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setEffectiveName(\patest\StructType\GlobalString $effectiveName = null)
    {
        if (is_null($effectiveName) || (is_array($effectiveName) && empty($effectiveName))) {
            unset($this->EffectiveName);
        } else {
            $this->EffectiveName = $effectiveName;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsExternal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExternal()
    {
        return isset($this->IsExternal) ? $this->IsExternal : null;
    }
    /**
     * Set IsExternal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExternal
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setIsExternal($isExternal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExternal) && !is_bool($isExternal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExternal, true), gettype($isExternal)), __LINE__);
        }
        if (is_null($isExternal) || (is_array($isExternal) && empty($isExternal))) {
            unset($this->IsExternal);
        } else {
            $this->IsExternal = $isExternal;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get ManagedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getManagedBy()
    {
        return isset($this->ManagedBy) ? $this->ManagedBy : null;
    }
    /**
     * Set ManagedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BizResourceManagedBy::valueIsValid()
     * @uses \patest\EnumType\BizResourceManagedBy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $managedBy
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setManagedBy($managedBy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BizResourceManagedBy::valueIsValid($managedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BizResourceManagedBy', is_array($managedBy) ? implode(', ', $managedBy) : var_export($managedBy, true), implode(', ', \patest\EnumType\BizResourceManagedBy::getValidValues())), __LINE__);
        }
        if (is_null($managedBy) || (is_array($managedBy) && empty($managedBy))) {
            unset($this->ManagedBy);
        } else {
            $this->ManagedBy = $managedBy;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get SkillIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SkillIds|null
     */
    public function getSkillIds()
    {
        return isset($this->SkillIds) ? $this->SkillIds : null;
    }
    /**
     * Set SkillIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SkillIds $skillIds
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setSkillIds(\patest\StructType\SkillIds $skillIds = null)
    {
        if (is_null($skillIds) || (is_array($skillIds) && empty($skillIds))) {
            unset($this->SkillIds);
        } else {
            $this->SkillIds = $skillIds;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\BizResource_BizResource
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
