<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.AddGuidanceToBasketRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BizResource.AddGuidanceToBasketRequest
 * @subpackage Structs
 */
class BizResource_AddGuidanceToBasketRequest extends AnyEntity
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The FixedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FixedPrice;
    /**
     * The GuidanceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidanceTypeId;
    /**
     * The GuideId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuideId;
    /**
     * The GuideRequestData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BizResource_GuideRequestData
     */
    public $GuideRequestData;
    /**
     * The GuideRequestId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuideRequestId;
    /**
     * The IsFixedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFixedPrice;
    /**
     * The OrderIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_ItemOrder
     */
    public $OrderIdentity;
    /**
     * The SourceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceType;
    /**
     * Constructor method for BizResource.AddGuidanceToBasketRequest
     * @uses BizResource_AddGuidanceToBasketRequest::setEventId()
     * @uses BizResource_AddGuidanceToBasketRequest::setFixedPrice()
     * @uses BizResource_AddGuidanceToBasketRequest::setGuidanceTypeId()
     * @uses BizResource_AddGuidanceToBasketRequest::setGuideId()
     * @uses BizResource_AddGuidanceToBasketRequest::setGuideRequestData()
     * @uses BizResource_AddGuidanceToBasketRequest::setGuideRequestId()
     * @uses BizResource_AddGuidanceToBasketRequest::setIsFixedPrice()
     * @uses BizResource_AddGuidanceToBasketRequest::setOrderIdentity()
     * @uses BizResource_AddGuidanceToBasketRequest::setSourceType()
     * @param string $eventId
     * @param float $fixedPrice
     * @param string $guidanceTypeId
     * @param string $guideId
     * @param \patest\StructType\BizResource_GuideRequestData $guideRequestData
     * @param string $guideRequestId
     * @param bool $isFixedPrice
     * @param \patest\StructType\Sales_ItemOrder $orderIdentity
     * @param string $sourceType
     */
    public function __construct($eventId = null, $fixedPrice = null, $guidanceTypeId = null, $guideId = null, \patest\StructType\BizResource_GuideRequestData $guideRequestData = null, $guideRequestId = null, $isFixedPrice = null, \patest\StructType\Sales_ItemOrder $orderIdentity = null, $sourceType = null)
    {
        $this
            ->setEventId($eventId)
            ->setFixedPrice($fixedPrice)
            ->setGuidanceTypeId($guidanceTypeId)
            ->setGuideId($guideId)
            ->setGuideRequestData($guideRequestData)
            ->setGuideRequestId($guideRequestId)
            ->setIsFixedPrice($isFixedPrice)
            ->setOrderIdentity($orderIdentity)
            ->setSourceType($sourceType);
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizResource_AddGuidanceToBasketRequest
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get FixedPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFixedPrice()
    {
        return isset($this->FixedPrice) ? $this->FixedPrice : null;
    }
    /**
     * Set FixedPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fixedPrice
     * @return \patest\StructType\BizResource_AddGuidanceToBasketRequest
     */
    public function setFixedPrice($fixedPrice = null)
    {
        // validation for constraint: float
        if (!is_null($fixedPrice) && !(is_float($fixedPrice) || is_numeric($fixedPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedPrice, true), gettype($fixedPrice)), __LINE__);
        }
        if (is_null($fixedPrice) || (is_array($fixedPrice) && empty($fixedPrice))) {
            unset($this->FixedPrice);
        } else {
            $this->FixedPrice = $fixedPrice;
        }
        return $this;
    }
    /**
     * Get GuidanceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidanceTypeId()
    {
        return isset($this->GuidanceTypeId) ? $this->GuidanceTypeId : null;
    }
    /**
     * Set GuidanceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidanceTypeId
     * @return \patest\StructType\BizResource_AddGuidanceToBasketRequest
     */
    public function setGuidanceTypeId($guidanceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($guidanceTypeId) && !is_string($guidanceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidanceTypeId, true), gettype($guidanceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidanceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidanceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidanceTypeId, true)), __LINE__);
        }
        if (is_null($guidanceTypeId) || (is_array($guidanceTypeId) && empty($guidanceTypeId))) {
            unset($this->GuidanceTypeId);
        } else {
            $this->GuidanceTypeId = $guidanceTypeId;
        }
        return $this;
    }
    /**
     * Get GuideId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuideId()
    {
        return isset($this->GuideId) ? $this->GuideId : null;
    }
    /**
     * Set GuideId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guideId
     * @return \patest\StructType\BizResource_AddGuidanceToBasketRequest
     */
    public function setGuideId($guideId = null)
    {
        // validation for constraint: string
        if (!is_null($guideId) && !is_string($guideId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guideId, true), gettype($guideId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guideId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guideId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guideId, true)), __LINE__);
        }
        if (is_null($guideId) || (is_array($guideId) && empty($guideId))) {
            unset($this->GuideId);
        } else {
            $this->GuideId = $guideId;
        }
        return $this;
    }
    /**
     * Get GuideRequestData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BizResource_GuideRequestData|null
     */
    public function getGuideRequestData()
    {
        return isset($this->GuideRequestData) ? $this->GuideRequestData : null;
    }
    /**
     * Set GuideRequestData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BizResource_GuideRequestData $guideRequestData
     * @return \patest\StructType\BizResource_AddGuidanceToBasketRequest
     */
    public function setGuideRequestData(\patest\StructType\BizResource_GuideRequestData $guideRequestData = null)
    {
        if (is_null($guideRequestData) || (is_array($guideRequestData) && empty($guideRequestData))) {
            unset($this->GuideRequestData);
        } else {
            $this->GuideRequestData = $guideRequestData;
        }
        return $this;
    }
    /**
     * Get GuideRequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuideRequestId()
    {
        return isset($this->GuideRequestId) ? $this->GuideRequestId : null;
    }
    /**
     * Set GuideRequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guideRequestId
     * @return \patest\StructType\BizResource_AddGuidanceToBasketRequest
     */
    public function setGuideRequestId($guideRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($guideRequestId) && !is_string($guideRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guideRequestId, true), gettype($guideRequestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guideRequestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guideRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guideRequestId, true)), __LINE__);
        }
        if (is_null($guideRequestId) || (is_array($guideRequestId) && empty($guideRequestId))) {
            unset($this->GuideRequestId);
        } else {
            $this->GuideRequestId = $guideRequestId;
        }
        return $this;
    }
    /**
     * Get IsFixedPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFixedPrice()
    {
        return isset($this->IsFixedPrice) ? $this->IsFixedPrice : null;
    }
    /**
     * Set IsFixedPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFixedPrice
     * @return \patest\StructType\BizResource_AddGuidanceToBasketRequest
     */
    public function setIsFixedPrice($isFixedPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFixedPrice) && !is_bool($isFixedPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFixedPrice, true), gettype($isFixedPrice)), __LINE__);
        }
        if (is_null($isFixedPrice) || (is_array($isFixedPrice) && empty($isFixedPrice))) {
            unset($this->IsFixedPrice);
        } else {
            $this->IsFixedPrice = $isFixedPrice;
        }
        return $this;
    }
    /**
     * Get OrderIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_ItemOrder|null
     */
    public function getOrderIdentity()
    {
        return isset($this->OrderIdentity) ? $this->OrderIdentity : null;
    }
    /**
     * Set OrderIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_ItemOrder $orderIdentity
     * @return \patest\StructType\BizResource_AddGuidanceToBasketRequest
     */
    public function setOrderIdentity(\patest\StructType\Sales_ItemOrder $orderIdentity = null)
    {
        if (is_null($orderIdentity) || (is_array($orderIdentity) && empty($orderIdentity))) {
            unset($this->OrderIdentity);
        } else {
            $this->OrderIdentity = $orderIdentity;
        }
        return $this;
    }
    /**
     * Get SourceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceType()
    {
        return isset($this->SourceType) ? $this->SourceType : null;
    }
    /**
     * Set SourceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestSourceType::valueIsValid()
     * @uses \patest\EnumType\RequestSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceType
     * @return \patest\StructType\BizResource_AddGuidanceToBasketRequest
     */
    public function setSourceType($sourceType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestSourceType::valueIsValid($sourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestSourceType', is_array($sourceType) ? implode(', ', $sourceType) : var_export($sourceType, true), implode(', ', \patest\EnumType\RequestSourceType::getValidValues())), __LINE__);
        }
        if (is_null($sourceType) || (is_array($sourceType) && empty($sourceType))) {
            unset($this->SourceType);
        } else {
            $this->SourceType = $sourceType;
        }
        return $this;
    }
}
