<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.Activity StructType
 * @subpackage Structs
 */
class BizResource_Activity extends BizResource_PersistableEntityBase
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The CreatedMissingEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CreatedMissingEvent;
    /**
     * The DocumentIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DocumentIds
     */
    public $DocumentIds;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The IsFullCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFullCapacity;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OtherCategories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_ActivityCategory
     */
    public $OtherCategories;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The RoomCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoomCategoryId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The VisitPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitPlanId;
    /**
     * Constructor method for BizResource.Activity
     * @uses BizResource_Activity::setAclSchemeId()
     * @uses BizResource_Activity::setCreatedMissingEvent()
     * @uses BizResource_Activity::setDocumentIds()
     * @uses BizResource_Activity::setDuration()
     * @uses BizResource_Activity::setIsFullCapacity()
     * @uses BizResource_Activity::setName()
     * @uses BizResource_Activity::setOrganizationUnitId()
     * @uses BizResource_Activity::setOtherCategories()
     * @uses BizResource_Activity::setPriority()
     * @uses BizResource_Activity::setRoomCategoryId()
     * @uses BizResource_Activity::setShowId()
     * @uses BizResource_Activity::setVisitPlanId()
     * @param int $aclSchemeId
     * @param bool $createdMissingEvent
     * @param \patest\StructType\DocumentIds $documentIds
     * @param int $duration
     * @param bool $isFullCapacity
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param \patest\StructType\RecordSetOfBizResource_ActivityCategory $otherCategories
     * @param int $priority
     * @param string $roomCategoryId
     * @param string $showId
     * @param string $visitPlanId
     */
    public function __construct($aclSchemeId = null, $createdMissingEvent = null, \patest\StructType\DocumentIds $documentIds = null, $duration = null, $isFullCapacity = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, \patest\StructType\RecordSetOfBizResource_ActivityCategory $otherCategories = null, $priority = null, $roomCategoryId = null, $showId = null, $visitPlanId = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setCreatedMissingEvent($createdMissingEvent)
            ->setDocumentIds($documentIds)
            ->setDuration($duration)
            ->setIsFullCapacity($isFullCapacity)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOtherCategories($otherCategories)
            ->setPriority($priority)
            ->setRoomCategoryId($roomCategoryId)
            ->setShowId($showId)
            ->setVisitPlanId($visitPlanId);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\BizResource_Activity
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get CreatedMissingEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCreatedMissingEvent()
    {
        return isset($this->CreatedMissingEvent) ? $this->CreatedMissingEvent : null;
    }
    /**
     * Set CreatedMissingEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $createdMissingEvent
     * @return \patest\StructType\BizResource_Activity
     */
    public function setCreatedMissingEvent($createdMissingEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($createdMissingEvent) && !is_bool($createdMissingEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createdMissingEvent, true), gettype($createdMissingEvent)), __LINE__);
        }
        if (is_null($createdMissingEvent) || (is_array($createdMissingEvent) && empty($createdMissingEvent))) {
            unset($this->CreatedMissingEvent);
        } else {
            $this->CreatedMissingEvent = $createdMissingEvent;
        }
        return $this;
    }
    /**
     * Get DocumentIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DocumentIds|null
     */
    public function getDocumentIds()
    {
        return isset($this->DocumentIds) ? $this->DocumentIds : null;
    }
    /**
     * Set DocumentIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DocumentIds $documentIds
     * @return \patest\StructType\BizResource_Activity
     */
    public function setDocumentIds(\patest\StructType\DocumentIds $documentIds = null)
    {
        if (is_null($documentIds) || (is_array($documentIds) && empty($documentIds))) {
            unset($this->DocumentIds);
        } else {
            $this->DocumentIds = $documentIds;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duration
     * @return \patest\StructType\BizResource_Activity
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get IsFullCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFullCapacity()
    {
        return isset($this->IsFullCapacity) ? $this->IsFullCapacity : null;
    }
    /**
     * Set IsFullCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFullCapacity
     * @return \patest\StructType\BizResource_Activity
     */
    public function setIsFullCapacity($isFullCapacity = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFullCapacity) && !is_bool($isFullCapacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFullCapacity, true), gettype($isFullCapacity)), __LINE__);
        }
        if (is_null($isFullCapacity) || (is_array($isFullCapacity) && empty($isFullCapacity))) {
            unset($this->IsFullCapacity);
        } else {
            $this->IsFullCapacity = $isFullCapacity;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\BizResource_Activity
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\BizResource_Activity
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OtherCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_ActivityCategory|null
     */
    public function getOtherCategories()
    {
        return isset($this->OtherCategories) ? $this->OtherCategories : null;
    }
    /**
     * Set OtherCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_ActivityCategory $otherCategories
     * @return \patest\StructType\BizResource_Activity
     */
    public function setOtherCategories(\patest\StructType\RecordSetOfBizResource_ActivityCategory $otherCategories = null)
    {
        if (is_null($otherCategories) || (is_array($otherCategories) && empty($otherCategories))) {
            unset($this->OtherCategories);
        } else {
            $this->OtherCategories = $otherCategories;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\BizResource_Activity
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get RoomCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoomCategoryId()
    {
        return isset($this->RoomCategoryId) ? $this->RoomCategoryId : null;
    }
    /**
     * Set RoomCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roomCategoryId
     * @return \patest\StructType\BizResource_Activity
     */
    public function setRoomCategoryId($roomCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($roomCategoryId) && !is_string($roomCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomCategoryId, true), gettype($roomCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roomCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roomCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roomCategoryId, true)), __LINE__);
        }
        if (is_null($roomCategoryId) || (is_array($roomCategoryId) && empty($roomCategoryId))) {
            unset($this->RoomCategoryId);
        } else {
            $this->RoomCategoryId = $roomCategoryId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\BizResource_Activity
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get VisitPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitPlanId()
    {
        return isset($this->VisitPlanId) ? $this->VisitPlanId : null;
    }
    /**
     * Set VisitPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitPlanId
     * @return \patest\StructType\BizResource_Activity
     */
    public function setVisitPlanId($visitPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($visitPlanId) && !is_string($visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitPlanId, true), gettype($visitPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitPlanId, true)), __LINE__);
        }
        if (is_null($visitPlanId) || (is_array($visitPlanId) && empty($visitPlanId))) {
            unset($this->VisitPlanId);
        } else {
            $this->VisitPlanId = $visitPlanId;
        }
        return $this;
    }
}
