<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.eSRO.DataProtectionAnswer StructType
 * @subpackage Structs
 */
class BizAction_eSRO_DataProtectionAnswer extends AnyEntity
{
    /**
     * The Answer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Answer;
    /**
     * The DataProtectionQuestionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DataProtectionQuestionId;
    /**
     * Constructor method for BizAction.eSRO.DataProtectionAnswer
     * @uses BizAction_eSRO_DataProtectionAnswer::setAnswer()
     * @uses BizAction_eSRO_DataProtectionAnswer::setDataProtectionQuestionId()
     * @param bool $answer
     * @param string $dataProtectionQuestionId
     */
    public function __construct($answer = null, $dataProtectionQuestionId = null)
    {
        $this
            ->setAnswer($answer)
            ->setDataProtectionQuestionId($dataProtectionQuestionId);
    }
    /**
     * Get Answer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAnswer()
    {
        return isset($this->Answer) ? $this->Answer : null;
    }
    /**
     * Set Answer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $answer
     * @return \patest\StructType\BizAction_eSRO_DataProtectionAnswer
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: boolean
        if (!is_null($answer) && !is_bool($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($answer, true), gettype($answer)), __LINE__);
        }
        if (is_null($answer) || (is_array($answer) && empty($answer))) {
            unset($this->Answer);
        } else {
            $this->Answer = $answer;
        }
        return $this;
    }
    /**
     * Get DataProtectionQuestionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataProtectionQuestionId()
    {
        return isset($this->DataProtectionQuestionId) ? $this->DataProtectionQuestionId : null;
    }
    /**
     * Set DataProtectionQuestionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataProtectionQuestionId
     * @return \patest\StructType\BizAction_eSRO_DataProtectionAnswer
     */
    public function setDataProtectionQuestionId($dataProtectionQuestionId = null)
    {
        // validation for constraint: string
        if (!is_null($dataProtectionQuestionId) && !is_string($dataProtectionQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataProtectionQuestionId, true), gettype($dataProtectionQuestionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dataProtectionQuestionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dataProtectionQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dataProtectionQuestionId, true)), __LINE__);
        }
        if (is_null($dataProtectionQuestionId) || (is_array($dataProtectionQuestionId) && empty($dataProtectionQuestionId))) {
            unset($this->DataProtectionQuestionId);
        } else {
            $this->DataProtectionQuestionId = $dataProtectionQuestionId;
        }
        return $this;
    }
}
