<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.UI.SetPriorities.Request StructType
 * @subpackage Structs
 */
class BizAction_UI_SetPriorities_Request extends AnyEntity
{
    /**
     * The Entities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_UI_SetPrioritiesEntity
     */
    public $Entities;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The IncludePhrase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludePhrase;
    /**
     * The InfoLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InfoLine;
    /**
     * The ViewName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ViewName;
    /**
     * The ViewParameter1Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ViewParameter1Name;
    /**
     * The ViewParameter1Value
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ViewParameter1Value;
    /**
     * Constructor method for BizAction.UI.SetPriorities.Request
     * @uses BizAction_UI_SetPriorities_Request::setEntities()
     * @uses BizAction_UI_SetPriorities_Request::setEntityName()
     * @uses BizAction_UI_SetPriorities_Request::setIncludePhrase()
     * @uses BizAction_UI_SetPriorities_Request::setInfoLine()
     * @uses BizAction_UI_SetPriorities_Request::setViewName()
     * @uses BizAction_UI_SetPriorities_Request::setViewParameter1Name()
     * @uses BizAction_UI_SetPriorities_Request::setViewParameter1Value()
     * @param \patest\StructType\RecordSetOfBizAction_UI_SetPrioritiesEntity $entities
     * @param string $entityName
     * @param string $includePhrase
     * @param string $infoLine
     * @param string $viewName
     * @param string $viewParameter1Name
     * @param string $viewParameter1Value
     */
    public function __construct(\patest\StructType\RecordSetOfBizAction_UI_SetPrioritiesEntity $entities = null, $entityName = null, $includePhrase = null, $infoLine = null, $viewName = null, $viewParameter1Name = null, $viewParameter1Value = null)
    {
        $this
            ->setEntities($entities)
            ->setEntityName($entityName)
            ->setIncludePhrase($includePhrase)
            ->setInfoLine($infoLine)
            ->setViewName($viewName)
            ->setViewParameter1Name($viewParameter1Name)
            ->setViewParameter1Value($viewParameter1Value);
    }
    /**
     * Get Entities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_UI_SetPrioritiesEntity|null
     */
    public function getEntities()
    {
        return isset($this->Entities) ? $this->Entities : null;
    }
    /**
     * Set Entities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_UI_SetPrioritiesEntity $entities
     * @return \patest\StructType\BizAction_UI_SetPriorities_Request
     */
    public function setEntities(\patest\StructType\RecordSetOfBizAction_UI_SetPrioritiesEntity $entities = null)
    {
        if (is_null($entities) || (is_array($entities) && empty($entities))) {
            unset($this->Entities);
        } else {
            $this->Entities = $entities;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\BizAction_UI_SetPriorities_Request
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get IncludePhrase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludePhrase()
    {
        return isset($this->IncludePhrase) ? $this->IncludePhrase : null;
    }
    /**
     * Set IncludePhrase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $includePhrase
     * @return \patest\StructType\BizAction_UI_SetPriorities_Request
     */
    public function setIncludePhrase($includePhrase = null)
    {
        // validation for constraint: string
        if (!is_null($includePhrase) && !is_string($includePhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includePhrase, true), gettype($includePhrase)), __LINE__);
        }
        if (is_null($includePhrase) || (is_array($includePhrase) && empty($includePhrase))) {
            unset($this->IncludePhrase);
        } else {
            $this->IncludePhrase = $includePhrase;
        }
        return $this;
    }
    /**
     * Get InfoLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfoLine()
    {
        return isset($this->InfoLine) ? $this->InfoLine : null;
    }
    /**
     * Set InfoLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $infoLine
     * @return \patest\StructType\BizAction_UI_SetPriorities_Request
     */
    public function setInfoLine($infoLine = null)
    {
        // validation for constraint: string
        if (!is_null($infoLine) && !is_string($infoLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoLine, true), gettype($infoLine)), __LINE__);
        }
        if (is_null($infoLine) || (is_array($infoLine) && empty($infoLine))) {
            unset($this->InfoLine);
        } else {
            $this->InfoLine = $infoLine;
        }
        return $this;
    }
    /**
     * Get ViewName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getViewName()
    {
        return isset($this->ViewName) ? $this->ViewName : null;
    }
    /**
     * Set ViewName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $viewName
     * @return \patest\StructType\BizAction_UI_SetPriorities_Request
     */
    public function setViewName($viewName = null)
    {
        // validation for constraint: string
        if (!is_null($viewName) && !is_string($viewName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewName, true), gettype($viewName)), __LINE__);
        }
        if (is_null($viewName) || (is_array($viewName) && empty($viewName))) {
            unset($this->ViewName);
        } else {
            $this->ViewName = $viewName;
        }
        return $this;
    }
    /**
     * Get ViewParameter1Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getViewParameter1Name()
    {
        return isset($this->ViewParameter1Name) ? $this->ViewParameter1Name : null;
    }
    /**
     * Set ViewParameter1Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $viewParameter1Name
     * @return \patest\StructType\BizAction_UI_SetPriorities_Request
     */
    public function setViewParameter1Name($viewParameter1Name = null)
    {
        // validation for constraint: string
        if (!is_null($viewParameter1Name) && !is_string($viewParameter1Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewParameter1Name, true), gettype($viewParameter1Name)), __LINE__);
        }
        if (is_null($viewParameter1Name) || (is_array($viewParameter1Name) && empty($viewParameter1Name))) {
            unset($this->ViewParameter1Name);
        } else {
            $this->ViewParameter1Name = $viewParameter1Name;
        }
        return $this;
    }
    /**
     * Get ViewParameter1Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getViewParameter1Value()
    {
        return isset($this->ViewParameter1Value) ? $this->ViewParameter1Value : null;
    }
    /**
     * Set ViewParameter1Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $viewParameter1Value
     * @return \patest\StructType\BizAction_UI_SetPriorities_Request
     */
    public function setViewParameter1Value($viewParameter1Value = null)
    {
        // validation for constraint: string
        if (!is_null($viewParameter1Value) && !is_string($viewParameter1Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewParameter1Value, true), gettype($viewParameter1Value)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($viewParameter1Value) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $viewParameter1Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($viewParameter1Value, true)), __LINE__);
        }
        if (is_null($viewParameter1Value) || (is_array($viewParameter1Value) && empty($viewParameter1Value))) {
            unset($this->ViewParameter1Value);
        } else {
            $this->ViewParameter1Value = $viewParameter1Value;
        }
        return $this;
    }
}
