<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.UpdateSeatAttributes.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_UpdateSeatAttributes_Request extends AnyEntity
{
    /**
     * The AllocationTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AllocationTypeId;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The DatesToExclude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_DatesToExclude
     */
    public $DatesToExclude;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The EventsCriteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public $EventsCriteria;
    /**
     * The ExceptAllocatedSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExceptAllocatedSeat;
    /**
     * The ExceptLockedSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExceptLockedSeat;
    /**
     * The ExceptReservedSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExceptReservedSeat;
    /**
     * The ExceptSoldSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExceptSoldSeat;
    /**
     * The ExceptTemporaryHeldSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExceptTemporaryHeldSeat;
    /**
     * The IsAllocate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAllocate;
    /**
     * The IsChangeLock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsChangeLock;
    /**
     * The IsChangePriceLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsChangePriceLevel;
    /**
     * The IsChangePrivateProperty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsChangePrivateProperty;
    /**
     * The IsChangeSeatType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsChangeSeatType;
    /**
     * The IsEntireArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEntireArea;
    /**
     * The IsUnallocate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUnallocate;
    /**
     * The LockTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockTypeId;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PrivateProperty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrivateProperty;
    /**
     * The SeatIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatIds;
    /**
     * The SeatTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatTypeId;
    /**
     * The UnallocationTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UnallocationTypeId;
    /**
     * Constructor method for BizAction.Ticketing.UpdateSeatAttributes.Request
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setAllocationTypeId()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setAreaId()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setDatesToExclude()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setEventIds()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setEventsCriteria()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setExceptAllocatedSeat()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setExceptLockedSeat()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setExceptReservedSeat()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setExceptSoldSeat()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setExceptTemporaryHeldSeat()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setIsAllocate()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setIsChangeLock()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setIsChangePriceLevel()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setIsChangePrivateProperty()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setIsChangeSeatType()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setIsEntireArea()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setIsUnallocate()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setLockTypeId()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setPriceLevelId()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setPrivateProperty()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setSeatIds()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setSeatTypeId()
     * @uses BizAction_Ticketing_UpdateSeatAttributes_Request::setUnallocationTypeId()
     * @param string $allocationTypeId
     * @param string $areaId
     * @param \patest\StructType\RecordSetOfTicketing_DatesToExclude $datesToExclude
     * @param \patest\StructType\EventIds $eventIds
     * @param \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria $eventsCriteria
     * @param bool $exceptAllocatedSeat
     * @param bool $exceptLockedSeat
     * @param bool $exceptReservedSeat
     * @param bool $exceptSoldSeat
     * @param bool $exceptTemporaryHeldSeat
     * @param bool $isAllocate
     * @param bool $isChangeLock
     * @param bool $isChangePriceLevel
     * @param bool $isChangePrivateProperty
     * @param bool $isChangeSeatType
     * @param bool $isEntireArea
     * @param bool $isUnallocate
     * @param string $lockTypeId
     * @param string $priceLevelId
     * @param string $privateProperty
     * @param string $seatIds
     * @param string $seatTypeId
     * @param string $unallocationTypeId
     */
    public function __construct($allocationTypeId = null, $areaId = null, \patest\StructType\RecordSetOfTicketing_DatesToExclude $datesToExclude = null, \patest\StructType\EventIds $eventIds = null, \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria $eventsCriteria = null, $exceptAllocatedSeat = null, $exceptLockedSeat = null, $exceptReservedSeat = null, $exceptSoldSeat = null, $exceptTemporaryHeldSeat = null, $isAllocate = null, $isChangeLock = null, $isChangePriceLevel = null, $isChangePrivateProperty = null, $isChangeSeatType = null, $isEntireArea = null, $isUnallocate = null, $lockTypeId = null, $priceLevelId = null, $privateProperty = null, $seatIds = null, $seatTypeId = null, $unallocationTypeId = null)
    {
        $this
            ->setAllocationTypeId($allocationTypeId)
            ->setAreaId($areaId)
            ->setDatesToExclude($datesToExclude)
            ->setEventIds($eventIds)
            ->setEventsCriteria($eventsCriteria)
            ->setExceptAllocatedSeat($exceptAllocatedSeat)
            ->setExceptLockedSeat($exceptLockedSeat)
            ->setExceptReservedSeat($exceptReservedSeat)
            ->setExceptSoldSeat($exceptSoldSeat)
            ->setExceptTemporaryHeldSeat($exceptTemporaryHeldSeat)
            ->setIsAllocate($isAllocate)
            ->setIsChangeLock($isChangeLock)
            ->setIsChangePriceLevel($isChangePriceLevel)
            ->setIsChangePrivateProperty($isChangePrivateProperty)
            ->setIsChangeSeatType($isChangeSeatType)
            ->setIsEntireArea($isEntireArea)
            ->setIsUnallocate($isUnallocate)
            ->setLockTypeId($lockTypeId)
            ->setPriceLevelId($priceLevelId)
            ->setPrivateProperty($privateProperty)
            ->setSeatIds($seatIds)
            ->setSeatTypeId($seatTypeId)
            ->setUnallocationTypeId($unallocationTypeId);
    }
    /**
     * Get AllocationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationTypeId()
    {
        return isset($this->AllocationTypeId) ? $this->AllocationTypeId : null;
    }
    /**
     * Set AllocationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationTypeId
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setAllocationTypeId($allocationTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($allocationTypeId) && !is_string($allocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationTypeId, true), gettype($allocationTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($allocationTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $allocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($allocationTypeId, true)), __LINE__);
        }
        if (is_null($allocationTypeId) || (is_array($allocationTypeId) && empty($allocationTypeId))) {
            unset($this->AllocationTypeId);
        } else {
            $this->AllocationTypeId = $allocationTypeId;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get DatesToExclude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_DatesToExclude|null
     */
    public function getDatesToExclude()
    {
        return isset($this->DatesToExclude) ? $this->DatesToExclude : null;
    }
    /**
     * Set DatesToExclude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_DatesToExclude $datesToExclude
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setDatesToExclude(\patest\StructType\RecordSetOfTicketing_DatesToExclude $datesToExclude = null)
    {
        if (is_null($datesToExclude) || (is_array($datesToExclude) && empty($datesToExclude))) {
            unset($this->DatesToExclude);
        } else {
            $this->DatesToExclude = $datesToExclude;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get EventsCriteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria|null
     */
    public function getEventsCriteria()
    {
        return isset($this->EventsCriteria) ? $this->EventsCriteria : null;
    }
    /**
     * Set EventsCriteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria $eventsCriteria
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setEventsCriteria(\patest\StructType\Ticketing_UpdateSeatAttributes_Criteria $eventsCriteria = null)
    {
        if (is_null($eventsCriteria) || (is_array($eventsCriteria) && empty($eventsCriteria))) {
            unset($this->EventsCriteria);
        } else {
            $this->EventsCriteria = $eventsCriteria;
        }
        return $this;
    }
    /**
     * Get ExceptAllocatedSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExceptAllocatedSeat()
    {
        return isset($this->ExceptAllocatedSeat) ? $this->ExceptAllocatedSeat : null;
    }
    /**
     * Set ExceptAllocatedSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exceptAllocatedSeat
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setExceptAllocatedSeat($exceptAllocatedSeat = null)
    {
        // validation for constraint: boolean
        if (!is_null($exceptAllocatedSeat) && !is_bool($exceptAllocatedSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exceptAllocatedSeat, true), gettype($exceptAllocatedSeat)), __LINE__);
        }
        if (is_null($exceptAllocatedSeat) || (is_array($exceptAllocatedSeat) && empty($exceptAllocatedSeat))) {
            unset($this->ExceptAllocatedSeat);
        } else {
            $this->ExceptAllocatedSeat = $exceptAllocatedSeat;
        }
        return $this;
    }
    /**
     * Get ExceptLockedSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExceptLockedSeat()
    {
        return isset($this->ExceptLockedSeat) ? $this->ExceptLockedSeat : null;
    }
    /**
     * Set ExceptLockedSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exceptLockedSeat
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setExceptLockedSeat($exceptLockedSeat = null)
    {
        // validation for constraint: boolean
        if (!is_null($exceptLockedSeat) && !is_bool($exceptLockedSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exceptLockedSeat, true), gettype($exceptLockedSeat)), __LINE__);
        }
        if (is_null($exceptLockedSeat) || (is_array($exceptLockedSeat) && empty($exceptLockedSeat))) {
            unset($this->ExceptLockedSeat);
        } else {
            $this->ExceptLockedSeat = $exceptLockedSeat;
        }
        return $this;
    }
    /**
     * Get ExceptReservedSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExceptReservedSeat()
    {
        return isset($this->ExceptReservedSeat) ? $this->ExceptReservedSeat : null;
    }
    /**
     * Set ExceptReservedSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exceptReservedSeat
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setExceptReservedSeat($exceptReservedSeat = null)
    {
        // validation for constraint: boolean
        if (!is_null($exceptReservedSeat) && !is_bool($exceptReservedSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exceptReservedSeat, true), gettype($exceptReservedSeat)), __LINE__);
        }
        if (is_null($exceptReservedSeat) || (is_array($exceptReservedSeat) && empty($exceptReservedSeat))) {
            unset($this->ExceptReservedSeat);
        } else {
            $this->ExceptReservedSeat = $exceptReservedSeat;
        }
        return $this;
    }
    /**
     * Get ExceptSoldSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExceptSoldSeat()
    {
        return isset($this->ExceptSoldSeat) ? $this->ExceptSoldSeat : null;
    }
    /**
     * Set ExceptSoldSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exceptSoldSeat
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setExceptSoldSeat($exceptSoldSeat = null)
    {
        // validation for constraint: boolean
        if (!is_null($exceptSoldSeat) && !is_bool($exceptSoldSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exceptSoldSeat, true), gettype($exceptSoldSeat)), __LINE__);
        }
        if (is_null($exceptSoldSeat) || (is_array($exceptSoldSeat) && empty($exceptSoldSeat))) {
            unset($this->ExceptSoldSeat);
        } else {
            $this->ExceptSoldSeat = $exceptSoldSeat;
        }
        return $this;
    }
    /**
     * Get ExceptTemporaryHeldSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExceptTemporaryHeldSeat()
    {
        return isset($this->ExceptTemporaryHeldSeat) ? $this->ExceptTemporaryHeldSeat : null;
    }
    /**
     * Set ExceptTemporaryHeldSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exceptTemporaryHeldSeat
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setExceptTemporaryHeldSeat($exceptTemporaryHeldSeat = null)
    {
        // validation for constraint: boolean
        if (!is_null($exceptTemporaryHeldSeat) && !is_bool($exceptTemporaryHeldSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exceptTemporaryHeldSeat, true), gettype($exceptTemporaryHeldSeat)), __LINE__);
        }
        if (is_null($exceptTemporaryHeldSeat) || (is_array($exceptTemporaryHeldSeat) && empty($exceptTemporaryHeldSeat))) {
            unset($this->ExceptTemporaryHeldSeat);
        } else {
            $this->ExceptTemporaryHeldSeat = $exceptTemporaryHeldSeat;
        }
        return $this;
    }
    /**
     * Get IsAllocate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAllocate()
    {
        return isset($this->IsAllocate) ? $this->IsAllocate : null;
    }
    /**
     * Set IsAllocate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAllocate
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setIsAllocate($isAllocate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllocate) && !is_bool($isAllocate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllocate, true), gettype($isAllocate)), __LINE__);
        }
        if (is_null($isAllocate) || (is_array($isAllocate) && empty($isAllocate))) {
            unset($this->IsAllocate);
        } else {
            $this->IsAllocate = $isAllocate;
        }
        return $this;
    }
    /**
     * Get IsChangeLock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsChangeLock()
    {
        return isset($this->IsChangeLock) ? $this->IsChangeLock : null;
    }
    /**
     * Set IsChangeLock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isChangeLock
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setIsChangeLock($isChangeLock = null)
    {
        // validation for constraint: boolean
        if (!is_null($isChangeLock) && !is_bool($isChangeLock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isChangeLock, true), gettype($isChangeLock)), __LINE__);
        }
        if (is_null($isChangeLock) || (is_array($isChangeLock) && empty($isChangeLock))) {
            unset($this->IsChangeLock);
        } else {
            $this->IsChangeLock = $isChangeLock;
        }
        return $this;
    }
    /**
     * Get IsChangePriceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsChangePriceLevel()
    {
        return isset($this->IsChangePriceLevel) ? $this->IsChangePriceLevel : null;
    }
    /**
     * Set IsChangePriceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isChangePriceLevel
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setIsChangePriceLevel($isChangePriceLevel = null)
    {
        // validation for constraint: boolean
        if (!is_null($isChangePriceLevel) && !is_bool($isChangePriceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isChangePriceLevel, true), gettype($isChangePriceLevel)), __LINE__);
        }
        if (is_null($isChangePriceLevel) || (is_array($isChangePriceLevel) && empty($isChangePriceLevel))) {
            unset($this->IsChangePriceLevel);
        } else {
            $this->IsChangePriceLevel = $isChangePriceLevel;
        }
        return $this;
    }
    /**
     * Get IsChangePrivateProperty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsChangePrivateProperty()
    {
        return isset($this->IsChangePrivateProperty) ? $this->IsChangePrivateProperty : null;
    }
    /**
     * Set IsChangePrivateProperty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isChangePrivateProperty
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setIsChangePrivateProperty($isChangePrivateProperty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isChangePrivateProperty) && !is_bool($isChangePrivateProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isChangePrivateProperty, true), gettype($isChangePrivateProperty)), __LINE__);
        }
        if (is_null($isChangePrivateProperty) || (is_array($isChangePrivateProperty) && empty($isChangePrivateProperty))) {
            unset($this->IsChangePrivateProperty);
        } else {
            $this->IsChangePrivateProperty = $isChangePrivateProperty;
        }
        return $this;
    }
    /**
     * Get IsChangeSeatType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsChangeSeatType()
    {
        return isset($this->IsChangeSeatType) ? $this->IsChangeSeatType : null;
    }
    /**
     * Set IsChangeSeatType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isChangeSeatType
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setIsChangeSeatType($isChangeSeatType = null)
    {
        // validation for constraint: boolean
        if (!is_null($isChangeSeatType) && !is_bool($isChangeSeatType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isChangeSeatType, true), gettype($isChangeSeatType)), __LINE__);
        }
        if (is_null($isChangeSeatType) || (is_array($isChangeSeatType) && empty($isChangeSeatType))) {
            unset($this->IsChangeSeatType);
        } else {
            $this->IsChangeSeatType = $isChangeSeatType;
        }
        return $this;
    }
    /**
     * Get IsEntireArea value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEntireArea()
    {
        return isset($this->IsEntireArea) ? $this->IsEntireArea : null;
    }
    /**
     * Set IsEntireArea value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEntireArea
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setIsEntireArea($isEntireArea = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEntireArea) && !is_bool($isEntireArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEntireArea, true), gettype($isEntireArea)), __LINE__);
        }
        if (is_null($isEntireArea) || (is_array($isEntireArea) && empty($isEntireArea))) {
            unset($this->IsEntireArea);
        } else {
            $this->IsEntireArea = $isEntireArea;
        }
        return $this;
    }
    /**
     * Get IsUnallocate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUnallocate()
    {
        return isset($this->IsUnallocate) ? $this->IsUnallocate : null;
    }
    /**
     * Set IsUnallocate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUnallocate
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setIsUnallocate($isUnallocate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUnallocate) && !is_bool($isUnallocate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUnallocate, true), gettype($isUnallocate)), __LINE__);
        }
        if (is_null($isUnallocate) || (is_array($isUnallocate) && empty($isUnallocate))) {
            unset($this->IsUnallocate);
        } else {
            $this->IsUnallocate = $isUnallocate;
        }
        return $this;
    }
    /**
     * Get LockTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockTypeId()
    {
        return isset($this->LockTypeId) ? $this->LockTypeId : null;
    }
    /**
     * Set LockTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockTypeId
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setLockTypeId($lockTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($lockTypeId) && !is_string($lockTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockTypeId, true), gettype($lockTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockTypeId, true)), __LINE__);
        }
        if (is_null($lockTypeId) || (is_array($lockTypeId) && empty($lockTypeId))) {
            unset($this->LockTypeId);
        } else {
            $this->LockTypeId = $lockTypeId;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PrivateProperty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrivateProperty()
    {
        return isset($this->PrivateProperty) ? $this->PrivateProperty : null;
    }
    /**
     * Set PrivateProperty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\UpdateSeatAttributesPrivatePropertyOperation::valueIsValid()
     * @uses \patest\EnumType\UpdateSeatAttributesPrivatePropertyOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $privateProperty
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setPrivateProperty($privateProperty = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\UpdateSeatAttributesPrivatePropertyOperation::valueIsValid($privateProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\UpdateSeatAttributesPrivatePropertyOperation', is_array($privateProperty) ? implode(', ', $privateProperty) : var_export($privateProperty, true), implode(', ', \patest\EnumType\UpdateSeatAttributesPrivatePropertyOperation::getValidValues())), __LINE__);
        }
        if (is_null($privateProperty) || (is_array($privateProperty) && empty($privateProperty))) {
            unset($this->PrivateProperty);
        } else {
            $this->PrivateProperty = $privateProperty;
        }
        return $this;
    }
    /**
     * Get SeatIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatIds()
    {
        return isset($this->SeatIds) ? $this->SeatIds : null;
    }
    /**
     * Set SeatIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatIds
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setSeatIds($seatIds = null)
    {
        // validation for constraint: string
        if (!is_null($seatIds) && !is_string($seatIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatIds, true), gettype($seatIds)), __LINE__);
        }
        if (is_null($seatIds) || (is_array($seatIds) && empty($seatIds))) {
            unset($this->SeatIds);
        } else {
            $this->SeatIds = $seatIds;
        }
        return $this;
    }
    /**
     * Get SeatTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeId()
    {
        return isset($this->SeatTypeId) ? $this->SeatTypeId : null;
    }
    /**
     * Set SeatTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeId
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setSeatTypeId($seatTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeId) && !is_string($seatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeId, true), gettype($seatTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatTypeId, true)), __LINE__);
        }
        if (is_null($seatTypeId) || (is_array($seatTypeId) && empty($seatTypeId))) {
            unset($this->SeatTypeId);
        } else {
            $this->SeatTypeId = $seatTypeId;
        }
        return $this;
    }
    /**
     * Get UnallocationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnallocationTypeId()
    {
        return isset($this->UnallocationTypeId) ? $this->UnallocationTypeId : null;
    }
    /**
     * Set UnallocationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unallocationTypeId
     * @return \patest\StructType\BizAction_Ticketing_UpdateSeatAttributes_Request
     */
    public function setUnallocationTypeId($unallocationTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($unallocationTypeId) && !is_string($unallocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unallocationTypeId, true), gettype($unallocationTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($unallocationTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $unallocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($unallocationTypeId, true)), __LINE__);
        }
        if (is_null($unallocationTypeId) || (is_array($unallocationTypeId) && empty($unallocationTypeId))) {
            unset($this->UnallocationTypeId);
        } else {
            $this->UnallocationTypeId = $unallocationTypeId;
        }
        return $this;
    }
}
