<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.SetSeatsQtyToRelatedClients.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request extends AnyEntity
{
    /**
     * The ApplicationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApplicationId;
    /**
     * The ApplicationOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApplicationOwnerId;
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The BallotVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BallotVersion;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IgnoreQtyValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IgnoreQtyValidation;
    /**
     * The ItemOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotItemOwner
     */
    public $ItemOwners;
    /**
     * The PreviousOwnerAssignmentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreviousOwnerAssignmentData;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The SectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectionId;
    /**
     * Constructor method for BizAction.Ticketing.SetSeatsQtyToRelatedClients.Request
     * @uses BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request::setApplicationId()
     * @uses BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request::setApplicationOwnerId()
     * @uses BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request::setBallotId()
     * @uses BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request::setBallotVersion()
     * @uses BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request::setEventId()
     * @uses BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request::setIgnoreQtyValidation()
     * @uses BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request::setItemOwners()
     * @uses BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request::setPreviousOwnerAssignmentData()
     * @uses BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request::setPriceTypeId()
     * @uses BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request::setSectionId()
     * @param string $applicationId
     * @param string $applicationOwnerId
     * @param string $ballotId
     * @param string $ballotVersion
     * @param string $eventId
     * @param bool $ignoreQtyValidation
     * @param \patest\StructType\RecordSetOfTicketing_BallotItemOwner $itemOwners
     * @param string $previousOwnerAssignmentData
     * @param string $priceTypeId
     * @param string $sectionId
     */
    public function __construct($applicationId = null, $applicationOwnerId = null, $ballotId = null, $ballotVersion = null, $eventId = null, $ignoreQtyValidation = null, \patest\StructType\RecordSetOfTicketing_BallotItemOwner $itemOwners = null, $previousOwnerAssignmentData = null, $priceTypeId = null, $sectionId = null)
    {
        $this
            ->setApplicationId($applicationId)
            ->setApplicationOwnerId($applicationOwnerId)
            ->setBallotId($ballotId)
            ->setBallotVersion($ballotVersion)
            ->setEventId($eventId)
            ->setIgnoreQtyValidation($ignoreQtyValidation)
            ->setItemOwners($itemOwners)
            ->setPreviousOwnerAssignmentData($previousOwnerAssignmentData)
            ->setPriceTypeId($priceTypeId)
            ->setSectionId($sectionId);
    }
    /**
     * Get ApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationId()
    {
        return isset($this->ApplicationId) ? $this->ApplicationId : null;
    }
    /**
     * Set ApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationId
     * @return \patest\StructType\BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($applicationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($applicationId, true)), __LINE__);
        }
        if (is_null($applicationId) || (is_array($applicationId) && empty($applicationId))) {
            unset($this->ApplicationId);
        } else {
            $this->ApplicationId = $applicationId;
        }
        return $this;
    }
    /**
     * Get ApplicationOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationOwnerId()
    {
        return isset($this->ApplicationOwnerId) ? $this->ApplicationOwnerId : null;
    }
    /**
     * Set ApplicationOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationOwnerId
     * @return \patest\StructType\BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request
     */
    public function setApplicationOwnerId($applicationOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationOwnerId) && !is_string($applicationOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationOwnerId, true), gettype($applicationOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($applicationOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $applicationOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($applicationOwnerId, true)), __LINE__);
        }
        if (is_null($applicationOwnerId) || (is_array($applicationOwnerId) && empty($applicationOwnerId))) {
            unset($this->ApplicationOwnerId);
        } else {
            $this->ApplicationOwnerId = $applicationOwnerId;
        }
        return $this;
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get BallotVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotVersion()
    {
        return isset($this->BallotVersion) ? $this->BallotVersion : null;
    }
    /**
     * Set BallotVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotVersion::valueIsValid()
     * @uses \patest\EnumType\BallotVersion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ballotVersion
     * @return \patest\StructType\BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request
     */
    public function setBallotVersion($ballotVersion = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotVersion::valueIsValid($ballotVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotVersion', is_array($ballotVersion) ? implode(', ', $ballotVersion) : var_export($ballotVersion, true), implode(', ', \patest\EnumType\BallotVersion::getValidValues())), __LINE__);
        }
        if (is_null($ballotVersion) || (is_array($ballotVersion) && empty($ballotVersion))) {
            unset($this->BallotVersion);
        } else {
            $this->BallotVersion = $ballotVersion;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get IgnoreQtyValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIgnoreQtyValidation()
    {
        return isset($this->IgnoreQtyValidation) ? $this->IgnoreQtyValidation : null;
    }
    /**
     * Set IgnoreQtyValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ignoreQtyValidation
     * @return \patest\StructType\BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request
     */
    public function setIgnoreQtyValidation($ignoreQtyValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreQtyValidation) && !is_bool($ignoreQtyValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreQtyValidation, true), gettype($ignoreQtyValidation)), __LINE__);
        }
        if (is_null($ignoreQtyValidation) || (is_array($ignoreQtyValidation) && empty($ignoreQtyValidation))) {
            unset($this->IgnoreQtyValidation);
        } else {
            $this->IgnoreQtyValidation = $ignoreQtyValidation;
        }
        return $this;
    }
    /**
     * Get ItemOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotItemOwner|null
     */
    public function getItemOwners()
    {
        return isset($this->ItemOwners) ? $this->ItemOwners : null;
    }
    /**
     * Set ItemOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotItemOwner $itemOwners
     * @return \patest\StructType\BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request
     */
    public function setItemOwners(\patest\StructType\RecordSetOfTicketing_BallotItemOwner $itemOwners = null)
    {
        if (is_null($itemOwners) || (is_array($itemOwners) && empty($itemOwners))) {
            unset($this->ItemOwners);
        } else {
            $this->ItemOwners = $itemOwners;
        }
        return $this;
    }
    /**
     * Get PreviousOwnerAssignmentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviousOwnerAssignmentData()
    {
        return isset($this->PreviousOwnerAssignmentData) ? $this->PreviousOwnerAssignmentData : null;
    }
    /**
     * Set PreviousOwnerAssignmentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previousOwnerAssignmentData
     * @return \patest\StructType\BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request
     */
    public function setPreviousOwnerAssignmentData($previousOwnerAssignmentData = null)
    {
        // validation for constraint: string
        if (!is_null($previousOwnerAssignmentData) && !is_string($previousOwnerAssignmentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousOwnerAssignmentData, true), gettype($previousOwnerAssignmentData)), __LINE__);
        }
        if (is_null($previousOwnerAssignmentData) || (is_array($previousOwnerAssignmentData) && empty($previousOwnerAssignmentData))) {
            unset($this->PreviousOwnerAssignmentData);
        } else {
            $this->PreviousOwnerAssignmentData = $previousOwnerAssignmentData;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get SectionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionId()
    {
        return isset($this->SectionId) ? $this->SectionId : null;
    }
    /**
     * Set SectionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionId
     * @return \patest\StructType\BizAction_Ticketing_SetSeatsQtyToRelatedClients_Request
     */
    public function setSectionId($sectionId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionId) && !is_string($sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionId, true), gettype($sectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectionId, true)), __LINE__);
        }
        if (is_null($sectionId) || (is_array($sectionId) && empty($sectionId))) {
            unset($this->SectionId);
        } else {
            $this->SectionId = $sectionId;
        }
        return $this;
    }
}
