<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.ReturnEventTickets.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_ReturnEventTickets_Request extends AnyEntity
{
    /**
     * The AllItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllItems;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DefaultAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultAreaId;
    /**
     * The DefaultSectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultSectorId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventPriceTypeGuids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventPriceTypeGuids;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_TicketsToReturn
     */
    public $Items;
    /**
     * The ReturnAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReturnAmount;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for BizAction.Ticketing.ReturnEventTickets.Request
     * @uses BizAction_Ticketing_ReturnEventTickets_Request::setAllItems()
     * @uses BizAction_Ticketing_ReturnEventTickets_Request::setClientId()
     * @uses BizAction_Ticketing_ReturnEventTickets_Request::setDefaultAreaId()
     * @uses BizAction_Ticketing_ReturnEventTickets_Request::setDefaultSectorId()
     * @uses BizAction_Ticketing_ReturnEventTickets_Request::setEventId()
     * @uses BizAction_Ticketing_ReturnEventTickets_Request::setEventPriceTypeGuids()
     * @uses BizAction_Ticketing_ReturnEventTickets_Request::setItems()
     * @uses BizAction_Ticketing_ReturnEventTickets_Request::setReturnAmount()
     * @uses BizAction_Ticketing_ReturnEventTickets_Request::setTransactionGuid()
     * @param string $allItems
     * @param string $clientId
     * @param string $defaultAreaId
     * @param string $defaultSectorId
     * @param string $eventId
     * @param string $eventPriceTypeGuids
     * @param \patest\StructType\RecordSetOfTicketing_TicketsToReturn $items
     * @param int $returnAmount
     * @param string $transactionGuid
     */
    public function __construct($allItems = null, $clientId = null, $defaultAreaId = null, $defaultSectorId = null, $eventId = null, $eventPriceTypeGuids = null, \patest\StructType\RecordSetOfTicketing_TicketsToReturn $items = null, $returnAmount = null, $transactionGuid = null)
    {
        $this
            ->setAllItems($allItems)
            ->setClientId($clientId)
            ->setDefaultAreaId($defaultAreaId)
            ->setDefaultSectorId($defaultSectorId)
            ->setEventId($eventId)
            ->setEventPriceTypeGuids($eventPriceTypeGuids)
            ->setItems($items)
            ->setReturnAmount($returnAmount)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get AllItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllItems()
    {
        return isset($this->AllItems) ? $this->AllItems : null;
    }
    /**
     * Set AllItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allItems
     * @return \patest\StructType\BizAction_Ticketing_ReturnEventTickets_Request
     */
    public function setAllItems($allItems = null)
    {
        // validation for constraint: string
        if (!is_null($allItems) && !is_string($allItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allItems, true), gettype($allItems)), __LINE__);
        }
        if (is_null($allItems) || (is_array($allItems) && empty($allItems))) {
            unset($this->AllItems);
        } else {
            $this->AllItems = $allItems;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Ticketing_ReturnEventTickets_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DefaultAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultAreaId()
    {
        return isset($this->DefaultAreaId) ? $this->DefaultAreaId : null;
    }
    /**
     * Set DefaultAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultAreaId
     * @return \patest\StructType\BizAction_Ticketing_ReturnEventTickets_Request
     */
    public function setDefaultAreaId($defaultAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAreaId) && !is_string($defaultAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAreaId, true), gettype($defaultAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultAreaId, true)), __LINE__);
        }
        if (is_null($defaultAreaId) || (is_array($defaultAreaId) && empty($defaultAreaId))) {
            unset($this->DefaultAreaId);
        } else {
            $this->DefaultAreaId = $defaultAreaId;
        }
        return $this;
    }
    /**
     * Get DefaultSectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSectorId()
    {
        return isset($this->DefaultSectorId) ? $this->DefaultSectorId : null;
    }
    /**
     * Set DefaultSectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSectorId
     * @return \patest\StructType\BizAction_Ticketing_ReturnEventTickets_Request
     */
    public function setDefaultSectorId($defaultSectorId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSectorId) && !is_string($defaultSectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSectorId, true), gettype($defaultSectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultSectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultSectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultSectorId, true)), __LINE__);
        }
        if (is_null($defaultSectorId) || (is_array($defaultSectorId) && empty($defaultSectorId))) {
            unset($this->DefaultSectorId);
        } else {
            $this->DefaultSectorId = $defaultSectorId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_ReturnEventTickets_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventPriceTypeGuids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventPriceTypeGuids()
    {
        return isset($this->EventPriceTypeGuids) ? $this->EventPriceTypeGuids : null;
    }
    /**
     * Set EventPriceTypeGuids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventPriceTypeGuids
     * @return \patest\StructType\BizAction_Ticketing_ReturnEventTickets_Request
     */
    public function setEventPriceTypeGuids($eventPriceTypeGuids = null)
    {
        // validation for constraint: string
        if (!is_null($eventPriceTypeGuids) && !is_string($eventPriceTypeGuids)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventPriceTypeGuids, true), gettype($eventPriceTypeGuids)), __LINE__);
        }
        if (is_null($eventPriceTypeGuids) || (is_array($eventPriceTypeGuids) && empty($eventPriceTypeGuids))) {
            unset($this->EventPriceTypeGuids);
        } else {
            $this->EventPriceTypeGuids = $eventPriceTypeGuids;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_TicketsToReturn|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_TicketsToReturn $items
     * @return \patest\StructType\BizAction_Ticketing_ReturnEventTickets_Request
     */
    public function setItems(\patest\StructType\RecordSetOfTicketing_TicketsToReturn $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get ReturnAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReturnAmount()
    {
        return isset($this->ReturnAmount) ? $this->ReturnAmount : null;
    }
    /**
     * Set ReturnAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $returnAmount
     * @return \patest\StructType\BizAction_Ticketing_ReturnEventTickets_Request
     */
    public function setReturnAmount($returnAmount = null)
    {
        // validation for constraint: int
        if (!is_null($returnAmount) && !(is_int($returnAmount) || ctype_digit($returnAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnAmount, true), gettype($returnAmount)), __LINE__);
        }
        if (is_null($returnAmount) || (is_array($returnAmount) && empty($returnAmount))) {
            unset($this->ReturnAmount);
        } else {
            $this->ReturnAmount = $returnAmount;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Ticketing_ReturnEventTickets_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
