<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.RepriceTickets.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_RepriceTickets_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientIds;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventIds;
    /**
     * The IsInClientCustody
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInClientCustody;
    /**
     * The KeepOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepOnCard;
    /**
     * The NewOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewOwnerId;
    /**
     * The NewPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $NewPrice;
    /**
     * The NewPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceTypeId;
    /**
     * The PrintTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintTickets;
    /**
     * The RepriceTicketsScenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RepriceTicketsScenario;
    /**
     * The SeriesEventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesEventIds;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesIds;
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Ticket
     */
    public $Tickets;
    /**
     * The TicketType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketType;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The UsePrintedTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsePrintedTickets;
    /**
     * Constructor method for BizAction.Ticketing.RepriceTickets.Request
     * @uses BizAction_Ticketing_RepriceTickets_Request::setClientId()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setClientIds()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setEventIds()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setIsInClientCustody()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setKeepOnCard()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setNewOwnerId()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setNewPrice()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setNewPriceTypeId()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setPrintTickets()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setRepriceTicketsScenario()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setSeriesEventIds()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setSeriesIds()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setTickets()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setTicketType()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setTransactionGuid()
     * @uses BizAction_Ticketing_RepriceTickets_Request::setUsePrintedTickets()
     * @param string $clientId
     * @param string $clientIds
     * @param string $eventIds
     * @param bool $isInClientCustody
     * @param bool $keepOnCard
     * @param string $newOwnerId
     * @param \patest\StructType\Money $newPrice
     * @param string $newPriceTypeId
     * @param bool $printTickets
     * @param string $repriceTicketsScenario
     * @param string $seriesEventIds
     * @param string $seriesIds
     * @param \patest\StructType\RecordSetOfTicketing_Ticket $tickets
     * @param string $ticketType
     * @param string $transactionGuid
     * @param bool $usePrintedTickets
     */
    public function __construct($clientId = null, $clientIds = null, $eventIds = null, $isInClientCustody = null, $keepOnCard = null, $newOwnerId = null, \patest\StructType\Money $newPrice = null, $newPriceTypeId = null, $printTickets = null, $repriceTicketsScenario = null, $seriesEventIds = null, $seriesIds = null, \patest\StructType\RecordSetOfTicketing_Ticket $tickets = null, $ticketType = null, $transactionGuid = null, $usePrintedTickets = null)
    {
        $this
            ->setClientId($clientId)
            ->setClientIds($clientIds)
            ->setEventIds($eventIds)
            ->setIsInClientCustody($isInClientCustody)
            ->setKeepOnCard($keepOnCard)
            ->setNewOwnerId($newOwnerId)
            ->setNewPrice($newPrice)
            ->setNewPriceTypeId($newPriceTypeId)
            ->setPrintTickets($printTickets)
            ->setRepriceTicketsScenario($repriceTicketsScenario)
            ->setSeriesEventIds($seriesEventIds)
            ->setSeriesIds($seriesIds)
            ->setTickets($tickets)
            ->setTicketType($ticketType)
            ->setTransactionGuid($transactionGuid)
            ->setUsePrintedTickets($usePrintedTickets);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientIds()
    {
        return isset($this->ClientIds) ? $this->ClientIds : null;
    }
    /**
     * Set ClientIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientIds
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setClientIds($clientIds = null)
    {
        // validation for constraint: string
        if (!is_null($clientIds) && !is_string($clientIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIds, true), gettype($clientIds)), __LINE__);
        }
        if (is_null($clientIds) || (is_array($clientIds) && empty($clientIds))) {
            unset($this->ClientIds);
        } else {
            $this->ClientIds = $clientIds;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventIds
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setEventIds($eventIds = null)
    {
        // validation for constraint: string
        if (!is_null($eventIds) && !is_string($eventIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventIds, true), gettype($eventIds)), __LINE__);
        }
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get IsInClientCustody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInClientCustody()
    {
        return isset($this->IsInClientCustody) ? $this->IsInClientCustody : null;
    }
    /**
     * Set IsInClientCustody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInClientCustody
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setIsInClientCustody($isInClientCustody = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInClientCustody) && !is_bool($isInClientCustody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInClientCustody, true), gettype($isInClientCustody)), __LINE__);
        }
        if (is_null($isInClientCustody) || (is_array($isInClientCustody) && empty($isInClientCustody))) {
            unset($this->IsInClientCustody);
        } else {
            $this->IsInClientCustody = $isInClientCustody;
        }
        return $this;
    }
    /**
     * Get KeepOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepOnCard()
    {
        return isset($this->KeepOnCard) ? $this->KeepOnCard : null;
    }
    /**
     * Set KeepOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepOnCard
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setKeepOnCard($keepOnCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepOnCard) && !is_bool($keepOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepOnCard, true), gettype($keepOnCard)), __LINE__);
        }
        if (is_null($keepOnCard) || (is_array($keepOnCard) && empty($keepOnCard))) {
            unset($this->KeepOnCard);
        } else {
            $this->KeepOnCard = $keepOnCard;
        }
        return $this;
    }
    /**
     * Get NewOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewOwnerId()
    {
        return isset($this->NewOwnerId) ? $this->NewOwnerId : null;
    }
    /**
     * Set NewOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newOwnerId
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setNewOwnerId($newOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($newOwnerId) && !is_string($newOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newOwnerId, true), gettype($newOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newOwnerId, true)), __LINE__);
        }
        if (is_null($newOwnerId) || (is_array($newOwnerId) && empty($newOwnerId))) {
            unset($this->NewOwnerId);
        } else {
            $this->NewOwnerId = $newOwnerId;
        }
        return $this;
    }
    /**
     * Get NewPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getNewPrice()
    {
        return isset($this->NewPrice) ? $this->NewPrice : null;
    }
    /**
     * Set NewPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $newPrice
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setNewPrice(\patest\StructType\Money $newPrice = null)
    {
        if (is_null($newPrice) || (is_array($newPrice) && empty($newPrice))) {
            unset($this->NewPrice);
        } else {
            $this->NewPrice = $newPrice;
        }
        return $this;
    }
    /**
     * Get NewPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPriceTypeId()
    {
        return isset($this->NewPriceTypeId) ? $this->NewPriceTypeId : null;
    }
    /**
     * Set NewPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPriceTypeId
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setNewPriceTypeId($newPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceTypeId) && !is_string($newPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceTypeId, true), gettype($newPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceTypeId, true)), __LINE__);
        }
        if (is_null($newPriceTypeId) || (is_array($newPriceTypeId) && empty($newPriceTypeId))) {
            unset($this->NewPriceTypeId);
        } else {
            $this->NewPriceTypeId = $newPriceTypeId;
        }
        return $this;
    }
    /**
     * Get PrintTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintTickets()
    {
        return isset($this->PrintTickets) ? $this->PrintTickets : null;
    }
    /**
     * Set PrintTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printTickets
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setPrintTickets($printTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($printTickets) && !is_bool($printTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printTickets, true), gettype($printTickets)), __LINE__);
        }
        if (is_null($printTickets) || (is_array($printTickets) && empty($printTickets))) {
            unset($this->PrintTickets);
        } else {
            $this->PrintTickets = $printTickets;
        }
        return $this;
    }
    /**
     * Get RepriceTicketsScenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRepriceTicketsScenario()
    {
        return isset($this->RepriceTicketsScenario) ? $this->RepriceTicketsScenario : null;
    }
    /**
     * Set RepriceTicketsScenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RepriceTicketsScenario::valueIsValid()
     * @uses \patest\EnumType\RepriceTicketsScenario::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $repriceTicketsScenario
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setRepriceTicketsScenario($repriceTicketsScenario = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RepriceTicketsScenario::valueIsValid($repriceTicketsScenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RepriceTicketsScenario', is_array($repriceTicketsScenario) ? implode(', ', $repriceTicketsScenario) : var_export($repriceTicketsScenario, true), implode(', ', \patest\EnumType\RepriceTicketsScenario::getValidValues())), __LINE__);
        }
        if (is_null($repriceTicketsScenario) || (is_array($repriceTicketsScenario) && empty($repriceTicketsScenario))) {
            unset($this->RepriceTicketsScenario);
        } else {
            $this->RepriceTicketsScenario = $repriceTicketsScenario;
        }
        return $this;
    }
    /**
     * Get SeriesEventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesEventIds()
    {
        return isset($this->SeriesEventIds) ? $this->SeriesEventIds : null;
    }
    /**
     * Set SeriesEventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesEventIds
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setSeriesEventIds($seriesEventIds = null)
    {
        // validation for constraint: string
        if (!is_null($seriesEventIds) && !is_string($seriesEventIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesEventIds, true), gettype($seriesEventIds)), __LINE__);
        }
        if (is_null($seriesEventIds) || (is_array($seriesEventIds) && empty($seriesEventIds))) {
            unset($this->SeriesEventIds);
        } else {
            $this->SeriesEventIds = $seriesEventIds;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesIds
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setSeriesIds($seriesIds = null)
    {
        // validation for constraint: string
        if (!is_null($seriesIds) && !is_string($seriesIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesIds, true), gettype($seriesIds)), __LINE__);
        }
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Ticket|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Ticket $tickets
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setTickets(\patest\StructType\RecordSetOfTicketing_Ticket $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
    /**
     * Get TicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketType()
    {
        return isset($this->TicketType) ? $this->TicketType : null;
    }
    /**
     * Set TicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketSummaryType::valueIsValid()
     * @uses \patest\EnumType\TicketSummaryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketType
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setTicketType($ticketType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketSummaryType::valueIsValid($ticketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketSummaryType', is_array($ticketType) ? implode(', ', $ticketType) : var_export($ticketType, true), implode(', ', \patest\EnumType\TicketSummaryType::getValidValues())), __LINE__);
        }
        if (is_null($ticketType) || (is_array($ticketType) && empty($ticketType))) {
            unset($this->TicketType);
        } else {
            $this->TicketType = $ticketType;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get UsePrintedTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsePrintedTickets()
    {
        return isset($this->UsePrintedTickets) ? $this->UsePrintedTickets : null;
    }
    /**
     * Set UsePrintedTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usePrintedTickets
     * @return \patest\StructType\BizAction_Ticketing_RepriceTickets_Request
     */
    public function setUsePrintedTickets($usePrintedTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($usePrintedTickets) && !is_bool($usePrintedTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usePrintedTickets, true), gettype($usePrintedTickets)), __LINE__);
        }
        if (is_null($usePrintedTickets) || (is_array($usePrintedTickets) && empty($usePrintedTickets))) {
            unset($this->UsePrintedTickets);
        } else {
            $this->UsePrintedTickets = $usePrintedTickets;
        }
        return $this;
    }
}
