<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.RepriceSubscriberTickets.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_RepriceSubscriberTickets_Request extends BizAction_Ticketing_RepriceProduct_Request
{
    /**
     * The SeriesEventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesEventIds;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesIds;
    /**
     * The SubscriberTicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriberTicketIds;
    /**
     * The SubscriptionInstanceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionInstanceIds;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for BizAction.Ticketing.RepriceSubscriberTickets.Request
     * @uses BizAction_Ticketing_RepriceSubscriberTickets_Request::setSeriesEventIds()
     * @uses BizAction_Ticketing_RepriceSubscriberTickets_Request::setSeriesIds()
     * @uses BizAction_Ticketing_RepriceSubscriberTickets_Request::setSubscriberTicketIds()
     * @uses BizAction_Ticketing_RepriceSubscriberTickets_Request::setSubscriptionInstanceIds()
     * @uses BizAction_Ticketing_RepriceSubscriberTickets_Request::setTransactionGuid()
     * @param string $seriesEventIds
     * @param string $seriesIds
     * @param string $subscriberTicketIds
     * @param string $subscriptionInstanceIds
     * @param string $transactionGuid
     */
    public function __construct($seriesEventIds = null, $seriesIds = null, $subscriberTicketIds = null, $subscriptionInstanceIds = null, $transactionGuid = null)
    {
        $this
            ->setSeriesEventIds($seriesEventIds)
            ->setSeriesIds($seriesIds)
            ->setSubscriberTicketIds($subscriberTicketIds)
            ->setSubscriptionInstanceIds($subscriptionInstanceIds)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get SeriesEventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesEventIds()
    {
        return isset($this->SeriesEventIds) ? $this->SeriesEventIds : null;
    }
    /**
     * Set SeriesEventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesEventIds
     * @return \patest\StructType\BizAction_Ticketing_RepriceSubscriberTickets_Request
     */
    public function setSeriesEventIds($seriesEventIds = null)
    {
        // validation for constraint: string
        if (!is_null($seriesEventIds) && !is_string($seriesEventIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesEventIds, true), gettype($seriesEventIds)), __LINE__);
        }
        if (is_null($seriesEventIds) || (is_array($seriesEventIds) && empty($seriesEventIds))) {
            unset($this->SeriesEventIds);
        } else {
            $this->SeriesEventIds = $seriesEventIds;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesIds
     * @return \patest\StructType\BizAction_Ticketing_RepriceSubscriberTickets_Request
     */
    public function setSeriesIds($seriesIds = null)
    {
        // validation for constraint: string
        if (!is_null($seriesIds) && !is_string($seriesIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesIds, true), gettype($seriesIds)), __LINE__);
        }
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
    /**
     * Get SubscriberTicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberTicketIds()
    {
        return isset($this->SubscriberTicketIds) ? $this->SubscriberTicketIds : null;
    }
    /**
     * Set SubscriberTicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberTicketIds
     * @return \patest\StructType\BizAction_Ticketing_RepriceSubscriberTickets_Request
     */
    public function setSubscriberTicketIds($subscriberTicketIds = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberTicketIds) && !is_string($subscriberTicketIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberTicketIds, true), gettype($subscriberTicketIds)), __LINE__);
        }
        if (is_null($subscriberTicketIds) || (is_array($subscriberTicketIds) && empty($subscriberTicketIds))) {
            unset($this->SubscriberTicketIds);
        } else {
            $this->SubscriberTicketIds = $subscriberTicketIds;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceIds()
    {
        return isset($this->SubscriptionInstanceIds) ? $this->SubscriptionInstanceIds : null;
    }
    /**
     * Set SubscriptionInstanceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceIds
     * @return \patest\StructType\BizAction_Ticketing_RepriceSubscriberTickets_Request
     */
    public function setSubscriptionInstanceIds($subscriptionInstanceIds = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceIds) && !is_string($subscriptionInstanceIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceIds, true), gettype($subscriptionInstanceIds)), __LINE__);
        }
        if (is_null($subscriptionInstanceIds) || (is_array($subscriptionInstanceIds) && empty($subscriptionInstanceIds))) {
            unset($this->SubscriptionInstanceIds);
        } else {
            $this->SubscriptionInstanceIds = $subscriptionInstanceIds;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Ticketing_RepriceSubscriberTickets_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
