<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.PayUnpaidTicketsByTicketScheme.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request extends AnyEntity
{
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypes
     */
    public $ClientTypes;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The PaymentMethodIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PaymentMethodIds
     */
    public $PaymentMethodIds;
    /**
     * The SelectedPopulation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SelectedPopulation;
    /**
     * The TestOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TestOnly;
    /**
     * The TicketSchemeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketSchemeIds
     */
    public $TicketSchemeIds;
    /**
     * Constructor method for
     * BizAction.Ticketing.PayUnpaidTicketsByTicketScheme.Request
     * @uses BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request::setClientTypes()
     * @uses BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request::setEventIds()
     * @uses BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request::setPaymentMethodIds()
     * @uses BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request::setSelectedPopulation()
     * @uses BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request::setTestOnly()
     * @uses BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request::setTicketSchemeIds()
     * @param \patest\StructType\ClientTypes $clientTypes
     * @param \patest\StructType\EventIds $eventIds
     * @param \patest\StructType\PaymentMethodIds $paymentMethodIds
     * @param int $selectedPopulation
     * @param bool $testOnly
     * @param \patest\StructType\TicketSchemeIds $ticketSchemeIds
     */
    public function __construct(\patest\StructType\ClientTypes $clientTypes = null, \patest\StructType\EventIds $eventIds = null, \patest\StructType\PaymentMethodIds $paymentMethodIds = null, $selectedPopulation = null, $testOnly = null, \patest\StructType\TicketSchemeIds $ticketSchemeIds = null)
    {
        $this
            ->setClientTypes($clientTypes)
            ->setEventIds($eventIds)
            ->setPaymentMethodIds($paymentMethodIds)
            ->setSelectedPopulation($selectedPopulation)
            ->setTestOnly($testOnly)
            ->setTicketSchemeIds($ticketSchemeIds);
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypes|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypes $clientTypes
     * @return \patest\StructType\BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request
     */
    public function setClientTypes(\patest\StructType\ClientTypes $clientTypes = null)
    {
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get PaymentMethodIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PaymentMethodIds|null
     */
    public function getPaymentMethodIds()
    {
        return isset($this->PaymentMethodIds) ? $this->PaymentMethodIds : null;
    }
    /**
     * Set PaymentMethodIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PaymentMethodIds $paymentMethodIds
     * @return \patest\StructType\BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request
     */
    public function setPaymentMethodIds(\patest\StructType\PaymentMethodIds $paymentMethodIds = null)
    {
        if (is_null($paymentMethodIds) || (is_array($paymentMethodIds) && empty($paymentMethodIds))) {
            unset($this->PaymentMethodIds);
        } else {
            $this->PaymentMethodIds = $paymentMethodIds;
        }
        return $this;
    }
    /**
     * Get SelectedPopulation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSelectedPopulation()
    {
        return isset($this->SelectedPopulation) ? $this->SelectedPopulation : null;
    }
    /**
     * Set SelectedPopulation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $selectedPopulation
     * @return \patest\StructType\BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request
     */
    public function setSelectedPopulation($selectedPopulation = null)
    {
        // validation for constraint: int
        if (!is_null($selectedPopulation) && !(is_int($selectedPopulation) || ctype_digit($selectedPopulation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selectedPopulation, true), gettype($selectedPopulation)), __LINE__);
        }
        if (is_null($selectedPopulation) || (is_array($selectedPopulation) && empty($selectedPopulation))) {
            unset($this->SelectedPopulation);
        } else {
            $this->SelectedPopulation = $selectedPopulation;
        }
        return $this;
    }
    /**
     * Get TestOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTestOnly()
    {
        return isset($this->TestOnly) ? $this->TestOnly : null;
    }
    /**
     * Set TestOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $testOnly
     * @return \patest\StructType\BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request
     */
    public function setTestOnly($testOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($testOnly) && !is_bool($testOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($testOnly, true), gettype($testOnly)), __LINE__);
        }
        if (is_null($testOnly) || (is_array($testOnly) && empty($testOnly))) {
            unset($this->TestOnly);
        } else {
            $this->TestOnly = $testOnly;
        }
        return $this;
    }
    /**
     * Get TicketSchemeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketSchemeIds|null
     */
    public function getTicketSchemeIds()
    {
        return isset($this->TicketSchemeIds) ? $this->TicketSchemeIds : null;
    }
    /**
     * Set TicketSchemeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketSchemeIds $ticketSchemeIds
     * @return \patest\StructType\BizAction_Ticketing_PayUnpaidTicketsByTicketScheme_Request
     */
    public function setTicketSchemeIds(\patest\StructType\TicketSchemeIds $ticketSchemeIds = null)
    {
        if (is_null($ticketSchemeIds) || (is_array($ticketSchemeIds) && empty($ticketSchemeIds))) {
            unset($this->TicketSchemeIds);
        } else {
            $this->TicketSchemeIds = $ticketSchemeIds;
        }
        return $this;
    }
}
