<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.MarkTicketsForResale.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_MarkTicketsForResale_Request extends AnyEntity
{
    /**
     * The AllowRequestByRelatives
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowRequestByRelatives;
    /**
     * The AllowRequestWithoutPaymentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowRequestWithoutPaymentDetails;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DirectDebitMandateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DirectDebitMandateId;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The TicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketIds
     */
    public $TicketIds;
    /**
     * The TicketResaleMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketResaleMethod;
    /**
     * Constructor method for BizAction.Ticketing.MarkTicketsForResale.Request
     * @uses BizAction_Ticketing_MarkTicketsForResale_Request::setAllowRequestByRelatives()
     * @uses BizAction_Ticketing_MarkTicketsForResale_Request::setAllowRequestWithoutPaymentDetails()
     * @uses BizAction_Ticketing_MarkTicketsForResale_Request::setClientId()
     * @uses BizAction_Ticketing_MarkTicketsForResale_Request::setDirectDebitMandateId()
     * @uses BizAction_Ticketing_MarkTicketsForResale_Request::setPaymentMethodId()
     * @uses BizAction_Ticketing_MarkTicketsForResale_Request::setPaymentMethodType()
     * @uses BizAction_Ticketing_MarkTicketsForResale_Request::setPaymentTokenId()
     * @uses BizAction_Ticketing_MarkTicketsForResale_Request::setTicketIds()
     * @uses BizAction_Ticketing_MarkTicketsForResale_Request::setTicketResaleMethod()
     * @param bool $allowRequestByRelatives
     * @param bool $allowRequestWithoutPaymentDetails
     * @param string $clientId
     * @param string $directDebitMandateId
     * @param string $paymentMethodId
     * @param string $paymentMethodType
     * @param string $paymentTokenId
     * @param \patest\StructType\TicketIds $ticketIds
     * @param string $ticketResaleMethod
     */
    public function __construct($allowRequestByRelatives = null, $allowRequestWithoutPaymentDetails = null, $clientId = null, $directDebitMandateId = null, $paymentMethodId = null, $paymentMethodType = null, $paymentTokenId = null, \patest\StructType\TicketIds $ticketIds = null, $ticketResaleMethod = null)
    {
        $this
            ->setAllowRequestByRelatives($allowRequestByRelatives)
            ->setAllowRequestWithoutPaymentDetails($allowRequestWithoutPaymentDetails)
            ->setClientId($clientId)
            ->setDirectDebitMandateId($directDebitMandateId)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodType($paymentMethodType)
            ->setPaymentTokenId($paymentTokenId)
            ->setTicketIds($ticketIds)
            ->setTicketResaleMethod($ticketResaleMethod);
    }
    /**
     * Get AllowRequestByRelatives value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowRequestByRelatives()
    {
        return isset($this->AllowRequestByRelatives) ? $this->AllowRequestByRelatives : null;
    }
    /**
     * Set AllowRequestByRelatives value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowRequestByRelatives
     * @return \patest\StructType\BizAction_Ticketing_MarkTicketsForResale_Request
     */
    public function setAllowRequestByRelatives($allowRequestByRelatives = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowRequestByRelatives) && !is_bool($allowRequestByRelatives)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowRequestByRelatives, true), gettype($allowRequestByRelatives)), __LINE__);
        }
        if (is_null($allowRequestByRelatives) || (is_array($allowRequestByRelatives) && empty($allowRequestByRelatives))) {
            unset($this->AllowRequestByRelatives);
        } else {
            $this->AllowRequestByRelatives = $allowRequestByRelatives;
        }
        return $this;
    }
    /**
     * Get AllowRequestWithoutPaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowRequestWithoutPaymentDetails()
    {
        return isset($this->AllowRequestWithoutPaymentDetails) ? $this->AllowRequestWithoutPaymentDetails : null;
    }
    /**
     * Set AllowRequestWithoutPaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowRequestWithoutPaymentDetails
     * @return \patest\StructType\BizAction_Ticketing_MarkTicketsForResale_Request
     */
    public function setAllowRequestWithoutPaymentDetails($allowRequestWithoutPaymentDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowRequestWithoutPaymentDetails) && !is_bool($allowRequestWithoutPaymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowRequestWithoutPaymentDetails, true), gettype($allowRequestWithoutPaymentDetails)), __LINE__);
        }
        if (is_null($allowRequestWithoutPaymentDetails) || (is_array($allowRequestWithoutPaymentDetails) && empty($allowRequestWithoutPaymentDetails))) {
            unset($this->AllowRequestWithoutPaymentDetails);
        } else {
            $this->AllowRequestWithoutPaymentDetails = $allowRequestWithoutPaymentDetails;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Ticketing_MarkTicketsForResale_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DirectDebitMandateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectDebitMandateId()
    {
        return isset($this->DirectDebitMandateId) ? $this->DirectDebitMandateId : null;
    }
    /**
     * Set DirectDebitMandateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directDebitMandateId
     * @return \patest\StructType\BizAction_Ticketing_MarkTicketsForResale_Request
     */
    public function setDirectDebitMandateId($directDebitMandateId = null)
    {
        // validation for constraint: string
        if (!is_null($directDebitMandateId) && !is_string($directDebitMandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directDebitMandateId, true), gettype($directDebitMandateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($directDebitMandateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $directDebitMandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($directDebitMandateId, true)), __LINE__);
        }
        if (is_null($directDebitMandateId) || (is_array($directDebitMandateId) && empty($directDebitMandateId))) {
            unset($this->DirectDebitMandateId);
        } else {
            $this->DirectDebitMandateId = $directDebitMandateId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Ticketing_MarkTicketsForResale_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\BizAction_Ticketing_MarkTicketsForResale_Request
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\BizAction_Ticketing_MarkTicketsForResale_Request
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
    /**
     * Get TicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketIds|null
     */
    public function getTicketIds()
    {
        return isset($this->TicketIds) ? $this->TicketIds : null;
    }
    /**
     * Set TicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketIds $ticketIds
     * @return \patest\StructType\BizAction_Ticketing_MarkTicketsForResale_Request
     */
    public function setTicketIds(\patest\StructType\TicketIds $ticketIds = null)
    {
        if (is_null($ticketIds) || (is_array($ticketIds) && empty($ticketIds))) {
            unset($this->TicketIds);
        } else {
            $this->TicketIds = $ticketIds;
        }
        return $this;
    }
    /**
     * Get TicketResaleMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketResaleMethod()
    {
        return isset($this->TicketResaleMethod) ? $this->TicketResaleMethod : null;
    }
    /**
     * Set TicketResaleMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketResaleMethod::valueIsValid()
     * @uses \patest\EnumType\TicketResaleMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketResaleMethod
     * @return \patest\StructType\BizAction_Ticketing_MarkTicketsForResale_Request
     */
    public function setTicketResaleMethod($ticketResaleMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketResaleMethod::valueIsValid($ticketResaleMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketResaleMethod', is_array($ticketResaleMethod) ? implode(', ', $ticketResaleMethod) : var_export($ticketResaleMethod, true), implode(', ', \patest\EnumType\TicketResaleMethod::getValidValues())), __LINE__);
        }
        if (is_null($ticketResaleMethod) || (is_array($ticketResaleMethod) && empty($ticketResaleMethod))) {
            unset($this->TicketResaleMethod);
        } else {
            $this->TicketResaleMethod = $ticketResaleMethod;
        }
        return $this;
    }
}
