<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.ManageResale.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_ManageResale_Request extends AnyEntity
{
    /**
     * The AutoLockSeatForResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutoLockSeatForResale;
    /**
     * The CountPendingCancelled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CountPendingCancelled;
    /**
     * The CountPendingRefund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CountPendingRefund;
    /**
     * The CountPendingResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CountPendingResale;
    /**
     * The CountRefunded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CountRefunded;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The LockId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockId;
    /**
     * The ResaleAvailabilityByApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleAvailabilityByApplicationChannel;
    /**
     * Constructor method for BizAction.Ticketing.ManageResale.Request
     * @uses BizAction_Ticketing_ManageResale_Request::setAutoLockSeatForResale()
     * @uses BizAction_Ticketing_ManageResale_Request::setCountPendingCancelled()
     * @uses BizAction_Ticketing_ManageResale_Request::setCountPendingRefund()
     * @uses BizAction_Ticketing_ManageResale_Request::setCountPendingResale()
     * @uses BizAction_Ticketing_ManageResale_Request::setCountRefunded()
     * @uses BizAction_Ticketing_ManageResale_Request::setEventId()
     * @uses BizAction_Ticketing_ManageResale_Request::setLockId()
     * @uses BizAction_Ticketing_ManageResale_Request::setResaleAvailabilityByApplicationChannel()
     * @param bool $autoLockSeatForResale
     * @param int $countPendingCancelled
     * @param int $countPendingRefund
     * @param int $countPendingResale
     * @param int $countRefunded
     * @param string $eventId
     * @param string $lockId
     * @param string $resaleAvailabilityByApplicationChannel
     */
    public function __construct($autoLockSeatForResale = null, $countPendingCancelled = null, $countPendingRefund = null, $countPendingResale = null, $countRefunded = null, $eventId = null, $lockId = null, $resaleAvailabilityByApplicationChannel = null)
    {
        $this
            ->setAutoLockSeatForResale($autoLockSeatForResale)
            ->setCountPendingCancelled($countPendingCancelled)
            ->setCountPendingRefund($countPendingRefund)
            ->setCountPendingResale($countPendingResale)
            ->setCountRefunded($countRefunded)
            ->setEventId($eventId)
            ->setLockId($lockId)
            ->setResaleAvailabilityByApplicationChannel($resaleAvailabilityByApplicationChannel);
    }
    /**
     * Get AutoLockSeatForResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutoLockSeatForResale()
    {
        return isset($this->AutoLockSeatForResale) ? $this->AutoLockSeatForResale : null;
    }
    /**
     * Set AutoLockSeatForResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $autoLockSeatForResale
     * @return \patest\StructType\BizAction_Ticketing_ManageResale_Request
     */
    public function setAutoLockSeatForResale($autoLockSeatForResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoLockSeatForResale) && !is_bool($autoLockSeatForResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoLockSeatForResale, true), gettype($autoLockSeatForResale)), __LINE__);
        }
        if (is_null($autoLockSeatForResale) || (is_array($autoLockSeatForResale) && empty($autoLockSeatForResale))) {
            unset($this->AutoLockSeatForResale);
        } else {
            $this->AutoLockSeatForResale = $autoLockSeatForResale;
        }
        return $this;
    }
    /**
     * Get CountPendingCancelled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCountPendingCancelled()
    {
        return isset($this->CountPendingCancelled) ? $this->CountPendingCancelled : null;
    }
    /**
     * Set CountPendingCancelled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $countPendingCancelled
     * @return \patest\StructType\BizAction_Ticketing_ManageResale_Request
     */
    public function setCountPendingCancelled($countPendingCancelled = null)
    {
        // validation for constraint: int
        if (!is_null($countPendingCancelled) && !(is_int($countPendingCancelled) || ctype_digit($countPendingCancelled))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countPendingCancelled, true), gettype($countPendingCancelled)), __LINE__);
        }
        if (is_null($countPendingCancelled) || (is_array($countPendingCancelled) && empty($countPendingCancelled))) {
            unset($this->CountPendingCancelled);
        } else {
            $this->CountPendingCancelled = $countPendingCancelled;
        }
        return $this;
    }
    /**
     * Get CountPendingRefund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCountPendingRefund()
    {
        return isset($this->CountPendingRefund) ? $this->CountPendingRefund : null;
    }
    /**
     * Set CountPendingRefund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $countPendingRefund
     * @return \patest\StructType\BizAction_Ticketing_ManageResale_Request
     */
    public function setCountPendingRefund($countPendingRefund = null)
    {
        // validation for constraint: int
        if (!is_null($countPendingRefund) && !(is_int($countPendingRefund) || ctype_digit($countPendingRefund))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countPendingRefund, true), gettype($countPendingRefund)), __LINE__);
        }
        if (is_null($countPendingRefund) || (is_array($countPendingRefund) && empty($countPendingRefund))) {
            unset($this->CountPendingRefund);
        } else {
            $this->CountPendingRefund = $countPendingRefund;
        }
        return $this;
    }
    /**
     * Get CountPendingResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCountPendingResale()
    {
        return isset($this->CountPendingResale) ? $this->CountPendingResale : null;
    }
    /**
     * Set CountPendingResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $countPendingResale
     * @return \patest\StructType\BizAction_Ticketing_ManageResale_Request
     */
    public function setCountPendingResale($countPendingResale = null)
    {
        // validation for constraint: int
        if (!is_null($countPendingResale) && !(is_int($countPendingResale) || ctype_digit($countPendingResale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countPendingResale, true), gettype($countPendingResale)), __LINE__);
        }
        if (is_null($countPendingResale) || (is_array($countPendingResale) && empty($countPendingResale))) {
            unset($this->CountPendingResale);
        } else {
            $this->CountPendingResale = $countPendingResale;
        }
        return $this;
    }
    /**
     * Get CountRefunded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCountRefunded()
    {
        return isset($this->CountRefunded) ? $this->CountRefunded : null;
    }
    /**
     * Set CountRefunded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $countRefunded
     * @return \patest\StructType\BizAction_Ticketing_ManageResale_Request
     */
    public function setCountRefunded($countRefunded = null)
    {
        // validation for constraint: int
        if (!is_null($countRefunded) && !(is_int($countRefunded) || ctype_digit($countRefunded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countRefunded, true), gettype($countRefunded)), __LINE__);
        }
        if (is_null($countRefunded) || (is_array($countRefunded) && empty($countRefunded))) {
            unset($this->CountRefunded);
        } else {
            $this->CountRefunded = $countRefunded;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_ManageResale_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get LockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockId()
    {
        return isset($this->LockId) ? $this->LockId : null;
    }
    /**
     * Set LockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockId
     * @return \patest\StructType\BizAction_Ticketing_ManageResale_Request
     */
    public function setLockId($lockId = null)
    {
        // validation for constraint: string
        if (!is_null($lockId) && !is_string($lockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockId, true), gettype($lockId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockId, true)), __LINE__);
        }
        if (is_null($lockId) || (is_array($lockId) && empty($lockId))) {
            unset($this->LockId);
        } else {
            $this->LockId = $lockId;
        }
        return $this;
    }
    /**
     * Get ResaleAvailabilityByApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleAvailabilityByApplicationChannel()
    {
        return isset($this->ResaleAvailabilityByApplicationChannel) ? $this->ResaleAvailabilityByApplicationChannel : null;
    }
    /**
     * Set ResaleAvailabilityByApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resaleAvailabilityByApplicationChannel
     * @return \patest\StructType\BizAction_Ticketing_ManageResale_Request
     */
    public function setResaleAvailabilityByApplicationChannel($resaleAvailabilityByApplicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($resaleAvailabilityByApplicationChannel) && !is_string($resaleAvailabilityByApplicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resaleAvailabilityByApplicationChannel, true), gettype($resaleAvailabilityByApplicationChannel)), __LINE__);
        }
        if (is_null($resaleAvailabilityByApplicationChannel) || (is_array($resaleAvailabilityByApplicationChannel) && empty($resaleAvailabilityByApplicationChannel))) {
            unset($this->ResaleAvailabilityByApplicationChannel);
        } else {
            $this->ResaleAvailabilityByApplicationChannel = $resaleAvailabilityByApplicationChannel;
        }
        return $this;
    }
}
