<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.InitiateSeatGeekTransfer.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_InitiateSeatGeekTransfer_Request extends AnyEntity
{
    /**
     * The NewClientEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewClientEmail;
    /**
     * The NewClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewClientId;
    /**
     * The NewClientPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewClientPhone;
    /**
     * The TicketCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketCount;
    /**
     * The TicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketIds
     */
    public $TicketIds;
    /**
     * The TransferRecipientType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransferRecipientType;
    /**
     * Constructor method for BizAction.Ticketing.InitiateSeatGeekTransfer.Request
     * @uses BizAction_Ticketing_InitiateSeatGeekTransfer_Request::setNewClientEmail()
     * @uses BizAction_Ticketing_InitiateSeatGeekTransfer_Request::setNewClientId()
     * @uses BizAction_Ticketing_InitiateSeatGeekTransfer_Request::setNewClientPhone()
     * @uses BizAction_Ticketing_InitiateSeatGeekTransfer_Request::setTicketCount()
     * @uses BizAction_Ticketing_InitiateSeatGeekTransfer_Request::setTicketIds()
     * @uses BizAction_Ticketing_InitiateSeatGeekTransfer_Request::setTransferRecipientType()
     * @param string $newClientEmail
     * @param string $newClientId
     * @param string $newClientPhone
     * @param int $ticketCount
     * @param \patest\StructType\TicketIds $ticketIds
     * @param string $transferRecipientType
     */
    public function __construct($newClientEmail = null, $newClientId = null, $newClientPhone = null, $ticketCount = null, \patest\StructType\TicketIds $ticketIds = null, $transferRecipientType = null)
    {
        $this
            ->setNewClientEmail($newClientEmail)
            ->setNewClientId($newClientId)
            ->setNewClientPhone($newClientPhone)
            ->setTicketCount($ticketCount)
            ->setTicketIds($ticketIds)
            ->setTransferRecipientType($transferRecipientType);
    }
    /**
     * Get NewClientEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewClientEmail()
    {
        return isset($this->NewClientEmail) ? $this->NewClientEmail : null;
    }
    /**
     * Set NewClientEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newClientEmail
     * @return \patest\StructType\BizAction_Ticketing_InitiateSeatGeekTransfer_Request
     */
    public function setNewClientEmail($newClientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($newClientEmail) && !is_string($newClientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newClientEmail, true), gettype($newClientEmail)), __LINE__);
        }
        if (is_null($newClientEmail) || (is_array($newClientEmail) && empty($newClientEmail))) {
            unset($this->NewClientEmail);
        } else {
            $this->NewClientEmail = $newClientEmail;
        }
        return $this;
    }
    /**
     * Get NewClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewClientId()
    {
        return isset($this->NewClientId) ? $this->NewClientId : null;
    }
    /**
     * Set NewClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newClientId
     * @return \patest\StructType\BizAction_Ticketing_InitiateSeatGeekTransfer_Request
     */
    public function setNewClientId($newClientId = null)
    {
        // validation for constraint: string
        if (!is_null($newClientId) && !is_string($newClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newClientId, true), gettype($newClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newClientId, true)), __LINE__);
        }
        if (is_null($newClientId) || (is_array($newClientId) && empty($newClientId))) {
            unset($this->NewClientId);
        } else {
            $this->NewClientId = $newClientId;
        }
        return $this;
    }
    /**
     * Get NewClientPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewClientPhone()
    {
        return isset($this->NewClientPhone) ? $this->NewClientPhone : null;
    }
    /**
     * Set NewClientPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newClientPhone
     * @return \patest\StructType\BizAction_Ticketing_InitiateSeatGeekTransfer_Request
     */
    public function setNewClientPhone($newClientPhone = null)
    {
        // validation for constraint: string
        if (!is_null($newClientPhone) && !is_string($newClientPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newClientPhone, true), gettype($newClientPhone)), __LINE__);
        }
        if (is_null($newClientPhone) || (is_array($newClientPhone) && empty($newClientPhone))) {
            unset($this->NewClientPhone);
        } else {
            $this->NewClientPhone = $newClientPhone;
        }
        return $this;
    }
    /**
     * Get TicketCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketCount()
    {
        return isset($this->TicketCount) ? $this->TicketCount : null;
    }
    /**
     * Set TicketCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketCount
     * @return \patest\StructType\BizAction_Ticketing_InitiateSeatGeekTransfer_Request
     */
    public function setTicketCount($ticketCount = null)
    {
        // validation for constraint: int
        if (!is_null($ticketCount) && !(is_int($ticketCount) || ctype_digit($ticketCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketCount, true), gettype($ticketCount)), __LINE__);
        }
        if (is_null($ticketCount) || (is_array($ticketCount) && empty($ticketCount))) {
            unset($this->TicketCount);
        } else {
            $this->TicketCount = $ticketCount;
        }
        return $this;
    }
    /**
     * Get TicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketIds|null
     */
    public function getTicketIds()
    {
        return isset($this->TicketIds) ? $this->TicketIds : null;
    }
    /**
     * Set TicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketIds $ticketIds
     * @return \patest\StructType\BizAction_Ticketing_InitiateSeatGeekTransfer_Request
     */
    public function setTicketIds(\patest\StructType\TicketIds $ticketIds = null)
    {
        if (is_null($ticketIds) || (is_array($ticketIds) && empty($ticketIds))) {
            unset($this->TicketIds);
        } else {
            $this->TicketIds = $ticketIds;
        }
        return $this;
    }
    /**
     * Get TransferRecipientType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransferRecipientType()
    {
        return isset($this->TransferRecipientType) ? $this->TransferRecipientType : null;
    }
    /**
     * Set TransferRecipientType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transferRecipientType
     * @return \patest\StructType\BizAction_Ticketing_InitiateSeatGeekTransfer_Request
     */
    public function setTransferRecipientType($transferRecipientType = null)
    {
        // validation for constraint: string
        if (!is_null($transferRecipientType) && !is_string($transferRecipientType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferRecipientType, true), gettype($transferRecipientType)), __LINE__);
        }
        if (is_null($transferRecipientType) || (is_array($transferRecipientType) && empty($transferRecipientType))) {
            unset($this->TransferRecipientType);
        } else {
            $this->TransferRecipientType = $transferRecipientType;
        }
        return $this;
    }
}
