<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.ImportHallVersion.SeatTypeMapping
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_ImportHallVersion_SeatTypeMapping extends AnyEntity
{
    /**
     * The IdInDataFile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInDataFile;
    /**
     * The OriginalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $OriginalName;
    /**
     * The TargetSeatTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetSeatTypeId;
    /**
     * Constructor method for BizAction.Ticketing.ImportHallVersion.SeatTypeMapping
     * @uses BizAction_Ticketing_ImportHallVersion_SeatTypeMapping::setIdInDataFile()
     * @uses BizAction_Ticketing_ImportHallVersion_SeatTypeMapping::setOriginalName()
     * @uses BizAction_Ticketing_ImportHallVersion_SeatTypeMapping::setTargetSeatTypeId()
     * @param int $idInDataFile
     * @param \patest\StructType\GlobalString $originalName
     * @param string $targetSeatTypeId
     */
    public function __construct($idInDataFile = null, \patest\StructType\GlobalString $originalName = null, $targetSeatTypeId = null)
    {
        $this
            ->setIdInDataFile($idInDataFile)
            ->setOriginalName($originalName)
            ->setTargetSeatTypeId($targetSeatTypeId);
    }
    /**
     * Get IdInDataFile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInDataFile()
    {
        return isset($this->IdInDataFile) ? $this->IdInDataFile : null;
    }
    /**
     * Set IdInDataFile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInDataFile
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_SeatTypeMapping
     */
    public function setIdInDataFile($idInDataFile = null)
    {
        // validation for constraint: int
        if (!is_null($idInDataFile) && !(is_int($idInDataFile) || ctype_digit($idInDataFile))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInDataFile, true), gettype($idInDataFile)), __LINE__);
        }
        if (is_null($idInDataFile) || (is_array($idInDataFile) && empty($idInDataFile))) {
            unset($this->IdInDataFile);
        } else {
            $this->IdInDataFile = $idInDataFile;
        }
        return $this;
    }
    /**
     * Get OriginalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getOriginalName()
    {
        return isset($this->OriginalName) ? $this->OriginalName : null;
    }
    /**
     * Set OriginalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $originalName
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_SeatTypeMapping
     */
    public function setOriginalName(\patest\StructType\GlobalString $originalName = null)
    {
        if (is_null($originalName) || (is_array($originalName) && empty($originalName))) {
            unset($this->OriginalName);
        } else {
            $this->OriginalName = $originalName;
        }
        return $this;
    }
    /**
     * Get TargetSeatTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetSeatTypeId()
    {
        return isset($this->TargetSeatTypeId) ? $this->TargetSeatTypeId : null;
    }
    /**
     * Set TargetSeatTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetSeatTypeId
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_SeatTypeMapping
     */
    public function setTargetSeatTypeId($targetSeatTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($targetSeatTypeId) && !is_string($targetSeatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetSeatTypeId, true), gettype($targetSeatTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetSeatTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetSeatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetSeatTypeId, true)), __LINE__);
        }
        if (is_null($targetSeatTypeId) || (is_array($targetSeatTypeId) && empty($targetSeatTypeId))) {
            unset($this->TargetSeatTypeId);
        } else {
            $this->TargetSeatTypeId = $targetSeatTypeId;
        }
        return $this;
    }
}
