<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.ExportHallVersion.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_ExportHallVersion_Request extends AnyEntity
{
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The IsExportBackgroundImages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExportBackgroundImages;
    /**
     * The IsExportCustomProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExportCustomProperties;
    /**
     * The IsExportPriceLevels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExportPriceLevels;
    /**
     * The IsExportSeatTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExportSeatTypes;
    /**
     * The IsExportViewFromSeatImages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExportViewFromSeatImages;
    /**
     * Constructor method for BizAction.Ticketing.ExportHallVersion.Request
     * @uses BizAction_Ticketing_ExportHallVersion_Request::setAreaIds()
     * @uses BizAction_Ticketing_ExportHallVersion_Request::setHallVersionId()
     * @uses BizAction_Ticketing_ExportHallVersion_Request::setIsExportBackgroundImages()
     * @uses BizAction_Ticketing_ExportHallVersion_Request::setIsExportCustomProperties()
     * @uses BizAction_Ticketing_ExportHallVersion_Request::setIsExportPriceLevels()
     * @uses BizAction_Ticketing_ExportHallVersion_Request::setIsExportSeatTypes()
     * @uses BizAction_Ticketing_ExportHallVersion_Request::setIsExportViewFromSeatImages()
     * @param \patest\StructType\AreaIds $areaIds
     * @param string $hallVersionId
     * @param bool $isExportBackgroundImages
     * @param bool $isExportCustomProperties
     * @param bool $isExportPriceLevels
     * @param bool $isExportSeatTypes
     * @param bool $isExportViewFromSeatImages
     */
    public function __construct(\patest\StructType\AreaIds $areaIds = null, $hallVersionId = null, $isExportBackgroundImages = null, $isExportCustomProperties = null, $isExportPriceLevels = null, $isExportSeatTypes = null, $isExportViewFromSeatImages = null)
    {
        $this
            ->setAreaIds($areaIds)
            ->setHallVersionId($hallVersionId)
            ->setIsExportBackgroundImages($isExportBackgroundImages)
            ->setIsExportCustomProperties($isExportCustomProperties)
            ->setIsExportPriceLevels($isExportPriceLevels)
            ->setIsExportSeatTypes($isExportSeatTypes)
            ->setIsExportViewFromSeatImages($isExportViewFromSeatImages);
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\BizAction_Ticketing_ExportHallVersion_Request
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\BizAction_Ticketing_ExportHallVersion_Request
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get IsExportBackgroundImages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExportBackgroundImages()
    {
        return isset($this->IsExportBackgroundImages) ? $this->IsExportBackgroundImages : null;
    }
    /**
     * Set IsExportBackgroundImages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExportBackgroundImages
     * @return \patest\StructType\BizAction_Ticketing_ExportHallVersion_Request
     */
    public function setIsExportBackgroundImages($isExportBackgroundImages = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExportBackgroundImages) && !is_bool($isExportBackgroundImages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExportBackgroundImages, true), gettype($isExportBackgroundImages)), __LINE__);
        }
        if (is_null($isExportBackgroundImages) || (is_array($isExportBackgroundImages) && empty($isExportBackgroundImages))) {
            unset($this->IsExportBackgroundImages);
        } else {
            $this->IsExportBackgroundImages = $isExportBackgroundImages;
        }
        return $this;
    }
    /**
     * Get IsExportCustomProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExportCustomProperties()
    {
        return isset($this->IsExportCustomProperties) ? $this->IsExportCustomProperties : null;
    }
    /**
     * Set IsExportCustomProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExportCustomProperties
     * @return \patest\StructType\BizAction_Ticketing_ExportHallVersion_Request
     */
    public function setIsExportCustomProperties($isExportCustomProperties = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExportCustomProperties) && !is_bool($isExportCustomProperties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExportCustomProperties, true), gettype($isExportCustomProperties)), __LINE__);
        }
        if (is_null($isExportCustomProperties) || (is_array($isExportCustomProperties) && empty($isExportCustomProperties))) {
            unset($this->IsExportCustomProperties);
        } else {
            $this->IsExportCustomProperties = $isExportCustomProperties;
        }
        return $this;
    }
    /**
     * Get IsExportPriceLevels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExportPriceLevels()
    {
        return isset($this->IsExportPriceLevels) ? $this->IsExportPriceLevels : null;
    }
    /**
     * Set IsExportPriceLevels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExportPriceLevels
     * @return \patest\StructType\BizAction_Ticketing_ExportHallVersion_Request
     */
    public function setIsExportPriceLevels($isExportPriceLevels = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExportPriceLevels) && !is_bool($isExportPriceLevels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExportPriceLevels, true), gettype($isExportPriceLevels)), __LINE__);
        }
        if (is_null($isExportPriceLevels) || (is_array($isExportPriceLevels) && empty($isExportPriceLevels))) {
            unset($this->IsExportPriceLevels);
        } else {
            $this->IsExportPriceLevels = $isExportPriceLevels;
        }
        return $this;
    }
    /**
     * Get IsExportSeatTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExportSeatTypes()
    {
        return isset($this->IsExportSeatTypes) ? $this->IsExportSeatTypes : null;
    }
    /**
     * Set IsExportSeatTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExportSeatTypes
     * @return \patest\StructType\BizAction_Ticketing_ExportHallVersion_Request
     */
    public function setIsExportSeatTypes($isExportSeatTypes = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExportSeatTypes) && !is_bool($isExportSeatTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExportSeatTypes, true), gettype($isExportSeatTypes)), __LINE__);
        }
        if (is_null($isExportSeatTypes) || (is_array($isExportSeatTypes) && empty($isExportSeatTypes))) {
            unset($this->IsExportSeatTypes);
        } else {
            $this->IsExportSeatTypes = $isExportSeatTypes;
        }
        return $this;
    }
    /**
     * Get IsExportViewFromSeatImages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExportViewFromSeatImages()
    {
        return isset($this->IsExportViewFromSeatImages) ? $this->IsExportViewFromSeatImages : null;
    }
    /**
     * Set IsExportViewFromSeatImages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExportViewFromSeatImages
     * @return \patest\StructType\BizAction_Ticketing_ExportHallVersion_Request
     */
    public function setIsExportViewFromSeatImages($isExportViewFromSeatImages = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExportViewFromSeatImages) && !is_bool($isExportViewFromSeatImages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExportViewFromSeatImages, true), gettype($isExportViewFromSeatImages)), __LINE__);
        }
        if (is_null($isExportViewFromSeatImages) || (is_array($isExportViewFromSeatImages) && empty($isExportViewFromSeatImages))) {
            unset($this->IsExportViewFromSeatImages);
        } else {
            $this->IsExportViewFromSeatImages = $isExportViewFromSeatImages;
        }
        return $this;
    }
}
