<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.EsroClientBallotApplication.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_EsroClientBallotApplication_Request extends AnyEntity
{
    /**
     * The AllowedOwnerDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_Customer
     */
    public $AllowedOwnerDetails;
    /**
     * The AllowedOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotApplicationRelatedClient
     */
    public $AllowedOwners;
    /**
     * The AvailablePaymentMethods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_PaymentMethod
     */
    public $AvailablePaymentMethods;
    /**
     * The Ballot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Ballot
     */
    public $Ballot;
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The ClientApplication
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_BallotClientApplication
     */
    public $ClientApplication;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientTokens
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_ClientCreditCardPaymentTokenExtended
     */
    public $ClientTokens;
    /**
     * The EventsData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Event
     */
    public $EventsData;
    /**
     * The PaymentMethodDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodDetails;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PriceTypesData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_PriceType
     */
    public $PriceTypesData;
    /**
     * Constructor method for BizAction.Ticketing.EsroClientBallotApplication.Request
     * @uses BizAction_Ticketing_EsroClientBallotApplication_Request::setAllowedOwnerDetails()
     * @uses BizAction_Ticketing_EsroClientBallotApplication_Request::setAllowedOwners()
     * @uses BizAction_Ticketing_EsroClientBallotApplication_Request::setAvailablePaymentMethods()
     * @uses BizAction_Ticketing_EsroClientBallotApplication_Request::setBallot()
     * @uses BizAction_Ticketing_EsroClientBallotApplication_Request::setBallotId()
     * @uses BizAction_Ticketing_EsroClientBallotApplication_Request::setClientApplication()
     * @uses BizAction_Ticketing_EsroClientBallotApplication_Request::setClientId()
     * @uses BizAction_Ticketing_EsroClientBallotApplication_Request::setClientTokens()
     * @uses BizAction_Ticketing_EsroClientBallotApplication_Request::setEventsData()
     * @uses BizAction_Ticketing_EsroClientBallotApplication_Request::setPaymentMethodDetails()
     * @uses BizAction_Ticketing_EsroClientBallotApplication_Request::setPaymentMethodId()
     * @uses BizAction_Ticketing_EsroClientBallotApplication_Request::setPriceTypesData()
     * @param \patest\StructType\RecordSetOfCrm_Customer $allowedOwnerDetails
     * @param \patest\StructType\RecordSetOfTicketing_BallotApplicationRelatedClient $allowedOwners
     * @param \patest\StructType\RecordSetOfPayment_PaymentMethod $availablePaymentMethods
     * @param \patest\StructType\Ticketing_Ballot $ballot
     * @param string $ballotId
     * @param \patest\StructType\Ticketing_BallotClientApplication $clientApplication
     * @param string $clientId
     * @param \patest\StructType\RecordSetOfPayment_ClientCreditCardPaymentTokenExtended $clientTokens
     * @param \patest\StructType\RecordSetOfTicketing_Event $eventsData
     * @param string $paymentMethodDetails
     * @param string $paymentMethodId
     * @param \patest\StructType\RecordSetOfSales_PriceType $priceTypesData
     */
    public function __construct(\patest\StructType\RecordSetOfCrm_Customer $allowedOwnerDetails = null, \patest\StructType\RecordSetOfTicketing_BallotApplicationRelatedClient $allowedOwners = null, \patest\StructType\RecordSetOfPayment_PaymentMethod $availablePaymentMethods = null, \patest\StructType\Ticketing_Ballot $ballot = null, $ballotId = null, \patest\StructType\Ticketing_BallotClientApplication $clientApplication = null, $clientId = null, \patest\StructType\RecordSetOfPayment_ClientCreditCardPaymentTokenExtended $clientTokens = null, \patest\StructType\RecordSetOfTicketing_Event $eventsData = null, $paymentMethodDetails = null, $paymentMethodId = null, \patest\StructType\RecordSetOfSales_PriceType $priceTypesData = null)
    {
        $this
            ->setAllowedOwnerDetails($allowedOwnerDetails)
            ->setAllowedOwners($allowedOwners)
            ->setAvailablePaymentMethods($availablePaymentMethods)
            ->setBallot($ballot)
            ->setBallotId($ballotId)
            ->setClientApplication($clientApplication)
            ->setClientId($clientId)
            ->setClientTokens($clientTokens)
            ->setEventsData($eventsData)
            ->setPaymentMethodDetails($paymentMethodDetails)
            ->setPaymentMethodId($paymentMethodId)
            ->setPriceTypesData($priceTypesData);
    }
    /**
     * Get AllowedOwnerDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_Customer|null
     */
    public function getAllowedOwnerDetails()
    {
        return isset($this->AllowedOwnerDetails) ? $this->AllowedOwnerDetails : null;
    }
    /**
     * Set AllowedOwnerDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_Customer $allowedOwnerDetails
     * @return \patest\StructType\BizAction_Ticketing_EsroClientBallotApplication_Request
     */
    public function setAllowedOwnerDetails(\patest\StructType\RecordSetOfCrm_Customer $allowedOwnerDetails = null)
    {
        if (is_null($allowedOwnerDetails) || (is_array($allowedOwnerDetails) && empty($allowedOwnerDetails))) {
            unset($this->AllowedOwnerDetails);
        } else {
            $this->AllowedOwnerDetails = $allowedOwnerDetails;
        }
        return $this;
    }
    /**
     * Get AllowedOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotApplicationRelatedClient|null
     */
    public function getAllowedOwners()
    {
        return isset($this->AllowedOwners) ? $this->AllowedOwners : null;
    }
    /**
     * Set AllowedOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotApplicationRelatedClient $allowedOwners
     * @return \patest\StructType\BizAction_Ticketing_EsroClientBallotApplication_Request
     */
    public function setAllowedOwners(\patest\StructType\RecordSetOfTicketing_BallotApplicationRelatedClient $allowedOwners = null)
    {
        if (is_null($allowedOwners) || (is_array($allowedOwners) && empty($allowedOwners))) {
            unset($this->AllowedOwners);
        } else {
            $this->AllowedOwners = $allowedOwners;
        }
        return $this;
    }
    /**
     * Get AvailablePaymentMethods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_PaymentMethod|null
     */
    public function getAvailablePaymentMethods()
    {
        return isset($this->AvailablePaymentMethods) ? $this->AvailablePaymentMethods : null;
    }
    /**
     * Set AvailablePaymentMethods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_PaymentMethod $availablePaymentMethods
     * @return \patest\StructType\BizAction_Ticketing_EsroClientBallotApplication_Request
     */
    public function setAvailablePaymentMethods(\patest\StructType\RecordSetOfPayment_PaymentMethod $availablePaymentMethods = null)
    {
        if (is_null($availablePaymentMethods) || (is_array($availablePaymentMethods) && empty($availablePaymentMethods))) {
            unset($this->AvailablePaymentMethods);
        } else {
            $this->AvailablePaymentMethods = $availablePaymentMethods;
        }
        return $this;
    }
    /**
     * Get Ballot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Ballot|null
     */
    public function getBallot()
    {
        return isset($this->Ballot) ? $this->Ballot : null;
    }
    /**
     * Set Ballot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Ballot $ballot
     * @return \patest\StructType\BizAction_Ticketing_EsroClientBallotApplication_Request
     */
    public function setBallot(\patest\StructType\Ticketing_Ballot $ballot = null)
    {
        if (is_null($ballot) || (is_array($ballot) && empty($ballot))) {
            unset($this->Ballot);
        } else {
            $this->Ballot = $ballot;
        }
        return $this;
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\BizAction_Ticketing_EsroClientBallotApplication_Request
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get ClientApplication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_BallotClientApplication|null
     */
    public function getClientApplication()
    {
        return isset($this->ClientApplication) ? $this->ClientApplication : null;
    }
    /**
     * Set ClientApplication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_BallotClientApplication $clientApplication
     * @return \patest\StructType\BizAction_Ticketing_EsroClientBallotApplication_Request
     */
    public function setClientApplication(\patest\StructType\Ticketing_BallotClientApplication $clientApplication = null)
    {
        if (is_null($clientApplication) || (is_array($clientApplication) && empty($clientApplication))) {
            unset($this->ClientApplication);
        } else {
            $this->ClientApplication = $clientApplication;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Ticketing_EsroClientBallotApplication_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientTokens value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_ClientCreditCardPaymentTokenExtended|null
     */
    public function getClientTokens()
    {
        return isset($this->ClientTokens) ? $this->ClientTokens : null;
    }
    /**
     * Set ClientTokens value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_ClientCreditCardPaymentTokenExtended $clientTokens
     * @return \patest\StructType\BizAction_Ticketing_EsroClientBallotApplication_Request
     */
    public function setClientTokens(\patest\StructType\RecordSetOfPayment_ClientCreditCardPaymentTokenExtended $clientTokens = null)
    {
        if (is_null($clientTokens) || (is_array($clientTokens) && empty($clientTokens))) {
            unset($this->ClientTokens);
        } else {
            $this->ClientTokens = $clientTokens;
        }
        return $this;
    }
    /**
     * Get EventsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Event|null
     */
    public function getEventsData()
    {
        return isset($this->EventsData) ? $this->EventsData : null;
    }
    /**
     * Set EventsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Event $eventsData
     * @return \patest\StructType\BizAction_Ticketing_EsroClientBallotApplication_Request
     */
    public function setEventsData(\patest\StructType\RecordSetOfTicketing_Event $eventsData = null)
    {
        if (is_null($eventsData) || (is_array($eventsData) && empty($eventsData))) {
            unset($this->EventsData);
        } else {
            $this->EventsData = $eventsData;
        }
        return $this;
    }
    /**
     * Get PaymentMethodDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodDetails()
    {
        return isset($this->PaymentMethodDetails) ? $this->PaymentMethodDetails : null;
    }
    /**
     * Set PaymentMethodDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodDetails
     * @return \patest\StructType\BizAction_Ticketing_EsroClientBallotApplication_Request
     */
    public function setPaymentMethodDetails($paymentMethodDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodDetails) && !is_string($paymentMethodDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodDetails, true), gettype($paymentMethodDetails)), __LINE__);
        }
        if (is_null($paymentMethodDetails) || (is_array($paymentMethodDetails) && empty($paymentMethodDetails))) {
            unset($this->PaymentMethodDetails);
        } else {
            $this->PaymentMethodDetails = $paymentMethodDetails;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Ticketing_EsroClientBallotApplication_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PriceTypesData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_PriceType|null
     */
    public function getPriceTypesData()
    {
        return isset($this->PriceTypesData) ? $this->PriceTypesData : null;
    }
    /**
     * Set PriceTypesData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_PriceType $priceTypesData
     * @return \patest\StructType\BizAction_Ticketing_EsroClientBallotApplication_Request
     */
    public function setPriceTypesData(\patest\StructType\RecordSetOfSales_PriceType $priceTypesData = null)
    {
        if (is_null($priceTypesData) || (is_array($priceTypesData) && empty($priceTypesData))) {
            unset($this->PriceTypesData);
        } else {
            $this->PriceTypesData = $priceTypesData;
        }
        return $this;
    }
}
