<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.CopyEventProperties.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_CopyEventProperties_Request extends AnyEntity
{
    /**
     * The ComplimentaryEventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComplimentaryEventIds;
    /**
     * The CopyOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CopyOptions;
    /**
     * The DatesToExclude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_DatesToExclude
     */
    public $DatesToExclude;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The EventsCriteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_CopyEventProperties_Criteria
     */
    public $EventsCriteria;
    /**
     * The IsMergeSourceAndTargetValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMergeSourceAndTargetValues;
    /**
     * The SourceEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourceEventId;
    /**
     * The SummaryText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SummaryText;
    /**
     * Constructor method for BizAction.Ticketing.CopyEventProperties.Request
     * @uses BizAction_Ticketing_CopyEventProperties_Request::setComplimentaryEventIds()
     * @uses BizAction_Ticketing_CopyEventProperties_Request::setCopyOptions()
     * @uses BizAction_Ticketing_CopyEventProperties_Request::setDatesToExclude()
     * @uses BizAction_Ticketing_CopyEventProperties_Request::setEventIds()
     * @uses BizAction_Ticketing_CopyEventProperties_Request::setEventsCriteria()
     * @uses BizAction_Ticketing_CopyEventProperties_Request::setIsMergeSourceAndTargetValues()
     * @uses BizAction_Ticketing_CopyEventProperties_Request::setSourceEventId()
     * @uses BizAction_Ticketing_CopyEventProperties_Request::setSummaryText()
     * @param string $complimentaryEventIds
     * @param string $copyOptions
     * @param \patest\StructType\RecordSetOfTicketing_DatesToExclude $datesToExclude
     * @param \patest\StructType\EventIds $eventIds
     * @param \patest\StructType\Ticketing_CopyEventProperties_Criteria $eventsCriteria
     * @param bool $isMergeSourceAndTargetValues
     * @param string $sourceEventId
     * @param string $summaryText
     */
    public function __construct($complimentaryEventIds = null, $copyOptions = null, \patest\StructType\RecordSetOfTicketing_DatesToExclude $datesToExclude = null, \patest\StructType\EventIds $eventIds = null, \patest\StructType\Ticketing_CopyEventProperties_Criteria $eventsCriteria = null, $isMergeSourceAndTargetValues = null, $sourceEventId = null, $summaryText = null)
    {
        $this
            ->setComplimentaryEventIds($complimentaryEventIds)
            ->setCopyOptions($copyOptions)
            ->setDatesToExclude($datesToExclude)
            ->setEventIds($eventIds)
            ->setEventsCriteria($eventsCriteria)
            ->setIsMergeSourceAndTargetValues($isMergeSourceAndTargetValues)
            ->setSourceEventId($sourceEventId)
            ->setSummaryText($summaryText);
    }
    /**
     * Get ComplimentaryEventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComplimentaryEventIds()
    {
        return isset($this->ComplimentaryEventIds) ? $this->ComplimentaryEventIds : null;
    }
    /**
     * Set ComplimentaryEventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $complimentaryEventIds
     * @return \patest\StructType\BizAction_Ticketing_CopyEventProperties_Request
     */
    public function setComplimentaryEventIds($complimentaryEventIds = null)
    {
        // validation for constraint: string
        if (!is_null($complimentaryEventIds) && !is_string($complimentaryEventIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($complimentaryEventIds, true), gettype($complimentaryEventIds)), __LINE__);
        }
        if (is_null($complimentaryEventIds) || (is_array($complimentaryEventIds) && empty($complimentaryEventIds))) {
            unset($this->ComplimentaryEventIds);
        } else {
            $this->ComplimentaryEventIds = $complimentaryEventIds;
        }
        return $this;
    }
    /**
     * Get CopyOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCopyOptions()
    {
        return isset($this->CopyOptions) ? $this->CopyOptions : null;
    }
    /**
     * Set CopyOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $copyOptions
     * @return \patest\StructType\BizAction_Ticketing_CopyEventProperties_Request
     */
    public function setCopyOptions($copyOptions = null)
    {
        // validation for constraint: string
        if (!is_null($copyOptions) && !is_string($copyOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyOptions, true), gettype($copyOptions)), __LINE__);
        }
        if (is_null($copyOptions) || (is_array($copyOptions) && empty($copyOptions))) {
            unset($this->CopyOptions);
        } else {
            $this->CopyOptions = $copyOptions;
        }
        return $this;
    }
    /**
     * Get DatesToExclude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_DatesToExclude|null
     */
    public function getDatesToExclude()
    {
        return isset($this->DatesToExclude) ? $this->DatesToExclude : null;
    }
    /**
     * Set DatesToExclude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_DatesToExclude $datesToExclude
     * @return \patest\StructType\BizAction_Ticketing_CopyEventProperties_Request
     */
    public function setDatesToExclude(\patest\StructType\RecordSetOfTicketing_DatesToExclude $datesToExclude = null)
    {
        if (is_null($datesToExclude) || (is_array($datesToExclude) && empty($datesToExclude))) {
            unset($this->DatesToExclude);
        } else {
            $this->DatesToExclude = $datesToExclude;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\BizAction_Ticketing_CopyEventProperties_Request
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get EventsCriteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_CopyEventProperties_Criteria|null
     */
    public function getEventsCriteria()
    {
        return isset($this->EventsCriteria) ? $this->EventsCriteria : null;
    }
    /**
     * Set EventsCriteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_CopyEventProperties_Criteria $eventsCriteria
     * @return \patest\StructType\BizAction_Ticketing_CopyEventProperties_Request
     */
    public function setEventsCriteria(\patest\StructType\Ticketing_CopyEventProperties_Criteria $eventsCriteria = null)
    {
        if (is_null($eventsCriteria) || (is_array($eventsCriteria) && empty($eventsCriteria))) {
            unset($this->EventsCriteria);
        } else {
            $this->EventsCriteria = $eventsCriteria;
        }
        return $this;
    }
    /**
     * Get IsMergeSourceAndTargetValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMergeSourceAndTargetValues()
    {
        return isset($this->IsMergeSourceAndTargetValues) ? $this->IsMergeSourceAndTargetValues : null;
    }
    /**
     * Set IsMergeSourceAndTargetValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMergeSourceAndTargetValues
     * @return \patest\StructType\BizAction_Ticketing_CopyEventProperties_Request
     */
    public function setIsMergeSourceAndTargetValues($isMergeSourceAndTargetValues = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMergeSourceAndTargetValues) && !is_bool($isMergeSourceAndTargetValues)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMergeSourceAndTargetValues, true), gettype($isMergeSourceAndTargetValues)), __LINE__);
        }
        if (is_null($isMergeSourceAndTargetValues) || (is_array($isMergeSourceAndTargetValues) && empty($isMergeSourceAndTargetValues))) {
            unset($this->IsMergeSourceAndTargetValues);
        } else {
            $this->IsMergeSourceAndTargetValues = $isMergeSourceAndTargetValues;
        }
        return $this;
    }
    /**
     * Get SourceEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceEventId()
    {
        return isset($this->SourceEventId) ? $this->SourceEventId : null;
    }
    /**
     * Set SourceEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceEventId
     * @return \patest\StructType\BizAction_Ticketing_CopyEventProperties_Request
     */
    public function setSourceEventId($sourceEventId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceEventId) && !is_string($sourceEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceEventId, true), gettype($sourceEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourceEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourceEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourceEventId, true)), __LINE__);
        }
        if (is_null($sourceEventId) || (is_array($sourceEventId) && empty($sourceEventId))) {
            unset($this->SourceEventId);
        } else {
            $this->SourceEventId = $sourceEventId;
        }
        return $this;
    }
    /**
     * Get SummaryText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSummaryText()
    {
        return isset($this->SummaryText) ? $this->SummaryText : null;
    }
    /**
     * Set SummaryText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $summaryText
     * @return \patest\StructType\BizAction_Ticketing_CopyEventProperties_Request
     */
    public function setSummaryText($summaryText = null)
    {
        // validation for constraint: string
        if (!is_null($summaryText) && !is_string($summaryText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($summaryText, true), gettype($summaryText)), __LINE__);
        }
        if (is_null($summaryText) || (is_array($summaryText) && empty($summaryText))) {
            unset($this->SummaryText);
        } else {
            $this->SummaryText = $summaryText;
        }
        return $this;
    }
}
