<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.BulkReturnOperation.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_BulkReturnOperation_Request extends BizAction_Foundation_BulkOperation_Request
{
    /**
     * The DepositCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositCategoryId;
    /**
     * The LockTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockTypeId;
    /**
     * The PaymentMethodSubType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodSubType;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The ReimbursementPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReimbursementPaymentMethodId;
    /**
     * The UseReimbursementRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseReimbursementRules;
    /**
     * Constructor method for BizAction.Ticketing.BulkReturnOperation.Request
     * @uses BizAction_Ticketing_BulkReturnOperation_Request::setDepositCategoryId()
     * @uses BizAction_Ticketing_BulkReturnOperation_Request::setLockTypeId()
     * @uses BizAction_Ticketing_BulkReturnOperation_Request::setPaymentMethodSubType()
     * @uses BizAction_Ticketing_BulkReturnOperation_Request::setPaymentMethodType()
     * @uses BizAction_Ticketing_BulkReturnOperation_Request::setReimbursementPaymentMethodId()
     * @uses BizAction_Ticketing_BulkReturnOperation_Request::setUseReimbursementRules()
     * @param string $depositCategoryId
     * @param string $lockTypeId
     * @param string $paymentMethodSubType
     * @param string $paymentMethodType
     * @param string $reimbursementPaymentMethodId
     * @param bool $useReimbursementRules
     */
    public function __construct($depositCategoryId = null, $lockTypeId = null, $paymentMethodSubType = null, $paymentMethodType = null, $reimbursementPaymentMethodId = null, $useReimbursementRules = null)
    {
        $this
            ->setDepositCategoryId($depositCategoryId)
            ->setLockTypeId($lockTypeId)
            ->setPaymentMethodSubType($paymentMethodSubType)
            ->setPaymentMethodType($paymentMethodType)
            ->setReimbursementPaymentMethodId($reimbursementPaymentMethodId)
            ->setUseReimbursementRules($useReimbursementRules);
    }
    /**
     * Get DepositCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositCategoryId()
    {
        return isset($this->DepositCategoryId) ? $this->DepositCategoryId : null;
    }
    /**
     * Set DepositCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositCategoryId
     * @return \patest\StructType\BizAction_Ticketing_BulkReturnOperation_Request
     */
    public function setDepositCategoryId($depositCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($depositCategoryId) && !is_string($depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositCategoryId, true), gettype($depositCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositCategoryId, true)), __LINE__);
        }
        if (is_null($depositCategoryId) || (is_array($depositCategoryId) && empty($depositCategoryId))) {
            unset($this->DepositCategoryId);
        } else {
            $this->DepositCategoryId = $depositCategoryId;
        }
        return $this;
    }
    /**
     * Get LockTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockTypeId()
    {
        return isset($this->LockTypeId) ? $this->LockTypeId : null;
    }
    /**
     * Set LockTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockTypeId
     * @return \patest\StructType\BizAction_Ticketing_BulkReturnOperation_Request
     */
    public function setLockTypeId($lockTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($lockTypeId) && !is_string($lockTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockTypeId, true), gettype($lockTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockTypeId, true)), __LINE__);
        }
        if (is_null($lockTypeId) || (is_array($lockTypeId) && empty($lockTypeId))) {
            unset($this->LockTypeId);
        } else {
            $this->LockTypeId = $lockTypeId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodSubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodSubType()
    {
        return isset($this->PaymentMethodSubType) ? $this->PaymentMethodSubType : null;
    }
    /**
     * Set PaymentMethodSubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodSubType
     * @return \patest\StructType\BizAction_Ticketing_BulkReturnOperation_Request
     */
    public function setPaymentMethodSubType($paymentMethodSubType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodSubType) && !is_string($paymentMethodSubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodSubType, true), gettype($paymentMethodSubType)), __LINE__);
        }
        if (is_null($paymentMethodSubType) || (is_array($paymentMethodSubType) && empty($paymentMethodSubType))) {
            unset($this->PaymentMethodSubType);
        } else {
            $this->PaymentMethodSubType = $paymentMethodSubType;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\BizAction_Ticketing_BulkReturnOperation_Request
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get ReimbursementPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReimbursementPaymentMethodId()
    {
        return isset($this->ReimbursementPaymentMethodId) ? $this->ReimbursementPaymentMethodId : null;
    }
    /**
     * Set ReimbursementPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reimbursementPaymentMethodId
     * @return \patest\StructType\BizAction_Ticketing_BulkReturnOperation_Request
     */
    public function setReimbursementPaymentMethodId($reimbursementPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($reimbursementPaymentMethodId) && !is_string($reimbursementPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reimbursementPaymentMethodId, true), gettype($reimbursementPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reimbursementPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reimbursementPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reimbursementPaymentMethodId, true)), __LINE__);
        }
        if (is_null($reimbursementPaymentMethodId) || (is_array($reimbursementPaymentMethodId) && empty($reimbursementPaymentMethodId))) {
            unset($this->ReimbursementPaymentMethodId);
        } else {
            $this->ReimbursementPaymentMethodId = $reimbursementPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get UseReimbursementRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseReimbursementRules()
    {
        return isset($this->UseReimbursementRules) ? $this->UseReimbursementRules : null;
    }
    /**
     * Set UseReimbursementRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useReimbursementRules
     * @return \patest\StructType\BizAction_Ticketing_BulkReturnOperation_Request
     */
    public function setUseReimbursementRules($useReimbursementRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($useReimbursementRules) && !is_bool($useReimbursementRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useReimbursementRules, true), gettype($useReimbursementRules)), __LINE__);
        }
        if (is_null($useReimbursementRules) || (is_array($useReimbursementRules) && empty($useReimbursementRules))) {
            unset($this->UseReimbursementRules);
        } else {
            $this->UseReimbursementRules = $useReimbursementRules;
        }
        return $this;
    }
}
