<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.BulkMoveAudienceOperation.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_BulkMoveAudienceOperation_Request extends BizAction_Foundation_BulkOperation_Request
{
    /**
     * The AllocationTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AllocationTypes
     */
    public $AllocationTypes;
    /**
     * The ContiguousSeatsOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ContiguousSeatsOption;
    /**
     * The LockType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockType;
    /**
     * The MovedSeatsOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MovedSeatsOption;
    /**
     * The SameEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SameEvent;
    /**
     * The TargetEvent
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetEvent;
    /**
     * The VacatedSeatsOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VacatedSeatsOption;
    /**
     * Constructor method for BizAction.Ticketing.BulkMoveAudienceOperation.Request
     * @uses BizAction_Ticketing_BulkMoveAudienceOperation_Request::setAllocationTypes()
     * @uses BizAction_Ticketing_BulkMoveAudienceOperation_Request::setContiguousSeatsOption()
     * @uses BizAction_Ticketing_BulkMoveAudienceOperation_Request::setLockType()
     * @uses BizAction_Ticketing_BulkMoveAudienceOperation_Request::setMovedSeatsOption()
     * @uses BizAction_Ticketing_BulkMoveAudienceOperation_Request::setSameEvent()
     * @uses BizAction_Ticketing_BulkMoveAudienceOperation_Request::setTargetEvent()
     * @uses BizAction_Ticketing_BulkMoveAudienceOperation_Request::setVacatedSeatsOption()
     * @param \patest\StructType\AllocationTypes $allocationTypes
     * @param bool $contiguousSeatsOption
     * @param string $lockType
     * @param string $movedSeatsOption
     * @param bool $sameEvent
     * @param string $targetEvent
     * @param string $vacatedSeatsOption
     */
    public function __construct(\patest\StructType\AllocationTypes $allocationTypes = null, $contiguousSeatsOption = null, $lockType = null, $movedSeatsOption = null, $sameEvent = null, $targetEvent = null, $vacatedSeatsOption = null)
    {
        $this
            ->setAllocationTypes($allocationTypes)
            ->setContiguousSeatsOption($contiguousSeatsOption)
            ->setLockType($lockType)
            ->setMovedSeatsOption($movedSeatsOption)
            ->setSameEvent($sameEvent)
            ->setTargetEvent($targetEvent)
            ->setVacatedSeatsOption($vacatedSeatsOption);
    }
    /**
     * Get AllocationTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AllocationTypes|null
     */
    public function getAllocationTypes()
    {
        return isset($this->AllocationTypes) ? $this->AllocationTypes : null;
    }
    /**
     * Set AllocationTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AllocationTypes $allocationTypes
     * @return \patest\StructType\BizAction_Ticketing_BulkMoveAudienceOperation_Request
     */
    public function setAllocationTypes(\patest\StructType\AllocationTypes $allocationTypes = null)
    {
        if (is_null($allocationTypes) || (is_array($allocationTypes) && empty($allocationTypes))) {
            unset($this->AllocationTypes);
        } else {
            $this->AllocationTypes = $allocationTypes;
        }
        return $this;
    }
    /**
     * Get ContiguousSeatsOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getContiguousSeatsOption()
    {
        return isset($this->ContiguousSeatsOption) ? $this->ContiguousSeatsOption : null;
    }
    /**
     * Set ContiguousSeatsOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $contiguousSeatsOption
     * @return \patest\StructType\BizAction_Ticketing_BulkMoveAudienceOperation_Request
     */
    public function setContiguousSeatsOption($contiguousSeatsOption = null)
    {
        // validation for constraint: boolean
        if (!is_null($contiguousSeatsOption) && !is_bool($contiguousSeatsOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contiguousSeatsOption, true), gettype($contiguousSeatsOption)), __LINE__);
        }
        if (is_null($contiguousSeatsOption) || (is_array($contiguousSeatsOption) && empty($contiguousSeatsOption))) {
            unset($this->ContiguousSeatsOption);
        } else {
            $this->ContiguousSeatsOption = $contiguousSeatsOption;
        }
        return $this;
    }
    /**
     * Get LockType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockType()
    {
        return isset($this->LockType) ? $this->LockType : null;
    }
    /**
     * Set LockType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockType
     * @return \patest\StructType\BizAction_Ticketing_BulkMoveAudienceOperation_Request
     */
    public function setLockType($lockType = null)
    {
        // validation for constraint: string
        if (!is_null($lockType) && !is_string($lockType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockType, true), gettype($lockType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockType, true)), __LINE__);
        }
        if (is_null($lockType) || (is_array($lockType) && empty($lockType))) {
            unset($this->LockType);
        } else {
            $this->LockType = $lockType;
        }
        return $this;
    }
    /**
     * Get MovedSeatsOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMovedSeatsOption()
    {
        return isset($this->MovedSeatsOption) ? $this->MovedSeatsOption : null;
    }
    /**
     * Set MovedSeatsOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MovedSeatsOptions::valueIsValid()
     * @uses \patest\EnumType\MovedSeatsOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $movedSeatsOption
     * @return \patest\StructType\BizAction_Ticketing_BulkMoveAudienceOperation_Request
     */
    public function setMovedSeatsOption($movedSeatsOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MovedSeatsOptions::valueIsValid($movedSeatsOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MovedSeatsOptions', is_array($movedSeatsOption) ? implode(', ', $movedSeatsOption) : var_export($movedSeatsOption, true), implode(', ', \patest\EnumType\MovedSeatsOptions::getValidValues())), __LINE__);
        }
        if (is_null($movedSeatsOption) || (is_array($movedSeatsOption) && empty($movedSeatsOption))) {
            unset($this->MovedSeatsOption);
        } else {
            $this->MovedSeatsOption = $movedSeatsOption;
        }
        return $this;
    }
    /**
     * Get SameEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSameEvent()
    {
        return isset($this->SameEvent) ? $this->SameEvent : null;
    }
    /**
     * Set SameEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sameEvent
     * @return \patest\StructType\BizAction_Ticketing_BulkMoveAudienceOperation_Request
     */
    public function setSameEvent($sameEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($sameEvent) && !is_bool($sameEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sameEvent, true), gettype($sameEvent)), __LINE__);
        }
        if (is_null($sameEvent) || (is_array($sameEvent) && empty($sameEvent))) {
            unset($this->SameEvent);
        } else {
            $this->SameEvent = $sameEvent;
        }
        return $this;
    }
    /**
     * Get TargetEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetEvent()
    {
        return isset($this->TargetEvent) ? $this->TargetEvent : null;
    }
    /**
     * Set TargetEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetEvent
     * @return \patest\StructType\BizAction_Ticketing_BulkMoveAudienceOperation_Request
     */
    public function setTargetEvent($targetEvent = null)
    {
        // validation for constraint: string
        if (!is_null($targetEvent) && !is_string($targetEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetEvent, true), gettype($targetEvent)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetEvent) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetEvent, true)), __LINE__);
        }
        if (is_null($targetEvent) || (is_array($targetEvent) && empty($targetEvent))) {
            unset($this->TargetEvent);
        } else {
            $this->TargetEvent = $targetEvent;
        }
        return $this;
    }
    /**
     * Get VacatedSeatsOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVacatedSeatsOption()
    {
        return isset($this->VacatedSeatsOption) ? $this->VacatedSeatsOption : null;
    }
    /**
     * Set VacatedSeatsOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RestrictionType::valueIsValid()
     * @uses \patest\EnumType\RestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vacatedSeatsOption
     * @return \patest\StructType\BizAction_Ticketing_BulkMoveAudienceOperation_Request
     */
    public function setVacatedSeatsOption($vacatedSeatsOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RestrictionType::valueIsValid($vacatedSeatsOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RestrictionType', is_array($vacatedSeatsOption) ? implode(', ', $vacatedSeatsOption) : var_export($vacatedSeatsOption, true), implode(', ', \patest\EnumType\RestrictionType::getValidValues())), __LINE__);
        }
        if (is_null($vacatedSeatsOption) || (is_array($vacatedSeatsOption) && empty($vacatedSeatsOption))) {
            unset($this->VacatedSeatsOption);
        } else {
            $this->VacatedSeatsOption = $vacatedSeatsOption;
        }
        return $this;
    }
}
