<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.BatchUpdateSeatInventory.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_BatchUpdateSeatInventory_Request extends AnyEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IsAddSeatsByIdsInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAddSeatsByIdsInAreaMap;
    /**
     * The LiabilityStatusId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LiabilityStatusId;
    /**
     * The SeatLumps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_SeatInventoryLump
     */
    public $SeatLumps;
    /**
     * The SeatsIdsInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatsIdsInAreaMap;
    /**
     * Constructor method for BizAction.Ticketing.BatchUpdateSeatInventory.Request
     * @uses BizAction_Ticketing_BatchUpdateSeatInventory_Request::setAreaId()
     * @uses BizAction_Ticketing_BatchUpdateSeatInventory_Request::setEventId()
     * @uses BizAction_Ticketing_BatchUpdateSeatInventory_Request::setIsAddSeatsByIdsInAreaMap()
     * @uses BizAction_Ticketing_BatchUpdateSeatInventory_Request::setLiabilityStatusId()
     * @uses BizAction_Ticketing_BatchUpdateSeatInventory_Request::setSeatLumps()
     * @uses BizAction_Ticketing_BatchUpdateSeatInventory_Request::setSeatsIdsInAreaMap()
     * @param string $areaId
     * @param string $eventId
     * @param bool $isAddSeatsByIdsInAreaMap
     * @param string $liabilityStatusId
     * @param \patest\StructType\RecordSetOfTicketing_SeatInventoryLump $seatLumps
     * @param string $seatsIdsInAreaMap
     */
    public function __construct($areaId = null, $eventId = null, $isAddSeatsByIdsInAreaMap = null, $liabilityStatusId = null, \patest\StructType\RecordSetOfTicketing_SeatInventoryLump $seatLumps = null, $seatsIdsInAreaMap = null)
    {
        $this
            ->setAreaId($areaId)
            ->setEventId($eventId)
            ->setIsAddSeatsByIdsInAreaMap($isAddSeatsByIdsInAreaMap)
            ->setLiabilityStatusId($liabilityStatusId)
            ->setSeatLumps($seatLumps)
            ->setSeatsIdsInAreaMap($seatsIdsInAreaMap);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\BizAction_Ticketing_BatchUpdateSeatInventory_Request
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_BatchUpdateSeatInventory_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get IsAddSeatsByIdsInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAddSeatsByIdsInAreaMap()
    {
        return isset($this->IsAddSeatsByIdsInAreaMap) ? $this->IsAddSeatsByIdsInAreaMap : null;
    }
    /**
     * Set IsAddSeatsByIdsInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAddSeatsByIdsInAreaMap
     * @return \patest\StructType\BizAction_Ticketing_BatchUpdateSeatInventory_Request
     */
    public function setIsAddSeatsByIdsInAreaMap($isAddSeatsByIdsInAreaMap = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAddSeatsByIdsInAreaMap) && !is_bool($isAddSeatsByIdsInAreaMap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAddSeatsByIdsInAreaMap, true), gettype($isAddSeatsByIdsInAreaMap)), __LINE__);
        }
        if (is_null($isAddSeatsByIdsInAreaMap) || (is_array($isAddSeatsByIdsInAreaMap) && empty($isAddSeatsByIdsInAreaMap))) {
            unset($this->IsAddSeatsByIdsInAreaMap);
        } else {
            $this->IsAddSeatsByIdsInAreaMap = $isAddSeatsByIdsInAreaMap;
        }
        return $this;
    }
    /**
     * Get LiabilityStatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLiabilityStatusId()
    {
        return isset($this->LiabilityStatusId) ? $this->LiabilityStatusId : null;
    }
    /**
     * Set LiabilityStatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $liabilityStatusId
     * @return \patest\StructType\BizAction_Ticketing_BatchUpdateSeatInventory_Request
     */
    public function setLiabilityStatusId($liabilityStatusId = null)
    {
        // validation for constraint: string
        if (!is_null($liabilityStatusId) && !is_string($liabilityStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($liabilityStatusId, true), gettype($liabilityStatusId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($liabilityStatusId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $liabilityStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($liabilityStatusId, true)), __LINE__);
        }
        if (is_null($liabilityStatusId) || (is_array($liabilityStatusId) && empty($liabilityStatusId))) {
            unset($this->LiabilityStatusId);
        } else {
            $this->LiabilityStatusId = $liabilityStatusId;
        }
        return $this;
    }
    /**
     * Get SeatLumps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_SeatInventoryLump|null
     */
    public function getSeatLumps()
    {
        return isset($this->SeatLumps) ? $this->SeatLumps : null;
    }
    /**
     * Set SeatLumps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_SeatInventoryLump $seatLumps
     * @return \patest\StructType\BizAction_Ticketing_BatchUpdateSeatInventory_Request
     */
    public function setSeatLumps(\patest\StructType\RecordSetOfTicketing_SeatInventoryLump $seatLumps = null)
    {
        if (is_null($seatLumps) || (is_array($seatLumps) && empty($seatLumps))) {
            unset($this->SeatLumps);
        } else {
            $this->SeatLumps = $seatLumps;
        }
        return $this;
    }
    /**
     * Get SeatsIdsInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatsIdsInAreaMap()
    {
        return isset($this->SeatsIdsInAreaMap) ? $this->SeatsIdsInAreaMap : null;
    }
    /**
     * Set SeatsIdsInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatsIdsInAreaMap
     * @return \patest\StructType\BizAction_Ticketing_BatchUpdateSeatInventory_Request
     */
    public function setSeatsIdsInAreaMap($seatsIdsInAreaMap = null)
    {
        // validation for constraint: string
        if (!is_null($seatsIdsInAreaMap) && !is_string($seatsIdsInAreaMap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatsIdsInAreaMap, true), gettype($seatsIdsInAreaMap)), __LINE__);
        }
        if (is_null($seatsIdsInAreaMap) || (is_array($seatsIdsInAreaMap) && empty($seatsIdsInAreaMap))) {
            unset($this->SeatsIdsInAreaMap);
        } else {
            $this->SeatsIdsInAreaMap = $seatsIdsInAreaMap;
        }
        return $this;
    }
}
