<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.BallotApplicant StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_BallotApplicant extends AnyEntity
{
    /**
     * The ApplicationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApplicationId;
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Area;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypeName;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The GroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupId;
    /**
     * The IsCandidate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCandidate;
    /**
     * The IsWinner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IsWinner;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Position;
    /**
     * The PreviousWonCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PreviousWonCount;
    /**
     * The RequestedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RequestedSeats;
    /**
     * The Row
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Row;
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seats;
    /**
     * The SeatsData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatsData;
    /**
     * The SectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectionId;
    /**
     * The SectionName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectionName;
    /**
     * The Sector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sector;
    /**
     * The WonSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WonSeats;
    /**
     * Constructor method for BizAction.Ticketing.BallotApplicant
     * @uses BizAction_Ticketing_BallotApplicant::setApplicationId()
     * @uses BizAction_Ticketing_BallotApplicant::setArea()
     * @uses BizAction_Ticketing_BallotApplicant::setClientId()
     * @uses BizAction_Ticketing_BallotApplicant::setClientTypeName()
     * @uses BizAction_Ticketing_BallotApplicant::setCrmId()
     * @uses BizAction_Ticketing_BallotApplicant::setFirstName()
     * @uses BizAction_Ticketing_BallotApplicant::setGroupId()
     * @uses BizAction_Ticketing_BallotApplicant::setIsCandidate()
     * @uses BizAction_Ticketing_BallotApplicant::setIsWinner()
     * @uses BizAction_Ticketing_BallotApplicant::setLastName()
     * @uses BizAction_Ticketing_BallotApplicant::setNote()
     * @uses BizAction_Ticketing_BallotApplicant::setPosition()
     * @uses BizAction_Ticketing_BallotApplicant::setPreviousWonCount()
     * @uses BizAction_Ticketing_BallotApplicant::setRequestedSeats()
     * @uses BizAction_Ticketing_BallotApplicant::setRow()
     * @uses BizAction_Ticketing_BallotApplicant::setSeats()
     * @uses BizAction_Ticketing_BallotApplicant::setSeatsData()
     * @uses BizAction_Ticketing_BallotApplicant::setSectionId()
     * @uses BizAction_Ticketing_BallotApplicant::setSectionName()
     * @uses BizAction_Ticketing_BallotApplicant::setSector()
     * @uses BizAction_Ticketing_BallotApplicant::setWonSeats()
     * @param string $applicationId
     * @param string $area
     * @param string $clientId
     * @param string $clientTypeName
     * @param string $crmId
     * @param string $firstName
     * @param string $groupId
     * @param bool $isCandidate
     * @param int $isWinner
     * @param string $lastName
     * @param string $note
     * @param int $position
     * @param int $previousWonCount
     * @param int $requestedSeats
     * @param string $row
     * @param string $seats
     * @param string $seatsData
     * @param string $sectionId
     * @param string $sectionName
     * @param string $sector
     * @param int $wonSeats
     */
    public function __construct($applicationId = null, $area = null, $clientId = null, $clientTypeName = null, $crmId = null, $firstName = null, $groupId = null, $isCandidate = null, $isWinner = null, $lastName = null, $note = null, $position = null, $previousWonCount = null, $requestedSeats = null, $row = null, $seats = null, $seatsData = null, $sectionId = null, $sectionName = null, $sector = null, $wonSeats = null)
    {
        $this
            ->setApplicationId($applicationId)
            ->setArea($area)
            ->setClientId($clientId)
            ->setClientTypeName($clientTypeName)
            ->setCrmId($crmId)
            ->setFirstName($firstName)
            ->setGroupId($groupId)
            ->setIsCandidate($isCandidate)
            ->setIsWinner($isWinner)
            ->setLastName($lastName)
            ->setNote($note)
            ->setPosition($position)
            ->setPreviousWonCount($previousWonCount)
            ->setRequestedSeats($requestedSeats)
            ->setRow($row)
            ->setSeats($seats)
            ->setSeatsData($seatsData)
            ->setSectionId($sectionId)
            ->setSectionName($sectionName)
            ->setSector($sector)
            ->setWonSeats($wonSeats);
    }
    /**
     * Get ApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationId()
    {
        return isset($this->ApplicationId) ? $this->ApplicationId : null;
    }
    /**
     * Set ApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationId
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($applicationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($applicationId, true)), __LINE__);
        }
        if (is_null($applicationId) || (is_array($applicationId) && empty($applicationId))) {
            unset($this->ApplicationId);
        } else {
            $this->ApplicationId = $applicationId;
        }
        return $this;
    }
    /**
     * Get Area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArea()
    {
        return isset($this->Area) ? $this->Area : null;
    }
    /**
     * Set Area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $area
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        if (is_null($area) || (is_array($area) && empty($area))) {
            unset($this->Area);
        } else {
            $this->Area = $area;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypeName()
    {
        return isset($this->ClientTypeName) ? $this->ClientTypeName : null;
    }
    /**
     * Set ClientTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypeName
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setClientTypeName($clientTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypeName) && !is_string($clientTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypeName, true), gettype($clientTypeName)), __LINE__);
        }
        if (is_null($clientTypeName) || (is_array($clientTypeName) && empty($clientTypeName))) {
            unset($this->ClientTypeName);
        } else {
            $this->ClientTypeName = $clientTypeName;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get GroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupId()
    {
        return isset($this->GroupId) ? $this->GroupId : null;
    }
    /**
     * Set GroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupId
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupId, true)), __LINE__);
        }
        if (is_null($groupId) || (is_array($groupId) && empty($groupId))) {
            unset($this->GroupId);
        } else {
            $this->GroupId = $groupId;
        }
        return $this;
    }
    /**
     * Get IsCandidate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCandidate()
    {
        return isset($this->IsCandidate) ? $this->IsCandidate : null;
    }
    /**
     * Set IsCandidate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCandidate
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setIsCandidate($isCandidate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCandidate) && !is_bool($isCandidate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCandidate, true), gettype($isCandidate)), __LINE__);
        }
        if (is_null($isCandidate) || (is_array($isCandidate) && empty($isCandidate))) {
            unset($this->IsCandidate);
        } else {
            $this->IsCandidate = $isCandidate;
        }
        return $this;
    }
    /**
     * Get IsWinner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIsWinner()
    {
        return isset($this->IsWinner) ? $this->IsWinner : null;
    }
    /**
     * Set IsWinner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $isWinner
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setIsWinner($isWinner = null)
    {
        // validation for constraint: int
        if (!is_null($isWinner) && !(is_int($isWinner) || ctype_digit($isWinner))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isWinner, true), gettype($isWinner)), __LINE__);
        }
        if (is_null($isWinner) || (is_array($isWinner) && empty($isWinner))) {
            unset($this->IsWinner);
        } else {
            $this->IsWinner = $isWinner;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get Position value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPosition()
    {
        return isset($this->Position) ? $this->Position : null;
    }
    /**
     * Set Position value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $position
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !(is_int($position) || ctype_digit($position))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        if (is_null($position) || (is_array($position) && empty($position))) {
            unset($this->Position);
        } else {
            $this->Position = $position;
        }
        return $this;
    }
    /**
     * Get PreviousWonCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPreviousWonCount()
    {
        return isset($this->PreviousWonCount) ? $this->PreviousWonCount : null;
    }
    /**
     * Set PreviousWonCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $previousWonCount
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setPreviousWonCount($previousWonCount = null)
    {
        // validation for constraint: int
        if (!is_null($previousWonCount) && !(is_int($previousWonCount) || ctype_digit($previousWonCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($previousWonCount, true), gettype($previousWonCount)), __LINE__);
        }
        if (is_null($previousWonCount) || (is_array($previousWonCount) && empty($previousWonCount))) {
            unset($this->PreviousWonCount);
        } else {
            $this->PreviousWonCount = $previousWonCount;
        }
        return $this;
    }
    /**
     * Get RequestedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRequestedSeats()
    {
        return isset($this->RequestedSeats) ? $this->RequestedSeats : null;
    }
    /**
     * Set RequestedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $requestedSeats
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setRequestedSeats($requestedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($requestedSeats) && !(is_int($requestedSeats) || ctype_digit($requestedSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedSeats, true), gettype($requestedSeats)), __LINE__);
        }
        if (is_null($requestedSeats) || (is_array($requestedSeats) && empty($requestedSeats))) {
            unset($this->RequestedSeats);
        } else {
            $this->RequestedSeats = $requestedSeats;
        }
        return $this;
    }
    /**
     * Get Row value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRow()
    {
        return isset($this->Row) ? $this->Row : null;
    }
    /**
     * Set Row value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $row
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setRow($row = null)
    {
        // validation for constraint: string
        if (!is_null($row) && !is_string($row)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($row, true), gettype($row)), __LINE__);
        }
        if (is_null($row) || (is_array($row) && empty($row))) {
            unset($this->Row);
        } else {
            $this->Row = $row;
        }
        return $this;
    }
    /**
     * Get Seats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeats()
    {
        return isset($this->Seats) ? $this->Seats : null;
    }
    /**
     * Set Seats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seats
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setSeats($seats = null)
    {
        // validation for constraint: string
        if (!is_null($seats) && !is_string($seats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seats, true), gettype($seats)), __LINE__);
        }
        if (is_null($seats) || (is_array($seats) && empty($seats))) {
            unset($this->Seats);
        } else {
            $this->Seats = $seats;
        }
        return $this;
    }
    /**
     * Get SeatsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatsData()
    {
        return isset($this->SeatsData) ? $this->SeatsData : null;
    }
    /**
     * Set SeatsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatsData
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setSeatsData($seatsData = null)
    {
        // validation for constraint: string
        if (!is_null($seatsData) && !is_string($seatsData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatsData, true), gettype($seatsData)), __LINE__);
        }
        if (is_null($seatsData) || (is_array($seatsData) && empty($seatsData))) {
            unset($this->SeatsData);
        } else {
            $this->SeatsData = $seatsData;
        }
        return $this;
    }
    /**
     * Get SectionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionId()
    {
        return isset($this->SectionId) ? $this->SectionId : null;
    }
    /**
     * Set SectionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionId
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setSectionId($sectionId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionId) && !is_string($sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionId, true), gettype($sectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectionId, true)), __LINE__);
        }
        if (is_null($sectionId) || (is_array($sectionId) && empty($sectionId))) {
            unset($this->SectionId);
        } else {
            $this->SectionId = $sectionId;
        }
        return $this;
    }
    /**
     * Get SectionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionName()
    {
        return isset($this->SectionName) ? $this->SectionName : null;
    }
    /**
     * Set SectionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionName
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setSectionName($sectionName = null)
    {
        // validation for constraint: string
        if (!is_null($sectionName) && !is_string($sectionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionName, true), gettype($sectionName)), __LINE__);
        }
        if (is_null($sectionName) || (is_array($sectionName) && empty($sectionName))) {
            unset($this->SectionName);
        } else {
            $this->SectionName = $sectionName;
        }
        return $this;
    }
    /**
     * Get Sector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSector()
    {
        return isset($this->Sector) ? $this->Sector : null;
    }
    /**
     * Set Sector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sector
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setSector($sector = null)
    {
        // validation for constraint: string
        if (!is_null($sector) && !is_string($sector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sector, true), gettype($sector)), __LINE__);
        }
        if (is_null($sector) || (is_array($sector) && empty($sector))) {
            unset($this->Sector);
        } else {
            $this->Sector = $sector;
        }
        return $this;
    }
    /**
     * Get WonSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWonSeats()
    {
        return isset($this->WonSeats) ? $this->WonSeats : null;
    }
    /**
     * Set WonSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $wonSeats
     * @return \patest\StructType\BizAction_Ticketing_BallotApplicant
     */
    public function setWonSeats($wonSeats = null)
    {
        // validation for constraint: int
        if (!is_null($wonSeats) && !(is_int($wonSeats) || ctype_digit($wonSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wonSeats, true), gettype($wonSeats)), __LINE__);
        }
        if (is_null($wonSeats) || (is_array($wonSeats) && empty($wonSeats))) {
            unset($this->WonSeats);
        } else {
            $this->WonSeats = $wonSeats;
        }
        return $this;
    }
}
