<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Ticketing.ApplyChangesForGeneralAdmissionArea.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request extends AnyEntity
{
    /**
     * The Allocations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_SeatingPlanRestrictionInfo
     */
    public $Allocations;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The Capacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Capacity;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The Locks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_SeatingPlanRestrictionInfo
     */
    public $Locks;
    /**
     * The MaxCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxCapacity;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The SeatingPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * Constructor method for
     * BizAction.Ticketing.ApplyChangesForGeneralAdmissionArea.Request
     * @uses BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request::setAllocations()
     * @uses BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request::setAreaId()
     * @uses BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request::setCapacity()
     * @uses BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request::setHallVersionId()
     * @uses BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request::setLocks()
     * @uses BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request::setMaxCapacity()
     * @uses BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request::setPriceLevelId()
     * @uses BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request::setSeatingPlanId()
     * @uses BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request::setShowId()
     * @param \patest\StructType\RecordSetOfTicketing_SeatingPlanRestrictionInfo $allocations
     * @param string $areaId
     * @param int $capacity
     * @param string $hallVersionId
     * @param \patest\StructType\RecordSetOfTicketing_SeatingPlanRestrictionInfo $locks
     * @param int $maxCapacity
     * @param string $priceLevelId
     * @param string $seatingPlanId
     * @param string $showId
     */
    public function __construct(\patest\StructType\RecordSetOfTicketing_SeatingPlanRestrictionInfo $allocations = null, $areaId = null, $capacity = null, $hallVersionId = null, \patest\StructType\RecordSetOfTicketing_SeatingPlanRestrictionInfo $locks = null, $maxCapacity = null, $priceLevelId = null, $seatingPlanId = null, $showId = null)
    {
        $this
            ->setAllocations($allocations)
            ->setAreaId($areaId)
            ->setCapacity($capacity)
            ->setHallVersionId($hallVersionId)
            ->setLocks($locks)
            ->setMaxCapacity($maxCapacity)
            ->setPriceLevelId($priceLevelId)
            ->setSeatingPlanId($seatingPlanId)
            ->setShowId($showId);
    }
    /**
     * Get Allocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_SeatingPlanRestrictionInfo|null
     */
    public function getAllocations()
    {
        return isset($this->Allocations) ? $this->Allocations : null;
    }
    /**
     * Set Allocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_SeatingPlanRestrictionInfo $allocations
     * @return \patest\StructType\BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request
     */
    public function setAllocations(\patest\StructType\RecordSetOfTicketing_SeatingPlanRestrictionInfo $allocations = null)
    {
        if (is_null($allocations) || (is_array($allocations) && empty($allocations))) {
            unset($this->Allocations);
        } else {
            $this->Allocations = $allocations;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get Capacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCapacity()
    {
        return isset($this->Capacity) ? $this->Capacity : null;
    }
    /**
     * Set Capacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $capacity
     * @return \patest\StructType\BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !(is_int($capacity) || ctype_digit($capacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($capacity, true), gettype($capacity)), __LINE__);
        }
        if (is_null($capacity) || (is_array($capacity) && empty($capacity))) {
            unset($this->Capacity);
        } else {
            $this->Capacity = $capacity;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get Locks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_SeatingPlanRestrictionInfo|null
     */
    public function getLocks()
    {
        return isset($this->Locks) ? $this->Locks : null;
    }
    /**
     * Set Locks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_SeatingPlanRestrictionInfo $locks
     * @return \patest\StructType\BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request
     */
    public function setLocks(\patest\StructType\RecordSetOfTicketing_SeatingPlanRestrictionInfo $locks = null)
    {
        if (is_null($locks) || (is_array($locks) && empty($locks))) {
            unset($this->Locks);
        } else {
            $this->Locks = $locks;
        }
        return $this;
    }
    /**
     * Get MaxCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxCapacity()
    {
        return isset($this->MaxCapacity) ? $this->MaxCapacity : null;
    }
    /**
     * Set MaxCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxCapacity
     * @return \patest\StructType\BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request
     */
    public function setMaxCapacity($maxCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($maxCapacity) && !(is_int($maxCapacity) || ctype_digit($maxCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCapacity, true), gettype($maxCapacity)), __LINE__);
        }
        if (is_null($maxCapacity) || (is_array($maxCapacity) && empty($maxCapacity))) {
            unset($this->MaxCapacity);
        } else {
            $this->MaxCapacity = $maxCapacity;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get SeatingPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanId()
    {
        return isset($this->SeatingPlanId) ? $this->SeatingPlanId : null;
    }
    /**
     * Set SeatingPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanId
     * @return \patest\StructType\BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request
     */
    public function setSeatingPlanId($seatingPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanId) && !is_string($seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanId, true), gettype($seatingPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanId, true)), __LINE__);
        }
        if (is_null($seatingPlanId) || (is_array($seatingPlanId) && empty($seatingPlanId))) {
            unset($this->SeatingPlanId);
        } else {
            $this->SeatingPlanId = $seatingPlanId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\BizAction_Ticketing_ApplyChangesForGeneralAdmissionArea_Request
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
}
