<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.AddPriceLevelsToBallotEvent.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_AddPriceLevelsToBallotEvent_Request extends AnyEntity
{
    /**
     * The BallotEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotEventId;
    /**
     * The MaxSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSeats;
    /**
     * The PriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelIds
     */
    public $PriceLevelIds;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypeIds
     */
    public $PriceTypeIds;
    /**
     * Constructor method for BizAction.Ticketing.AddPriceLevelsToBallotEvent.Request
     * @uses BizAction_Ticketing_AddPriceLevelsToBallotEvent_Request::setBallotEventId()
     * @uses BizAction_Ticketing_AddPriceLevelsToBallotEvent_Request::setMaxSeats()
     * @uses BizAction_Ticketing_AddPriceLevelsToBallotEvent_Request::setPriceLevelIds()
     * @uses BizAction_Ticketing_AddPriceLevelsToBallotEvent_Request::setPriceTypeIds()
     * @param string $ballotEventId
     * @param int $maxSeats
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     */
    public function __construct($ballotEventId = null, $maxSeats = null, \patest\StructType\PriceLevelIds $priceLevelIds = null, \patest\StructType\PriceTypeIds $priceTypeIds = null)
    {
        $this
            ->setBallotEventId($ballotEventId)
            ->setMaxSeats($maxSeats)
            ->setPriceLevelIds($priceLevelIds)
            ->setPriceTypeIds($priceTypeIds);
    }
    /**
     * Get BallotEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotEventId()
    {
        return isset($this->BallotEventId) ? $this->BallotEventId : null;
    }
    /**
     * Set BallotEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotEventId
     * @return \patest\StructType\BizAction_Ticketing_AddPriceLevelsToBallotEvent_Request
     */
    public function setBallotEventId($ballotEventId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotEventId) && !is_string($ballotEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotEventId, true), gettype($ballotEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotEventId, true)), __LINE__);
        }
        if (is_null($ballotEventId) || (is_array($ballotEventId) && empty($ballotEventId))) {
            unset($this->BallotEventId);
        } else {
            $this->BallotEventId = $ballotEventId;
        }
        return $this;
    }
    /**
     * Get MaxSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSeats()
    {
        return isset($this->MaxSeats) ? $this->MaxSeats : null;
    }
    /**
     * Set MaxSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSeats
     * @return \patest\StructType\BizAction_Ticketing_AddPriceLevelsToBallotEvent_Request
     */
    public function setMaxSeats($maxSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeats) && !(is_int($maxSeats) || ctype_digit($maxSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeats, true), gettype($maxSeats)), __LINE__);
        }
        if (is_null($maxSeats) || (is_array($maxSeats) && empty($maxSeats))) {
            unset($this->MaxSeats);
        } else {
            $this->MaxSeats = $maxSeats;
        }
        return $this;
    }
    /**
     * Get PriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelIds|null
     */
    public function getPriceLevelIds()
    {
        return isset($this->PriceLevelIds) ? $this->PriceLevelIds : null;
    }
    /**
     * Set PriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @return \patest\StructType\BizAction_Ticketing_AddPriceLevelsToBallotEvent_Request
     */
    public function setPriceLevelIds(\patest\StructType\PriceLevelIds $priceLevelIds = null)
    {
        if (is_null($priceLevelIds) || (is_array($priceLevelIds) && empty($priceLevelIds))) {
            unset($this->PriceLevelIds);
        } else {
            $this->PriceLevelIds = $priceLevelIds;
        }
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypeIds|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @return \patest\StructType\BizAction_Ticketing_AddPriceLevelsToBallotEvent_Request
     */
    public function setPriceTypeIds(\patest\StructType\PriceTypeIds $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
}
