<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Subscriptions.RepriceSubscriptions.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Subscriptions_RepriceSubscriptions_Request extends BizAction_Ticketing_RepriceProduct_Request
{
    /**
     * The ItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemIds;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesIds;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for BizAction.Subscriptions.RepriceSubscriptions.Request
     * @uses BizAction_Subscriptions_RepriceSubscriptions_Request::setItemIds()
     * @uses BizAction_Subscriptions_RepriceSubscriptions_Request::setSeriesIds()
     * @uses BizAction_Subscriptions_RepriceSubscriptions_Request::setTransactionGuid()
     * @param string $itemIds
     * @param string $seriesIds
     * @param string $transactionGuid
     */
    public function __construct($itemIds = null, $seriesIds = null, $transactionGuid = null)
    {
        $this
            ->setItemIds($itemIds)
            ->setSeriesIds($seriesIds)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get ItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemIds()
    {
        return isset($this->ItemIds) ? $this->ItemIds : null;
    }
    /**
     * Set ItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemIds
     * @return \patest\StructType\BizAction_Subscriptions_RepriceSubscriptions_Request
     */
    public function setItemIds($itemIds = null)
    {
        // validation for constraint: string
        if (!is_null($itemIds) && !is_string($itemIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemIds, true), gettype($itemIds)), __LINE__);
        }
        if (is_null($itemIds) || (is_array($itemIds) && empty($itemIds))) {
            unset($this->ItemIds);
        } else {
            $this->ItemIds = $itemIds;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesIds
     * @return \patest\StructType\BizAction_Subscriptions_RepriceSubscriptions_Request
     */
    public function setSeriesIds($seriesIds = null)
    {
        // validation for constraint: string
        if (!is_null($seriesIds) && !is_string($seriesIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesIds, true), gettype($seriesIds)), __LINE__);
        }
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Subscriptions_RepriceSubscriptions_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
