<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Subscription.SetTicketSchemeEnrollmentsOfBasketSubscriptions.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request extends AnyEntity
{
    /**
     * The AreThereAutoTicketSchemesThatRequirePayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AreThereAutoTicketSchemesThatRequirePayment;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The SetPaymentForAutoTicketSchemes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SetPaymentForAutoTicketSchemes;
    /**
     * The TicketSchemeSelections
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSubscription_TicketSchemeSelectionInfo
     */
    public $TicketSchemeSelections;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The UserInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserInfo;
    /**
     * Constructor method for
     * BizAction.Subscription.SetTicketSchemeEnrollmentsOfBasketSubscriptions.Request
     * @uses BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request::setAreThereAutoTicketSchemesThatRequirePayment()
     * @uses BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request::setPaymentMethodId()
     * @uses BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request::setPaymentTokenId()
     * @uses BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request::setSetPaymentForAutoTicketSchemes()
     * @uses BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request::setTicketSchemeSelections()
     * @uses BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request::setTransactionGuid()
     * @uses BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request::setUserInfo()
     * @param bool $areThereAutoTicketSchemesThatRequirePayment
     * @param string $paymentMethodId
     * @param string $paymentTokenId
     * @param bool $setPaymentForAutoTicketSchemes
     * @param \patest\StructType\RecordSetOfSubscription_TicketSchemeSelectionInfo $ticketSchemeSelections
     * @param string $transactionGuid
     * @param string $userInfo
     */
    public function __construct($areThereAutoTicketSchemesThatRequirePayment = null, $paymentMethodId = null, $paymentTokenId = null, $setPaymentForAutoTicketSchemes = null, \patest\StructType\RecordSetOfSubscription_TicketSchemeSelectionInfo $ticketSchemeSelections = null, $transactionGuid = null, $userInfo = null)
    {
        $this
            ->setAreThereAutoTicketSchemesThatRequirePayment($areThereAutoTicketSchemesThatRequirePayment)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentTokenId($paymentTokenId)
            ->setSetPaymentForAutoTicketSchemes($setPaymentForAutoTicketSchemes)
            ->setTicketSchemeSelections($ticketSchemeSelections)
            ->setTransactionGuid($transactionGuid)
            ->setUserInfo($userInfo);
    }
    /**
     * Get AreThereAutoTicketSchemesThatRequirePayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAreThereAutoTicketSchemesThatRequirePayment()
    {
        return isset($this->AreThereAutoTicketSchemesThatRequirePayment) ? $this->AreThereAutoTicketSchemesThatRequirePayment : null;
    }
    /**
     * Set AreThereAutoTicketSchemesThatRequirePayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $areThereAutoTicketSchemesThatRequirePayment
     * @return \patest\StructType\BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request
     */
    public function setAreThereAutoTicketSchemesThatRequirePayment($areThereAutoTicketSchemesThatRequirePayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($areThereAutoTicketSchemesThatRequirePayment) && !is_bool($areThereAutoTicketSchemesThatRequirePayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($areThereAutoTicketSchemesThatRequirePayment, true), gettype($areThereAutoTicketSchemesThatRequirePayment)), __LINE__);
        }
        if (is_null($areThereAutoTicketSchemesThatRequirePayment) || (is_array($areThereAutoTicketSchemesThatRequirePayment) && empty($areThereAutoTicketSchemesThatRequirePayment))) {
            unset($this->AreThereAutoTicketSchemesThatRequirePayment);
        } else {
            $this->AreThereAutoTicketSchemesThatRequirePayment = $areThereAutoTicketSchemesThatRequirePayment;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
    /**
     * Get SetPaymentForAutoTicketSchemes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSetPaymentForAutoTicketSchemes()
    {
        return isset($this->SetPaymentForAutoTicketSchemes) ? $this->SetPaymentForAutoTicketSchemes : null;
    }
    /**
     * Set SetPaymentForAutoTicketSchemes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $setPaymentForAutoTicketSchemes
     * @return \patest\StructType\BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request
     */
    public function setSetPaymentForAutoTicketSchemes($setPaymentForAutoTicketSchemes = null)
    {
        // validation for constraint: boolean
        if (!is_null($setPaymentForAutoTicketSchemes) && !is_bool($setPaymentForAutoTicketSchemes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($setPaymentForAutoTicketSchemes, true), gettype($setPaymentForAutoTicketSchemes)), __LINE__);
        }
        if (is_null($setPaymentForAutoTicketSchemes) || (is_array($setPaymentForAutoTicketSchemes) && empty($setPaymentForAutoTicketSchemes))) {
            unset($this->SetPaymentForAutoTicketSchemes);
        } else {
            $this->SetPaymentForAutoTicketSchemes = $setPaymentForAutoTicketSchemes;
        }
        return $this;
    }
    /**
     * Get TicketSchemeSelections value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSubscription_TicketSchemeSelectionInfo|null
     */
    public function getTicketSchemeSelections()
    {
        return isset($this->TicketSchemeSelections) ? $this->TicketSchemeSelections : null;
    }
    /**
     * Set TicketSchemeSelections value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSubscription_TicketSchemeSelectionInfo $ticketSchemeSelections
     * @return \patest\StructType\BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request
     */
    public function setTicketSchemeSelections(\patest\StructType\RecordSetOfSubscription_TicketSchemeSelectionInfo $ticketSchemeSelections = null)
    {
        if (is_null($ticketSchemeSelections) || (is_array($ticketSchemeSelections) && empty($ticketSchemeSelections))) {
            unset($this->TicketSchemeSelections);
        } else {
            $this->TicketSchemeSelections = $ticketSchemeSelections;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get UserInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserInfo()
    {
        return isset($this->UserInfo) ? $this->UserInfo : null;
    }
    /**
     * Set UserInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userInfo
     * @return \patest\StructType\BizAction_Subscription_SetTicketSchemeEnrollmentsOfBasketSubscriptions_Request
     */
    public function setUserInfo($userInfo = null)
    {
        // validation for constraint: string
        if (!is_null($userInfo) && !is_string($userInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userInfo, true), gettype($userInfo)), __LINE__);
        }
        if (is_null($userInfo) || (is_array($userInfo) && empty($userInfo))) {
            unset($this->UserInfo);
        } else {
            $this->UserInfo = $userInfo;
        }
        return $this;
    }
}
