<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Subscription.SelectNewPriceTypeToRenew.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Subscription_SelectNewPriceTypeToRenew_Request extends AnyEntity
{
    /**
     * The NewPriceTypeIdToRenew
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceTypeIdToRenew;
    /**
     * The OriginalPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalPriceTypeId;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The SubscriptionInstanceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SubscriptionInstanceIds
     */
    public $SubscriptionInstanceIds;
    /**
     * Constructor method for BizAction.Subscription.SelectNewPriceTypeToRenew.Request
     * @uses BizAction_Subscription_SelectNewPriceTypeToRenew_Request::setNewPriceTypeIdToRenew()
     * @uses BizAction_Subscription_SelectNewPriceTypeToRenew_Request::setOriginalPriceTypeId()
     * @uses BizAction_Subscription_SelectNewPriceTypeToRenew_Request::setSubscriptionInstanceId()
     * @uses BizAction_Subscription_SelectNewPriceTypeToRenew_Request::setSubscriptionInstanceIds()
     * @param string $newPriceTypeIdToRenew
     * @param string $originalPriceTypeId
     * @param string $subscriptionInstanceId
     * @param \patest\StructType\SubscriptionInstanceIds $subscriptionInstanceIds
     */
    public function __construct($newPriceTypeIdToRenew = null, $originalPriceTypeId = null, $subscriptionInstanceId = null, \patest\StructType\SubscriptionInstanceIds $subscriptionInstanceIds = null)
    {
        $this
            ->setNewPriceTypeIdToRenew($newPriceTypeIdToRenew)
            ->setOriginalPriceTypeId($originalPriceTypeId)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setSubscriptionInstanceIds($subscriptionInstanceIds);
    }
    /**
     * Get NewPriceTypeIdToRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPriceTypeIdToRenew()
    {
        return isset($this->NewPriceTypeIdToRenew) ? $this->NewPriceTypeIdToRenew : null;
    }
    /**
     * Set NewPriceTypeIdToRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPriceTypeIdToRenew
     * @return \patest\StructType\BizAction_Subscription_SelectNewPriceTypeToRenew_Request
     */
    public function setNewPriceTypeIdToRenew($newPriceTypeIdToRenew = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceTypeIdToRenew) && !is_string($newPriceTypeIdToRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceTypeIdToRenew, true), gettype($newPriceTypeIdToRenew)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceTypeIdToRenew) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceTypeIdToRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceTypeIdToRenew, true)), __LINE__);
        }
        if (is_null($newPriceTypeIdToRenew) || (is_array($newPriceTypeIdToRenew) && empty($newPriceTypeIdToRenew))) {
            unset($this->NewPriceTypeIdToRenew);
        } else {
            $this->NewPriceTypeIdToRenew = $newPriceTypeIdToRenew;
        }
        return $this;
    }
    /**
     * Get OriginalPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalPriceTypeId()
    {
        return isset($this->OriginalPriceTypeId) ? $this->OriginalPriceTypeId : null;
    }
    /**
     * Set OriginalPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalPriceTypeId
     * @return \patest\StructType\BizAction_Subscription_SelectNewPriceTypeToRenew_Request
     */
    public function setOriginalPriceTypeId($originalPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($originalPriceTypeId) && !is_string($originalPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPriceTypeId, true), gettype($originalPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalPriceTypeId, true)), __LINE__);
        }
        if (is_null($originalPriceTypeId) || (is_array($originalPriceTypeId) && empty($originalPriceTypeId))) {
            unset($this->OriginalPriceTypeId);
        } else {
            $this->OriginalPriceTypeId = $originalPriceTypeId;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\BizAction_Subscription_SelectNewPriceTypeToRenew_Request
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SubscriptionInstanceIds|null
     */
    public function getSubscriptionInstanceIds()
    {
        return isset($this->SubscriptionInstanceIds) ? $this->SubscriptionInstanceIds : null;
    }
    /**
     * Set SubscriptionInstanceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SubscriptionInstanceIds $subscriptionInstanceIds
     * @return \patest\StructType\BizAction_Subscription_SelectNewPriceTypeToRenew_Request
     */
    public function setSubscriptionInstanceIds(\patest\StructType\SubscriptionInstanceIds $subscriptionInstanceIds = null)
    {
        if (is_null($subscriptionInstanceIds) || (is_array($subscriptionInstanceIds) && empty($subscriptionInstanceIds))) {
            unset($this->SubscriptionInstanceIds);
        } else {
            $this->SubscriptionInstanceIds = $subscriptionInstanceIds;
        }
        return $this;
    }
}
