<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Subscription.Prolong.Request StructType
 * @subpackage Structs
 */
class BizAction_Subscription_Prolong_Request extends AnyEntity
{
    /**
     * The NewEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewEndDate;
    /**
     * The OldEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldEndDate;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The SubscriptionInstanceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SubscriptionInstanceIds
     */
    public $SubscriptionInstanceIds;
    /**
     * Constructor method for BizAction.Subscription.Prolong.Request
     * @uses BizAction_Subscription_Prolong_Request::setNewEndDate()
     * @uses BizAction_Subscription_Prolong_Request::setOldEndDate()
     * @uses BizAction_Subscription_Prolong_Request::setSubscriptionInstanceId()
     * @uses BizAction_Subscription_Prolong_Request::setSubscriptionInstanceIds()
     * @param string $newEndDate
     * @param string $oldEndDate
     * @param string $subscriptionInstanceId
     * @param \patest\StructType\SubscriptionInstanceIds $subscriptionInstanceIds
     */
    public function __construct($newEndDate = null, $oldEndDate = null, $subscriptionInstanceId = null, \patest\StructType\SubscriptionInstanceIds $subscriptionInstanceIds = null)
    {
        $this
            ->setNewEndDate($newEndDate)
            ->setOldEndDate($oldEndDate)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setSubscriptionInstanceIds($subscriptionInstanceIds);
    }
    /**
     * Get NewEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewEndDate()
    {
        return isset($this->NewEndDate) ? $this->NewEndDate : null;
    }
    /**
     * Set NewEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newEndDate
     * @return \patest\StructType\BizAction_Subscription_Prolong_Request
     */
    public function setNewEndDate($newEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($newEndDate) && !is_string($newEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newEndDate, true), gettype($newEndDate)), __LINE__);
        }
        if (is_null($newEndDate) || (is_array($newEndDate) && empty($newEndDate))) {
            unset($this->NewEndDate);
        } else {
            $this->NewEndDate = $newEndDate;
        }
        return $this;
    }
    /**
     * Get OldEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldEndDate()
    {
        return isset($this->OldEndDate) ? $this->OldEndDate : null;
    }
    /**
     * Set OldEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldEndDate
     * @return \patest\StructType\BizAction_Subscription_Prolong_Request
     */
    public function setOldEndDate($oldEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($oldEndDate) && !is_string($oldEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldEndDate, true), gettype($oldEndDate)), __LINE__);
        }
        if (is_null($oldEndDate) || (is_array($oldEndDate) && empty($oldEndDate))) {
            unset($this->OldEndDate);
        } else {
            $this->OldEndDate = $oldEndDate;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\BizAction_Subscription_Prolong_Request
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SubscriptionInstanceIds|null
     */
    public function getSubscriptionInstanceIds()
    {
        return isset($this->SubscriptionInstanceIds) ? $this->SubscriptionInstanceIds : null;
    }
    /**
     * Set SubscriptionInstanceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SubscriptionInstanceIds $subscriptionInstanceIds
     * @return \patest\StructType\BizAction_Subscription_Prolong_Request
     */
    public function setSubscriptionInstanceIds(\patest\StructType\SubscriptionInstanceIds $subscriptionInstanceIds = null)
    {
        if (is_null($subscriptionInstanceIds) || (is_array($subscriptionInstanceIds) && empty($subscriptionInstanceIds))) {
            unset($this->SubscriptionInstanceIds);
        } else {
            $this->SubscriptionInstanceIds = $subscriptionInstanceIds;
        }
        return $this;
    }
}
