<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Subscription.ProcessSubscriptionAutoRenew.Request StructType
 * @subpackage Structs
 */
class BizAction_Subscription_ProcessSubscriptionAutoRenew_Request extends AnyEntity
{
    /**
     * The IsVerificationOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVerificationOnly;
    /**
     * The MaxSubscriptionsToRenew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSubscriptionsToRenew;
    /**
     * The NewSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewSeriesId;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The TargetPaymentPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPaymentPlanId;
    /**
     * The TargetPaymentPlanStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetPaymentPlanStartDate;
    /**
     * Constructor method for
     * BizAction.Subscription.ProcessSubscriptionAutoRenew.Request
     * @uses BizAction_Subscription_ProcessSubscriptionAutoRenew_Request::setIsVerificationOnly()
     * @uses BizAction_Subscription_ProcessSubscriptionAutoRenew_Request::setMaxSubscriptionsToRenew()
     * @uses BizAction_Subscription_ProcessSubscriptionAutoRenew_Request::setNewSeriesId()
     * @uses BizAction_Subscription_ProcessSubscriptionAutoRenew_Request::setSeriesId()
     * @uses BizAction_Subscription_ProcessSubscriptionAutoRenew_Request::setTargetPaymentPlanId()
     * @uses BizAction_Subscription_ProcessSubscriptionAutoRenew_Request::setTargetPaymentPlanStartDate()
     * @param bool $isVerificationOnly
     * @param int $maxSubscriptionsToRenew
     * @param string $newSeriesId
     * @param string $seriesId
     * @param string $targetPaymentPlanId
     * @param string $targetPaymentPlanStartDate
     */
    public function __construct($isVerificationOnly = null, $maxSubscriptionsToRenew = null, $newSeriesId = null, $seriesId = null, $targetPaymentPlanId = null, $targetPaymentPlanStartDate = null)
    {
        $this
            ->setIsVerificationOnly($isVerificationOnly)
            ->setMaxSubscriptionsToRenew($maxSubscriptionsToRenew)
            ->setNewSeriesId($newSeriesId)
            ->setSeriesId($seriesId)
            ->setTargetPaymentPlanId($targetPaymentPlanId)
            ->setTargetPaymentPlanStartDate($targetPaymentPlanStartDate);
    }
    /**
     * Get IsVerificationOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVerificationOnly()
    {
        return isset($this->IsVerificationOnly) ? $this->IsVerificationOnly : null;
    }
    /**
     * Set IsVerificationOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVerificationOnly
     * @return \patest\StructType\BizAction_Subscription_ProcessSubscriptionAutoRenew_Request
     */
    public function setIsVerificationOnly($isVerificationOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVerificationOnly) && !is_bool($isVerificationOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVerificationOnly, true), gettype($isVerificationOnly)), __LINE__);
        }
        if (is_null($isVerificationOnly) || (is_array($isVerificationOnly) && empty($isVerificationOnly))) {
            unset($this->IsVerificationOnly);
        } else {
            $this->IsVerificationOnly = $isVerificationOnly;
        }
        return $this;
    }
    /**
     * Get MaxSubscriptionsToRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSubscriptionsToRenew()
    {
        return isset($this->MaxSubscriptionsToRenew) ? $this->MaxSubscriptionsToRenew : null;
    }
    /**
     * Set MaxSubscriptionsToRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSubscriptionsToRenew
     * @return \patest\StructType\BizAction_Subscription_ProcessSubscriptionAutoRenew_Request
     */
    public function setMaxSubscriptionsToRenew($maxSubscriptionsToRenew = null)
    {
        // validation for constraint: int
        if (!is_null($maxSubscriptionsToRenew) && !(is_int($maxSubscriptionsToRenew) || ctype_digit($maxSubscriptionsToRenew))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSubscriptionsToRenew, true), gettype($maxSubscriptionsToRenew)), __LINE__);
        }
        if (is_null($maxSubscriptionsToRenew) || (is_array($maxSubscriptionsToRenew) && empty($maxSubscriptionsToRenew))) {
            unset($this->MaxSubscriptionsToRenew);
        } else {
            $this->MaxSubscriptionsToRenew = $maxSubscriptionsToRenew;
        }
        return $this;
    }
    /**
     * Get NewSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewSeriesId()
    {
        return isset($this->NewSeriesId) ? $this->NewSeriesId : null;
    }
    /**
     * Set NewSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newSeriesId
     * @return \patest\StructType\BizAction_Subscription_ProcessSubscriptionAutoRenew_Request
     */
    public function setNewSeriesId($newSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($newSeriesId) && !is_string($newSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSeriesId, true), gettype($newSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newSeriesId, true)), __LINE__);
        }
        if (is_null($newSeriesId) || (is_array($newSeriesId) && empty($newSeriesId))) {
            unset($this->NewSeriesId);
        } else {
            $this->NewSeriesId = $newSeriesId;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\BizAction_Subscription_ProcessSubscriptionAutoRenew_Request
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get TargetPaymentPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPaymentPlanId()
    {
        return isset($this->TargetPaymentPlanId) ? $this->TargetPaymentPlanId : null;
    }
    /**
     * Set TargetPaymentPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPaymentPlanId
     * @return \patest\StructType\BizAction_Subscription_ProcessSubscriptionAutoRenew_Request
     */
    public function setTargetPaymentPlanId($targetPaymentPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPaymentPlanId) && !is_string($targetPaymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPaymentPlanId, true), gettype($targetPaymentPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPaymentPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPaymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPaymentPlanId, true)), __LINE__);
        }
        if (is_null($targetPaymentPlanId) || (is_array($targetPaymentPlanId) && empty($targetPaymentPlanId))) {
            unset($this->TargetPaymentPlanId);
        } else {
            $this->TargetPaymentPlanId = $targetPaymentPlanId;
        }
        return $this;
    }
    /**
     * Get TargetPaymentPlanStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPaymentPlanStartDate()
    {
        return isset($this->TargetPaymentPlanStartDate) ? $this->TargetPaymentPlanStartDate : null;
    }
    /**
     * Set TargetPaymentPlanStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPaymentPlanStartDate
     * @return \patest\StructType\BizAction_Subscription_ProcessSubscriptionAutoRenew_Request
     */
    public function setTargetPaymentPlanStartDate($targetPaymentPlanStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($targetPaymentPlanStartDate) && !is_string($targetPaymentPlanStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPaymentPlanStartDate, true), gettype($targetPaymentPlanStartDate)), __LINE__);
        }
        if (is_null($targetPaymentPlanStartDate) || (is_array($targetPaymentPlanStartDate) && empty($targetPaymentPlanStartDate))) {
            unset($this->TargetPaymentPlanStartDate);
        } else {
            $this->TargetPaymentPlanStartDate = $targetPaymentPlanStartDate;
        }
        return $this;
    }
}
