<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Subscription.ModifySeriesOverlaps.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Subscription_ModifySeriesOverlaps_Request extends AnyEntity
{
    /**
     * The MasterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MasterId;
    /**
     * The OverlapsSubSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\OverlapsSubSeries
     */
    public $OverlapsSubSeries;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * Constructor method for BizAction.Subscription.ModifySeriesOverlaps.Request
     * @uses BizAction_Subscription_ModifySeriesOverlaps_Request::setMasterId()
     * @uses BizAction_Subscription_ModifySeriesOverlaps_Request::setOverlapsSubSeries()
     * @uses BizAction_Subscription_ModifySeriesOverlaps_Request::setSeriesId()
     * @param string $masterId
     * @param \patest\StructType\OverlapsSubSeries $overlapsSubSeries
     * @param string $seriesId
     */
    public function __construct($masterId = null, \patest\StructType\OverlapsSubSeries $overlapsSubSeries = null, $seriesId = null)
    {
        $this
            ->setMasterId($masterId)
            ->setOverlapsSubSeries($overlapsSubSeries)
            ->setSeriesId($seriesId);
    }
    /**
     * Get MasterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterId()
    {
        return isset($this->MasterId) ? $this->MasterId : null;
    }
    /**
     * Set MasterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterId
     * @return \patest\StructType\BizAction_Subscription_ModifySeriesOverlaps_Request
     */
    public function setMasterId($masterId = null)
    {
        // validation for constraint: string
        if (!is_null($masterId) && !is_string($masterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterId, true), gettype($masterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($masterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $masterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($masterId, true)), __LINE__);
        }
        if (is_null($masterId) || (is_array($masterId) && empty($masterId))) {
            unset($this->MasterId);
        } else {
            $this->MasterId = $masterId;
        }
        return $this;
    }
    /**
     * Get OverlapsSubSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\OverlapsSubSeries|null
     */
    public function getOverlapsSubSeries()
    {
        return isset($this->OverlapsSubSeries) ? $this->OverlapsSubSeries : null;
    }
    /**
     * Set OverlapsSubSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\OverlapsSubSeries $overlapsSubSeries
     * @return \patest\StructType\BizAction_Subscription_ModifySeriesOverlaps_Request
     */
    public function setOverlapsSubSeries(\patest\StructType\OverlapsSubSeries $overlapsSubSeries = null)
    {
        if (is_null($overlapsSubSeries) || (is_array($overlapsSubSeries) && empty($overlapsSubSeries))) {
            unset($this->OverlapsSubSeries);
        } else {
            $this->OverlapsSubSeries = $overlapsSubSeries;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\BizAction_Subscription_ModifySeriesOverlaps_Request
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
}
