<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Subscription.InitiateReturnSubscriberTickets.Request StructType
 * @subpackage Structs
 */
class BizAction_Subscription_InitiateReturnSubscriberTickets_Request extends AnyEntity
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The CountExchangesAgainstLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CountExchangesAgainstLimit;
    /**
     * The FullStackExchangesCandidatesAllReachedLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FullStackExchangesCandidatesAllReachedLimit;
    /**
     * The FullStackExchangesCandidatesExist
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FullStackExchangesCandidatesExist;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_TicketInAction
     */
    public $Items;
    /**
     * The KeepBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepBarcode;
    /**
     * The KeepOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepOnCard;
    /**
     * The NewOwner
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewOwner;
    /**
     * The NewPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NewPrice;
    /**
     * The NewPriceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceType;
    /**
     * The NumOfSubscriptionsThatWillReachExchangeLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumOfSubscriptionsThatWillReachExchangeLimit;
    /**
     * The PrintItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintItem;
    /**
     * The RepriceTicketsScenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RepriceTicketsScenario;
    /**
     * The SeriesEventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesEventIds;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesIds;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesName;
    /**
     * The SpecifiedClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SpecifiedClientId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The UsePrintedTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UsePrintedTickets;
    /**
     * Constructor method for
     * BizAction.Subscription.InitiateReturnSubscriberTickets.Request
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setAction()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setCountExchangesAgainstLimit()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setFullStackExchangesCandidatesAllReachedLimit()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setFullStackExchangesCandidatesExist()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setItems()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setKeepBarcode()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setKeepOnCard()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setNewOwner()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setNewPrice()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setNewPriceType()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setNumOfSubscriptionsThatWillReachExchangeLimit()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setPrintItem()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setRepriceTicketsScenario()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setSeriesEventIds()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setSeriesId()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setSeriesIds()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setSeriesName()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setSpecifiedClientId()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setTransactionGuid()
     * @uses BizAction_Subscription_InitiateReturnSubscriberTickets_Request::setUsePrintedTickets()
     * @param string $action
     * @param bool $countExchangesAgainstLimit
     * @param bool $fullStackExchangesCandidatesAllReachedLimit
     * @param bool $fullStackExchangesCandidatesExist
     * @param \patest\StructType\RecordSetOfTicketing_TicketInAction $items
     * @param bool $keepBarcode
     * @param bool $keepOnCard
     * @param string $newOwner
     * @param float $newPrice
     * @param string $newPriceType
     * @param int $numOfSubscriptionsThatWillReachExchangeLimit
     * @param bool $printItem
     * @param string $repriceTicketsScenario
     * @param string $seriesEventIds
     * @param string $seriesId
     * @param string $seriesIds
     * @param string $seriesName
     * @param string $specifiedClientId
     * @param string $transactionGuid
     * @param string $usePrintedTickets
     */
    public function __construct($action = null, $countExchangesAgainstLimit = null, $fullStackExchangesCandidatesAllReachedLimit = null, $fullStackExchangesCandidatesExist = null, \patest\StructType\RecordSetOfTicketing_TicketInAction $items = null, $keepBarcode = null, $keepOnCard = null, $newOwner = null, $newPrice = null, $newPriceType = null, $numOfSubscriptionsThatWillReachExchangeLimit = null, $printItem = null, $repriceTicketsScenario = null, $seriesEventIds = null, $seriesId = null, $seriesIds = null, $seriesName = null, $specifiedClientId = null, $transactionGuid = null, $usePrintedTickets = null)
    {
        $this
            ->setAction($action)
            ->setCountExchangesAgainstLimit($countExchangesAgainstLimit)
            ->setFullStackExchangesCandidatesAllReachedLimit($fullStackExchangesCandidatesAllReachedLimit)
            ->setFullStackExchangesCandidatesExist($fullStackExchangesCandidatesExist)
            ->setItems($items)
            ->setKeepBarcode($keepBarcode)
            ->setKeepOnCard($keepOnCard)
            ->setNewOwner($newOwner)
            ->setNewPrice($newPrice)
            ->setNewPriceType($newPriceType)
            ->setNumOfSubscriptionsThatWillReachExchangeLimit($numOfSubscriptionsThatWillReachExchangeLimit)
            ->setPrintItem($printItem)
            ->setRepriceTicketsScenario($repriceTicketsScenario)
            ->setSeriesEventIds($seriesEventIds)
            ->setSeriesId($seriesId)
            ->setSeriesIds($seriesIds)
            ->setSeriesName($seriesName)
            ->setSpecifiedClientId($specifiedClientId)
            ->setTransactionGuid($transactionGuid)
            ->setUsePrintedTickets($usePrintedTickets);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberTicketsAction::valueIsValid()
     * @uses \patest\EnumType\SubscriberTicketsAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberTicketsAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberTicketsAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\SubscriberTicketsAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get CountExchangesAgainstLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCountExchangesAgainstLimit()
    {
        return isset($this->CountExchangesAgainstLimit) ? $this->CountExchangesAgainstLimit : null;
    }
    /**
     * Set CountExchangesAgainstLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $countExchangesAgainstLimit
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setCountExchangesAgainstLimit($countExchangesAgainstLimit = null)
    {
        // validation for constraint: boolean
        if (!is_null($countExchangesAgainstLimit) && !is_bool($countExchangesAgainstLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($countExchangesAgainstLimit, true), gettype($countExchangesAgainstLimit)), __LINE__);
        }
        if (is_null($countExchangesAgainstLimit) || (is_array($countExchangesAgainstLimit) && empty($countExchangesAgainstLimit))) {
            unset($this->CountExchangesAgainstLimit);
        } else {
            $this->CountExchangesAgainstLimit = $countExchangesAgainstLimit;
        }
        return $this;
    }
    /**
     * Get FullStackExchangesCandidatesAllReachedLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFullStackExchangesCandidatesAllReachedLimit()
    {
        return isset($this->FullStackExchangesCandidatesAllReachedLimit) ? $this->FullStackExchangesCandidatesAllReachedLimit : null;
    }
    /**
     * Set FullStackExchangesCandidatesAllReachedLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $fullStackExchangesCandidatesAllReachedLimit
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setFullStackExchangesCandidatesAllReachedLimit($fullStackExchangesCandidatesAllReachedLimit = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullStackExchangesCandidatesAllReachedLimit) && !is_bool($fullStackExchangesCandidatesAllReachedLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fullStackExchangesCandidatesAllReachedLimit, true), gettype($fullStackExchangesCandidatesAllReachedLimit)), __LINE__);
        }
        if (is_null($fullStackExchangesCandidatesAllReachedLimit) || (is_array($fullStackExchangesCandidatesAllReachedLimit) && empty($fullStackExchangesCandidatesAllReachedLimit))) {
            unset($this->FullStackExchangesCandidatesAllReachedLimit);
        } else {
            $this->FullStackExchangesCandidatesAllReachedLimit = $fullStackExchangesCandidatesAllReachedLimit;
        }
        return $this;
    }
    /**
     * Get FullStackExchangesCandidatesExist value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFullStackExchangesCandidatesExist()
    {
        return isset($this->FullStackExchangesCandidatesExist) ? $this->FullStackExchangesCandidatesExist : null;
    }
    /**
     * Set FullStackExchangesCandidatesExist value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $fullStackExchangesCandidatesExist
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setFullStackExchangesCandidatesExist($fullStackExchangesCandidatesExist = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullStackExchangesCandidatesExist) && !is_bool($fullStackExchangesCandidatesExist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fullStackExchangesCandidatesExist, true), gettype($fullStackExchangesCandidatesExist)), __LINE__);
        }
        if (is_null($fullStackExchangesCandidatesExist) || (is_array($fullStackExchangesCandidatesExist) && empty($fullStackExchangesCandidatesExist))) {
            unset($this->FullStackExchangesCandidatesExist);
        } else {
            $this->FullStackExchangesCandidatesExist = $fullStackExchangesCandidatesExist;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_TicketInAction|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_TicketInAction $items
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setItems(\patest\StructType\RecordSetOfTicketing_TicketInAction $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get KeepBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepBarcode()
    {
        return isset($this->KeepBarcode) ? $this->KeepBarcode : null;
    }
    /**
     * Set KeepBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepBarcode
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setKeepBarcode($keepBarcode = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepBarcode) && !is_bool($keepBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepBarcode, true), gettype($keepBarcode)), __LINE__);
        }
        if (is_null($keepBarcode) || (is_array($keepBarcode) && empty($keepBarcode))) {
            unset($this->KeepBarcode);
        } else {
            $this->KeepBarcode = $keepBarcode;
        }
        return $this;
    }
    /**
     * Get KeepOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepOnCard()
    {
        return isset($this->KeepOnCard) ? $this->KeepOnCard : null;
    }
    /**
     * Set KeepOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepOnCard
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setKeepOnCard($keepOnCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepOnCard) && !is_bool($keepOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepOnCard, true), gettype($keepOnCard)), __LINE__);
        }
        if (is_null($keepOnCard) || (is_array($keepOnCard) && empty($keepOnCard))) {
            unset($this->KeepOnCard);
        } else {
            $this->KeepOnCard = $keepOnCard;
        }
        return $this;
    }
    /**
     * Get NewOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewOwner()
    {
        return isset($this->NewOwner) ? $this->NewOwner : null;
    }
    /**
     * Set NewOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newOwner
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setNewOwner($newOwner = null)
    {
        // validation for constraint: string
        if (!is_null($newOwner) && !is_string($newOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newOwner, true), gettype($newOwner)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newOwner) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newOwner, true)), __LINE__);
        }
        if (is_null($newOwner) || (is_array($newOwner) && empty($newOwner))) {
            unset($this->NewOwner);
        } else {
            $this->NewOwner = $newOwner;
        }
        return $this;
    }
    /**
     * Get NewPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNewPrice()
    {
        return isset($this->NewPrice) ? $this->NewPrice : null;
    }
    /**
     * Set NewPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $newPrice
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setNewPrice($newPrice = null)
    {
        // validation for constraint: float
        if (!is_null($newPrice) && !(is_float($newPrice) || is_numeric($newPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($newPrice, true), gettype($newPrice)), __LINE__);
        }
        if (is_null($newPrice) || (is_array($newPrice) && empty($newPrice))) {
            unset($this->NewPrice);
        } else {
            $this->NewPrice = $newPrice;
        }
        return $this;
    }
    /**
     * Get NewPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPriceType()
    {
        return isset($this->NewPriceType) ? $this->NewPriceType : null;
    }
    /**
     * Set NewPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPriceType
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setNewPriceType($newPriceType = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceType) && !is_string($newPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceType, true), gettype($newPriceType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceType, true)), __LINE__);
        }
        if (is_null($newPriceType) || (is_array($newPriceType) && empty($newPriceType))) {
            unset($this->NewPriceType);
        } else {
            $this->NewPriceType = $newPriceType;
        }
        return $this;
    }
    /**
     * Get NumOfSubscriptionsThatWillReachExchangeLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumOfSubscriptionsThatWillReachExchangeLimit()
    {
        return isset($this->NumOfSubscriptionsThatWillReachExchangeLimit) ? $this->NumOfSubscriptionsThatWillReachExchangeLimit : null;
    }
    /**
     * Set NumOfSubscriptionsThatWillReachExchangeLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numOfSubscriptionsThatWillReachExchangeLimit
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setNumOfSubscriptionsThatWillReachExchangeLimit($numOfSubscriptionsThatWillReachExchangeLimit = null)
    {
        // validation for constraint: int
        if (!is_null($numOfSubscriptionsThatWillReachExchangeLimit) && !(is_int($numOfSubscriptionsThatWillReachExchangeLimit) || ctype_digit($numOfSubscriptionsThatWillReachExchangeLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numOfSubscriptionsThatWillReachExchangeLimit, true), gettype($numOfSubscriptionsThatWillReachExchangeLimit)), __LINE__);
        }
        if (is_null($numOfSubscriptionsThatWillReachExchangeLimit) || (is_array($numOfSubscriptionsThatWillReachExchangeLimit) && empty($numOfSubscriptionsThatWillReachExchangeLimit))) {
            unset($this->NumOfSubscriptionsThatWillReachExchangeLimit);
        } else {
            $this->NumOfSubscriptionsThatWillReachExchangeLimit = $numOfSubscriptionsThatWillReachExchangeLimit;
        }
        return $this;
    }
    /**
     * Get PrintItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintItem()
    {
        return isset($this->PrintItem) ? $this->PrintItem : null;
    }
    /**
     * Set PrintItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printItem
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setPrintItem($printItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($printItem) && !is_bool($printItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printItem, true), gettype($printItem)), __LINE__);
        }
        if (is_null($printItem) || (is_array($printItem) && empty($printItem))) {
            unset($this->PrintItem);
        } else {
            $this->PrintItem = $printItem;
        }
        return $this;
    }
    /**
     * Get RepriceTicketsScenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRepriceTicketsScenario()
    {
        return isset($this->RepriceTicketsScenario) ? $this->RepriceTicketsScenario : null;
    }
    /**
     * Set RepriceTicketsScenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RepriceTicketsScenario::valueIsValid()
     * @uses \patest\EnumType\RepriceTicketsScenario::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $repriceTicketsScenario
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setRepriceTicketsScenario($repriceTicketsScenario = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RepriceTicketsScenario::valueIsValid($repriceTicketsScenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RepriceTicketsScenario', is_array($repriceTicketsScenario) ? implode(', ', $repriceTicketsScenario) : var_export($repriceTicketsScenario, true), implode(', ', \patest\EnumType\RepriceTicketsScenario::getValidValues())), __LINE__);
        }
        if (is_null($repriceTicketsScenario) || (is_array($repriceTicketsScenario) && empty($repriceTicketsScenario))) {
            unset($this->RepriceTicketsScenario);
        } else {
            $this->RepriceTicketsScenario = $repriceTicketsScenario;
        }
        return $this;
    }
    /**
     * Get SeriesEventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesEventIds()
    {
        return isset($this->SeriesEventIds) ? $this->SeriesEventIds : null;
    }
    /**
     * Set SeriesEventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesEventIds
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setSeriesEventIds($seriesEventIds = null)
    {
        // validation for constraint: string
        if (!is_null($seriesEventIds) && !is_string($seriesEventIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesEventIds, true), gettype($seriesEventIds)), __LINE__);
        }
        if (is_null($seriesEventIds) || (is_array($seriesEventIds) && empty($seriesEventIds))) {
            unset($this->SeriesEventIds);
        } else {
            $this->SeriesEventIds = $seriesEventIds;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesIds
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setSeriesIds($seriesIds = null)
    {
        // validation for constraint: string
        if (!is_null($seriesIds) && !is_string($seriesIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesIds, true), gettype($seriesIds)), __LINE__);
        }
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesName
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setSeriesName($seriesName = null)
    {
        // validation for constraint: string
        if (!is_null($seriesName) && !is_string($seriesName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesName, true), gettype($seriesName)), __LINE__);
        }
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get SpecifiedClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecifiedClientId()
    {
        return isset($this->SpecifiedClientId) ? $this->SpecifiedClientId : null;
    }
    /**
     * Set SpecifiedClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specifiedClientId
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setSpecifiedClientId($specifiedClientId = null)
    {
        // validation for constraint: string
        if (!is_null($specifiedClientId) && !is_string($specifiedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specifiedClientId, true), gettype($specifiedClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($specifiedClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $specifiedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($specifiedClientId, true)), __LINE__);
        }
        if (is_null($specifiedClientId) || (is_array($specifiedClientId) && empty($specifiedClientId))) {
            unset($this->SpecifiedClientId);
        } else {
            $this->SpecifiedClientId = $specifiedClientId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get UsePrintedTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsePrintedTickets()
    {
        return isset($this->UsePrintedTickets) ? $this->UsePrintedTickets : null;
    }
    /**
     * Set UsePrintedTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\UsePrintedTickets::valueIsValid()
     * @uses \patest\EnumType\UsePrintedTickets::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usePrintedTickets
     * @return \patest\StructType\BizAction_Subscription_InitiateReturnSubscriberTickets_Request
     */
    public function setUsePrintedTickets($usePrintedTickets = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\UsePrintedTickets::valueIsValid($usePrintedTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\UsePrintedTickets', is_array($usePrintedTickets) ? implode(', ', $usePrintedTickets) : var_export($usePrintedTickets, true), implode(', ', \patest\EnumType\UsePrintedTickets::getValidValues())), __LINE__);
        }
        if (is_null($usePrintedTickets) || (is_array($usePrintedTickets) && empty($usePrintedTickets))) {
            unset($this->UsePrintedTickets);
        } else {
            $this->UsePrintedTickets = $usePrintedTickets;
        }
        return $this;
    }
}
