<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Subscription.InitiateReplaceSubscriptionProcess.Request StructType
 * @subpackage Structs
 */
class BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request extends AnyEntity
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_SubscriptionInstanceInAction
     */
    public $Items;
    /**
     * The KeepBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepBarcode;
    /**
     * The NewOwner
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewOwner;
    /**
     * The NewPriceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceType;
    /**
     * The PrintItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintItem;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesName;
    /**
     * The SpecifiedClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SpecifiedClientId;
    /**
     * The SubscriptionInstancesSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstancesSeriesId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for
     * BizAction.Subscription.InitiateReplaceSubscriptionProcess.Request
     * @uses BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request::setAction()
     * @uses BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request::setItems()
     * @uses BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request::setKeepBarcode()
     * @uses BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request::setNewOwner()
     * @uses BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request::setNewPriceType()
     * @uses BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request::setPrintItem()
     * @uses BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request::setSeriesId()
     * @uses BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request::setSeriesName()
     * @uses BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request::setSpecifiedClientId()
     * @uses BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request::setSubscriptionInstancesSeriesId()
     * @uses BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request::setTransactionGuid()
     * @param string $action
     * @param \patest\StructType\RecordSetOfTicketing_SubscriptionInstanceInAction $items
     * @param bool $keepBarcode
     * @param string $newOwner
     * @param string $newPriceType
     * @param bool $printItem
     * @param string $seriesId
     * @param string $seriesName
     * @param string $specifiedClientId
     * @param string $subscriptionInstancesSeriesId
     * @param string $transactionGuid
     */
    public function __construct($action = null, \patest\StructType\RecordSetOfTicketing_SubscriptionInstanceInAction $items = null, $keepBarcode = null, $newOwner = null, $newPriceType = null, $printItem = null, $seriesId = null, $seriesName = null, $specifiedClientId = null, $subscriptionInstancesSeriesId = null, $transactionGuid = null)
    {
        $this
            ->setAction($action)
            ->setItems($items)
            ->setKeepBarcode($keepBarcode)
            ->setNewOwner($newOwner)
            ->setNewPriceType($newPriceType)
            ->setPrintItem($printItem)
            ->setSeriesId($seriesId)
            ->setSeriesName($seriesName)
            ->setSpecifiedClientId($specifiedClientId)
            ->setSubscriptionInstancesSeriesId($subscriptionInstancesSeriesId)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionProcessAction::valueIsValid()
     * @uses \patest\EnumType\SubscriptionProcessAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionProcessAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionProcessAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\SubscriptionProcessAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_SubscriptionInstanceInAction|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_SubscriptionInstanceInAction $items
     * @return \patest\StructType\BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request
     */
    public function setItems(\patest\StructType\RecordSetOfTicketing_SubscriptionInstanceInAction $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get KeepBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepBarcode()
    {
        return isset($this->KeepBarcode) ? $this->KeepBarcode : null;
    }
    /**
     * Set KeepBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepBarcode
     * @return \patest\StructType\BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request
     */
    public function setKeepBarcode($keepBarcode = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepBarcode) && !is_bool($keepBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepBarcode, true), gettype($keepBarcode)), __LINE__);
        }
        if (is_null($keepBarcode) || (is_array($keepBarcode) && empty($keepBarcode))) {
            unset($this->KeepBarcode);
        } else {
            $this->KeepBarcode = $keepBarcode;
        }
        return $this;
    }
    /**
     * Get NewOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewOwner()
    {
        return isset($this->NewOwner) ? $this->NewOwner : null;
    }
    /**
     * Set NewOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newOwner
     * @return \patest\StructType\BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request
     */
    public function setNewOwner($newOwner = null)
    {
        // validation for constraint: string
        if (!is_null($newOwner) && !is_string($newOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newOwner, true), gettype($newOwner)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newOwner) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newOwner, true)), __LINE__);
        }
        if (is_null($newOwner) || (is_array($newOwner) && empty($newOwner))) {
            unset($this->NewOwner);
        } else {
            $this->NewOwner = $newOwner;
        }
        return $this;
    }
    /**
     * Get NewPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPriceType()
    {
        return isset($this->NewPriceType) ? $this->NewPriceType : null;
    }
    /**
     * Set NewPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPriceType
     * @return \patest\StructType\BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request
     */
    public function setNewPriceType($newPriceType = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceType) && !is_string($newPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceType, true), gettype($newPriceType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceType, true)), __LINE__);
        }
        if (is_null($newPriceType) || (is_array($newPriceType) && empty($newPriceType))) {
            unset($this->NewPriceType);
        } else {
            $this->NewPriceType = $newPriceType;
        }
        return $this;
    }
    /**
     * Get PrintItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintItem()
    {
        return isset($this->PrintItem) ? $this->PrintItem : null;
    }
    /**
     * Set PrintItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printItem
     * @return \patest\StructType\BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request
     */
    public function setPrintItem($printItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($printItem) && !is_bool($printItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printItem, true), gettype($printItem)), __LINE__);
        }
        if (is_null($printItem) || (is_array($printItem) && empty($printItem))) {
            unset($this->PrintItem);
        } else {
            $this->PrintItem = $printItem;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesName
     * @return \patest\StructType\BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request
     */
    public function setSeriesName($seriesName = null)
    {
        // validation for constraint: string
        if (!is_null($seriesName) && !is_string($seriesName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesName, true), gettype($seriesName)), __LINE__);
        }
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get SpecifiedClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecifiedClientId()
    {
        return isset($this->SpecifiedClientId) ? $this->SpecifiedClientId : null;
    }
    /**
     * Set SpecifiedClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specifiedClientId
     * @return \patest\StructType\BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request
     */
    public function setSpecifiedClientId($specifiedClientId = null)
    {
        // validation for constraint: string
        if (!is_null($specifiedClientId) && !is_string($specifiedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specifiedClientId, true), gettype($specifiedClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($specifiedClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $specifiedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($specifiedClientId, true)), __LINE__);
        }
        if (is_null($specifiedClientId) || (is_array($specifiedClientId) && empty($specifiedClientId))) {
            unset($this->SpecifiedClientId);
        } else {
            $this->SpecifiedClientId = $specifiedClientId;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstancesSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstancesSeriesId()
    {
        return isset($this->SubscriptionInstancesSeriesId) ? $this->SubscriptionInstancesSeriesId : null;
    }
    /**
     * Set SubscriptionInstancesSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstancesSeriesId
     * @return \patest\StructType\BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request
     */
    public function setSubscriptionInstancesSeriesId($subscriptionInstancesSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstancesSeriesId) && !is_string($subscriptionInstancesSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstancesSeriesId, true), gettype($subscriptionInstancesSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstancesSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstancesSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstancesSeriesId, true)), __LINE__);
        }
        if (is_null($subscriptionInstancesSeriesId) || (is_array($subscriptionInstancesSeriesId) && empty($subscriptionInstancesSeriesId))) {
            unset($this->SubscriptionInstancesSeriesId);
        } else {
            $this->SubscriptionInstancesSeriesId = $subscriptionInstancesSeriesId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Subscription_InitiateReplaceSubscriptionProcess_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
