<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Subscription.InitiateRenewProcess.Request
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BizAction.Subscription.InitiateRenewProcess.Request
 * @subpackage Structs
 */
class BizAction_Subscription_InitiateRenewProcess_Request extends AnyEntity
{
    /**
     * The AutoSetTicketSchemeEnrollment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutoSetTicketSchemeEnrollment;
    /**
     * The ErrorText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorText;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSubscription_InitiateRenewProcessItem
     */
    public $Items;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SpecifiedClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SpecifiedClientId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for BizAction.Subscription.InitiateRenewProcess.Request
     * @uses BizAction_Subscription_InitiateRenewProcess_Request::setAutoSetTicketSchemeEnrollment()
     * @uses BizAction_Subscription_InitiateRenewProcess_Request::setErrorText()
     * @uses BizAction_Subscription_InitiateRenewProcess_Request::setItems()
     * @uses BizAction_Subscription_InitiateRenewProcess_Request::setSeasonId()
     * @uses BizAction_Subscription_InitiateRenewProcess_Request::setSpecifiedClientId()
     * @uses BizAction_Subscription_InitiateRenewProcess_Request::setTransactionGuid()
     * @param bool $autoSetTicketSchemeEnrollment
     * @param string $errorText
     * @param \patest\StructType\RecordSetOfSubscription_InitiateRenewProcessItem $items
     * @param string $seasonId
     * @param string $specifiedClientId
     * @param string $transactionGuid
     */
    public function __construct($autoSetTicketSchemeEnrollment = null, $errorText = null, \patest\StructType\RecordSetOfSubscription_InitiateRenewProcessItem $items = null, $seasonId = null, $specifiedClientId = null, $transactionGuid = null)
    {
        $this
            ->setAutoSetTicketSchemeEnrollment($autoSetTicketSchemeEnrollment)
            ->setErrorText($errorText)
            ->setItems($items)
            ->setSeasonId($seasonId)
            ->setSpecifiedClientId($specifiedClientId)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get AutoSetTicketSchemeEnrollment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutoSetTicketSchemeEnrollment()
    {
        return isset($this->AutoSetTicketSchemeEnrollment) ? $this->AutoSetTicketSchemeEnrollment : null;
    }
    /**
     * Set AutoSetTicketSchemeEnrollment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $autoSetTicketSchemeEnrollment
     * @return \patest\StructType\BizAction_Subscription_InitiateRenewProcess_Request
     */
    public function setAutoSetTicketSchemeEnrollment($autoSetTicketSchemeEnrollment = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoSetTicketSchemeEnrollment) && !is_bool($autoSetTicketSchemeEnrollment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoSetTicketSchemeEnrollment, true), gettype($autoSetTicketSchemeEnrollment)), __LINE__);
        }
        if (is_null($autoSetTicketSchemeEnrollment) || (is_array($autoSetTicketSchemeEnrollment) && empty($autoSetTicketSchemeEnrollment))) {
            unset($this->AutoSetTicketSchemeEnrollment);
        } else {
            $this->AutoSetTicketSchemeEnrollment = $autoSetTicketSchemeEnrollment;
        }
        return $this;
    }
    /**
     * Get ErrorText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorText()
    {
        return isset($this->ErrorText) ? $this->ErrorText : null;
    }
    /**
     * Set ErrorText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorText
     * @return \patest\StructType\BizAction_Subscription_InitiateRenewProcess_Request
     */
    public function setErrorText($errorText = null)
    {
        // validation for constraint: string
        if (!is_null($errorText) && !is_string($errorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorText, true), gettype($errorText)), __LINE__);
        }
        if (is_null($errorText) || (is_array($errorText) && empty($errorText))) {
            unset($this->ErrorText);
        } else {
            $this->ErrorText = $errorText;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSubscription_InitiateRenewProcessItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSubscription_InitiateRenewProcessItem $items
     * @return \patest\StructType\BizAction_Subscription_InitiateRenewProcess_Request
     */
    public function setItems(\patest\StructType\RecordSetOfSubscription_InitiateRenewProcessItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\BizAction_Subscription_InitiateRenewProcess_Request
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SpecifiedClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecifiedClientId()
    {
        return isset($this->SpecifiedClientId) ? $this->SpecifiedClientId : null;
    }
    /**
     * Set SpecifiedClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specifiedClientId
     * @return \patest\StructType\BizAction_Subscription_InitiateRenewProcess_Request
     */
    public function setSpecifiedClientId($specifiedClientId = null)
    {
        // validation for constraint: string
        if (!is_null($specifiedClientId) && !is_string($specifiedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specifiedClientId, true), gettype($specifiedClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($specifiedClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $specifiedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($specifiedClientId, true)), __LINE__);
        }
        if (is_null($specifiedClientId) || (is_array($specifiedClientId) && empty($specifiedClientId))) {
            unset($this->SpecifiedClientId);
        } else {
            $this->SpecifiedClientId = $specifiedClientId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Subscription_InitiateRenewProcess_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
