<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.SalesPoint.Copy.Request StructType
 * @subpackage Structs
 */
class BizAction_Security_SalesPoint_Copy_Request extends AnyEntity
{
    /**
     * The SalesPointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesPointId;
    /**
     * Constructor method for BizAction.Security.SalesPoint.Copy.Request
     * @uses BizAction_Security_SalesPoint_Copy_Request::setSalesPointId()
     * @param string $salesPointId
     */
    public function __construct($salesPointId = null)
    {
        $this
            ->setSalesPointId($salesPointId);
    }
    /**
     * Get SalesPointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesPointId()
    {
        return isset($this->SalesPointId) ? $this->SalesPointId : null;
    }
    /**
     * Set SalesPointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesPointId
     * @return \patest\StructType\BizAction_Security_SalesPoint_Copy_Request
     */
    public function setSalesPointId($salesPointId = null)
    {
        // validation for constraint: string
        if (!is_null($salesPointId) && !is_string($salesPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesPointId, true), gettype($salesPointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesPointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesPointId, true)), __LINE__);
        }
        if (is_null($salesPointId) || (is_array($salesPointId) && empty($salesPointId))) {
            unset($this->SalesPointId);
        } else {
            $this->SalesPointId = $salesPointId;
        }
        return $this;
    }
}
