<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Security.ImportProfileCustomizationDataAndParameters.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Security_ImportProfileCustomizationDataAndParameters_Request extends BizAction_Foundation_UploadFileIntoSessionLargeBinaryData_Request
{
    /**
     * The ProfileGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProfileGuid;
    /**
     * The ProfileId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProfileId;
    /**
     * The ProfileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProfileName;
    /**
     * Constructor method for
     * BizAction.Security.ImportProfileCustomizationDataAndParameters.Request
     * @uses BizAction_Security_ImportProfileCustomizationDataAndParameters_Request::setProfileGuid()
     * @uses BizAction_Security_ImportProfileCustomizationDataAndParameters_Request::setProfileId()
     * @uses BizAction_Security_ImportProfileCustomizationDataAndParameters_Request::setProfileName()
     * @param string $profileGuid
     * @param int $profileId
     * @param string $profileName
     */
    public function __construct($profileGuid = null, $profileId = null, $profileName = null)
    {
        $this
            ->setProfileGuid($profileGuid)
            ->setProfileId($profileId)
            ->setProfileName($profileName);
    }
    /**
     * Get ProfileGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProfileGuid()
    {
        return isset($this->ProfileGuid) ? $this->ProfileGuid : null;
    }
    /**
     * Set ProfileGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $profileGuid
     * @return \patest\StructType\BizAction_Security_ImportProfileCustomizationDataAndParameters_Request
     */
    public function setProfileGuid($profileGuid = null)
    {
        // validation for constraint: string
        if (!is_null($profileGuid) && !is_string($profileGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileGuid, true), gettype($profileGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($profileGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $profileGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($profileGuid, true)), __LINE__);
        }
        if (is_null($profileGuid) || (is_array($profileGuid) && empty($profileGuid))) {
            unset($this->ProfileGuid);
        } else {
            $this->ProfileGuid = $profileGuid;
        }
        return $this;
    }
    /**
     * Get ProfileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProfileId()
    {
        return isset($this->ProfileId) ? $this->ProfileId : null;
    }
    /**
     * Set ProfileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $profileId
     * @return \patest\StructType\BizAction_Security_ImportProfileCustomizationDataAndParameters_Request
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !(is_int($profileId) || ctype_digit($profileId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileId, true), gettype($profileId)), __LINE__);
        }
        if (is_null($profileId) || (is_array($profileId) && empty($profileId))) {
            unset($this->ProfileId);
        } else {
            $this->ProfileId = $profileId;
        }
        return $this;
    }
    /**
     * Get ProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProfileName()
    {
        return isset($this->ProfileName) ? $this->ProfileName : null;
    }
    /**
     * Set ProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $profileName
     * @return \patest\StructType\BizAction_Security_ImportProfileCustomizationDataAndParameters_Request
     */
    public function setProfileName($profileName = null)
    {
        // validation for constraint: string
        if (!is_null($profileName) && !is_string($profileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileName, true), gettype($profileName)), __LINE__);
        }
        if (is_null($profileName) || (is_array($profileName) && empty($profileName))) {
            unset($this->ProfileName);
        } else {
            $this->ProfileName = $profileName;
        }
        return $this;
    }
}
