<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.CrossOrgUnits.ChangeAcl.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Security_CrossOrgUnits_ChangeAcl_Request extends BizAction_Security_CrossOrgUnits_ChangeDefaults_Request
{
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityId;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The EntityTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityTitle;
    /**
     * The RecordTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordTitle;
    /**
     * Constructor method for BizAction.Security.CrossOrgUnits.ChangeAcl.Request
     * @uses BizAction_Security_CrossOrgUnits_ChangeAcl_Request::setEntityId()
     * @uses BizAction_Security_CrossOrgUnits_ChangeAcl_Request::setEntityName()
     * @uses BizAction_Security_CrossOrgUnits_ChangeAcl_Request::setEntityTitle()
     * @uses BizAction_Security_CrossOrgUnits_ChangeAcl_Request::setRecordTitle()
     * @param string $entityId
     * @param string $entityName
     * @param string $entityTitle
     * @param string $recordTitle
     */
    public function __construct($entityId = null, $entityName = null, $entityTitle = null, $recordTitle = null)
    {
        $this
            ->setEntityId($entityId)
            ->setEntityName($entityName)
            ->setEntityTitle($entityTitle)
            ->setRecordTitle($recordTitle);
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityId
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_ChangeAcl_Request
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_ChangeAcl_Request
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get EntityTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityTitle()
    {
        return isset($this->EntityTitle) ? $this->EntityTitle : null;
    }
    /**
     * Set EntityTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityTitle
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_ChangeAcl_Request
     */
    public function setEntityTitle($entityTitle = null)
    {
        // validation for constraint: string
        if (!is_null($entityTitle) && !is_string($entityTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityTitle, true), gettype($entityTitle)), __LINE__);
        }
        if (is_null($entityTitle) || (is_array($entityTitle) && empty($entityTitle))) {
            unset($this->EntityTitle);
        } else {
            $this->EntityTitle = $entityTitle;
        }
        return $this;
    }
    /**
     * Get RecordTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordTitle()
    {
        return isset($this->RecordTitle) ? $this->RecordTitle : null;
    }
    /**
     * Set RecordTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordTitle
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_ChangeAcl_Request
     */
    public function setRecordTitle($recordTitle = null)
    {
        // validation for constraint: string
        if (!is_null($recordTitle) && !is_string($recordTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordTitle, true), gettype($recordTitle)), __LINE__);
        }
        if (is_null($recordTitle) || (is_array($recordTitle) && empty($recordTitle))) {
            unset($this->RecordTitle);
        } else {
            $this->RecordTitle = $recordTitle;
        }
        return $this;
    }
}
