<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.ChangeAcl.Request StructType
 * @subpackage Structs
 */
class BizAction_Security_ChangeAcl_Request extends AnyEntity
{
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityId;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The EntityTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityTitle;
    /**
     * The IsRevertToDefaults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRevertToDefaults;
    /**
     * The IsSplitByEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSplitByEntity;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Security_ChangeAcl_RequestItem
     */
    public $Items;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OrganizationUnitName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrganizationUnitName;
    /**
     * The RecordTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordTitle;
    /**
     * The SecurityTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SecurityTokenId;
    /**
     * Constructor method for BizAction.Security.ChangeAcl.Request
     * @uses BizAction_Security_ChangeAcl_Request::setEntityId()
     * @uses BizAction_Security_ChangeAcl_Request::setEntityName()
     * @uses BizAction_Security_ChangeAcl_Request::setEntityTitle()
     * @uses BizAction_Security_ChangeAcl_Request::setIsRevertToDefaults()
     * @uses BizAction_Security_ChangeAcl_Request::setIsSplitByEntity()
     * @uses BizAction_Security_ChangeAcl_Request::setItems()
     * @uses BizAction_Security_ChangeAcl_Request::setOrganizationUnitId()
     * @uses BizAction_Security_ChangeAcl_Request::setOrganizationUnitName()
     * @uses BizAction_Security_ChangeAcl_Request::setRecordTitle()
     * @uses BizAction_Security_ChangeAcl_Request::setSecurityTokenId()
     * @param string $entityId
     * @param string $entityName
     * @param string $entityTitle
     * @param bool $isRevertToDefaults
     * @param bool $isSplitByEntity
     * @param \patest\StructType\RecordSetOfBizAction_Security_ChangeAcl_RequestItem $items
     * @param string $organizationUnitId
     * @param string $organizationUnitName
     * @param string $recordTitle
     * @param string $securityTokenId
     */
    public function __construct($entityId = null, $entityName = null, $entityTitle = null, $isRevertToDefaults = null, $isSplitByEntity = null, \patest\StructType\RecordSetOfBizAction_Security_ChangeAcl_RequestItem $items = null, $organizationUnitId = null, $organizationUnitName = null, $recordTitle = null, $securityTokenId = null)
    {
        $this
            ->setEntityId($entityId)
            ->setEntityName($entityName)
            ->setEntityTitle($entityTitle)
            ->setIsRevertToDefaults($isRevertToDefaults)
            ->setIsSplitByEntity($isSplitByEntity)
            ->setItems($items)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOrganizationUnitName($organizationUnitName)
            ->setRecordTitle($recordTitle)
            ->setSecurityTokenId($securityTokenId);
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityId
     * @return \patest\StructType\BizAction_Security_ChangeAcl_Request
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\BizAction_Security_ChangeAcl_Request
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get EntityTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityTitle()
    {
        return isset($this->EntityTitle) ? $this->EntityTitle : null;
    }
    /**
     * Set EntityTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityTitle
     * @return \patest\StructType\BizAction_Security_ChangeAcl_Request
     */
    public function setEntityTitle($entityTitle = null)
    {
        // validation for constraint: string
        if (!is_null($entityTitle) && !is_string($entityTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityTitle, true), gettype($entityTitle)), __LINE__);
        }
        if (is_null($entityTitle) || (is_array($entityTitle) && empty($entityTitle))) {
            unset($this->EntityTitle);
        } else {
            $this->EntityTitle = $entityTitle;
        }
        return $this;
    }
    /**
     * Get IsRevertToDefaults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRevertToDefaults()
    {
        return isset($this->IsRevertToDefaults) ? $this->IsRevertToDefaults : null;
    }
    /**
     * Set IsRevertToDefaults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRevertToDefaults
     * @return \patest\StructType\BizAction_Security_ChangeAcl_Request
     */
    public function setIsRevertToDefaults($isRevertToDefaults = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRevertToDefaults) && !is_bool($isRevertToDefaults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRevertToDefaults, true), gettype($isRevertToDefaults)), __LINE__);
        }
        if (is_null($isRevertToDefaults) || (is_array($isRevertToDefaults) && empty($isRevertToDefaults))) {
            unset($this->IsRevertToDefaults);
        } else {
            $this->IsRevertToDefaults = $isRevertToDefaults;
        }
        return $this;
    }
    /**
     * Get IsSplitByEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSplitByEntity()
    {
        return isset($this->IsSplitByEntity) ? $this->IsSplitByEntity : null;
    }
    /**
     * Set IsSplitByEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSplitByEntity
     * @return \patest\StructType\BizAction_Security_ChangeAcl_Request
     */
    public function setIsSplitByEntity($isSplitByEntity = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSplitByEntity) && !is_bool($isSplitByEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSplitByEntity, true), gettype($isSplitByEntity)), __LINE__);
        }
        if (is_null($isSplitByEntity) || (is_array($isSplitByEntity) && empty($isSplitByEntity))) {
            unset($this->IsSplitByEntity);
        } else {
            $this->IsSplitByEntity = $isSplitByEntity;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Security_ChangeAcl_RequestItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Security_ChangeAcl_RequestItem $items
     * @return \patest\StructType\BizAction_Security_ChangeAcl_Request
     */
    public function setItems(\patest\StructType\RecordSetOfBizAction_Security_ChangeAcl_RequestItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\BizAction_Security_ChangeAcl_Request
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitName()
    {
        return isset($this->OrganizationUnitName) ? $this->OrganizationUnitName : null;
    }
    /**
     * Set OrganizationUnitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitName
     * @return \patest\StructType\BizAction_Security_ChangeAcl_Request
     */
    public function setOrganizationUnitName($organizationUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitName) && !is_string($organizationUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitName, true), gettype($organizationUnitName)), __LINE__);
        }
        if (is_null($organizationUnitName) || (is_array($organizationUnitName) && empty($organizationUnitName))) {
            unset($this->OrganizationUnitName);
        } else {
            $this->OrganizationUnitName = $organizationUnitName;
        }
        return $this;
    }
    /**
     * Get RecordTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordTitle()
    {
        return isset($this->RecordTitle) ? $this->RecordTitle : null;
    }
    /**
     * Set RecordTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordTitle
     * @return \patest\StructType\BizAction_Security_ChangeAcl_Request
     */
    public function setRecordTitle($recordTitle = null)
    {
        // validation for constraint: string
        if (!is_null($recordTitle) && !is_string($recordTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordTitle, true), gettype($recordTitle)), __LINE__);
        }
        if (is_null($recordTitle) || (is_array($recordTitle) && empty($recordTitle))) {
            unset($this->RecordTitle);
        } else {
            $this->RecordTitle = $recordTitle;
        }
        return $this;
    }
    /**
     * Get SecurityTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityTokenId()
    {
        return isset($this->SecurityTokenId) ? $this->SecurityTokenId : null;
    }
    /**
     * Set SecurityTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityTokenId
     * @return \patest\StructType\BizAction_Security_ChangeAcl_Request
     */
    public function setSecurityTokenId($securityTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($securityTokenId) && !is_string($securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityTokenId, true), gettype($securityTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($securityTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($securityTokenId, true)), __LINE__);
        }
        if (is_null($securityTokenId) || (is_array($securityTokenId) && empty($securityTokenId))) {
            unset($this->SecurityTokenId);
        } else {
            $this->SecurityTokenId = $securityTokenId;
        }
        return $this;
    }
}
