<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.TransactionCancellation.Request StructType
 * @subpackage Structs
 */
class BizAction_Sales_TransactionCancellation_Request extends AnyEntity
{
    /**
     * The FromTranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromTranDate;
    /**
     * The PaymentMethodIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PaymentMethodIds
     */
    public $PaymentMethodIds;
    /**
     * The SellerIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SellerIds
     */
    public $SellerIds;
    /**
     * The ToTranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToTranDate;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Type;
    /**
     * Constructor method for BizAction.Sales.TransactionCancellation.Request
     * @uses BizAction_Sales_TransactionCancellation_Request::setFromTranDate()
     * @uses BizAction_Sales_TransactionCancellation_Request::setPaymentMethodIds()
     * @uses BizAction_Sales_TransactionCancellation_Request::setSellerIds()
     * @uses BizAction_Sales_TransactionCancellation_Request::setToTranDate()
     * @uses BizAction_Sales_TransactionCancellation_Request::setType()
     * @param string $fromTranDate
     * @param \patest\StructType\PaymentMethodIds $paymentMethodIds
     * @param \patest\StructType\SellerIds $sellerIds
     * @param string $toTranDate
     * @param int $type
     */
    public function __construct($fromTranDate = null, \patest\StructType\PaymentMethodIds $paymentMethodIds = null, \patest\StructType\SellerIds $sellerIds = null, $toTranDate = null, $type = null)
    {
        $this
            ->setFromTranDate($fromTranDate)
            ->setPaymentMethodIds($paymentMethodIds)
            ->setSellerIds($sellerIds)
            ->setToTranDate($toTranDate)
            ->setType($type);
    }
    /**
     * Get FromTranDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromTranDate()
    {
        return isset($this->FromTranDate) ? $this->FromTranDate : null;
    }
    /**
     * Set FromTranDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromTranDate
     * @return \patest\StructType\BizAction_Sales_TransactionCancellation_Request
     */
    public function setFromTranDate($fromTranDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromTranDate) && !is_string($fromTranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromTranDate, true), gettype($fromTranDate)), __LINE__);
        }
        if (is_null($fromTranDate) || (is_array($fromTranDate) && empty($fromTranDate))) {
            unset($this->FromTranDate);
        } else {
            $this->FromTranDate = $fromTranDate;
        }
        return $this;
    }
    /**
     * Get PaymentMethodIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PaymentMethodIds|null
     */
    public function getPaymentMethodIds()
    {
        return isset($this->PaymentMethodIds) ? $this->PaymentMethodIds : null;
    }
    /**
     * Set PaymentMethodIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PaymentMethodIds $paymentMethodIds
     * @return \patest\StructType\BizAction_Sales_TransactionCancellation_Request
     */
    public function setPaymentMethodIds(\patest\StructType\PaymentMethodIds $paymentMethodIds = null)
    {
        if (is_null($paymentMethodIds) || (is_array($paymentMethodIds) && empty($paymentMethodIds))) {
            unset($this->PaymentMethodIds);
        } else {
            $this->PaymentMethodIds = $paymentMethodIds;
        }
        return $this;
    }
    /**
     * Get SellerIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SellerIds|null
     */
    public function getSellerIds()
    {
        return isset($this->SellerIds) ? $this->SellerIds : null;
    }
    /**
     * Set SellerIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SellerIds $sellerIds
     * @return \patest\StructType\BizAction_Sales_TransactionCancellation_Request
     */
    public function setSellerIds(\patest\StructType\SellerIds $sellerIds = null)
    {
        if (is_null($sellerIds) || (is_array($sellerIds) && empty($sellerIds))) {
            unset($this->SellerIds);
        } else {
            $this->SellerIds = $sellerIds;
        }
        return $this;
    }
    /**
     * Get ToTranDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToTranDate()
    {
        return isset($this->ToTranDate) ? $this->ToTranDate : null;
    }
    /**
     * Set ToTranDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toTranDate
     * @return \patest\StructType\BizAction_Sales_TransactionCancellation_Request
     */
    public function setToTranDate($toTranDate = null)
    {
        // validation for constraint: string
        if (!is_null($toTranDate) && !is_string($toTranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toTranDate, true), gettype($toTranDate)), __LINE__);
        }
        if (is_null($toTranDate) || (is_array($toTranDate) && empty($toTranDate))) {
            unset($this->ToTranDate);
        } else {
            $this->ToTranDate = $toTranDate;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $type
     * @return \patest\StructType\BizAction_Sales_TransactionCancellation_Request
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
