<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Sales.TransactionCancellationForMultiEvents.Request StructType
 * @subpackage Structs
 */
class BizAction_Sales_TransactionCancellationForMultiEvents_Request extends BizAction_Sales_TransactionCancellation_Request
{
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The FromEventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromEventDate;
    /**
     * The ShowIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ShowIds
     */
    public $ShowIds;
    /**
     * The ToEventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToEventDate;
    /**
     * Constructor method for
     * BizAction.Sales.TransactionCancellationForMultiEvents.Request
     * @uses BizAction_Sales_TransactionCancellationForMultiEvents_Request::setEventIds()
     * @uses BizAction_Sales_TransactionCancellationForMultiEvents_Request::setFromEventDate()
     * @uses BizAction_Sales_TransactionCancellationForMultiEvents_Request::setShowIds()
     * @uses BizAction_Sales_TransactionCancellationForMultiEvents_Request::setToEventDate()
     * @param \patest\StructType\EventIds $eventIds
     * @param string $fromEventDate
     * @param \patest\StructType\ShowIds $showIds
     * @param string $toEventDate
     */
    public function __construct(\patest\StructType\EventIds $eventIds = null, $fromEventDate = null, \patest\StructType\ShowIds $showIds = null, $toEventDate = null)
    {
        $this
            ->setEventIds($eventIds)
            ->setFromEventDate($fromEventDate)
            ->setShowIds($showIds)
            ->setToEventDate($toEventDate);
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\BizAction_Sales_TransactionCancellationForMultiEvents_Request
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get FromEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromEventDate()
    {
        return isset($this->FromEventDate) ? $this->FromEventDate : null;
    }
    /**
     * Set FromEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromEventDate
     * @return \patest\StructType\BizAction_Sales_TransactionCancellationForMultiEvents_Request
     */
    public function setFromEventDate($fromEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromEventDate) && !is_string($fromEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEventDate, true), gettype($fromEventDate)), __LINE__);
        }
        if (is_null($fromEventDate) || (is_array($fromEventDate) && empty($fromEventDate))) {
            unset($this->FromEventDate);
        } else {
            $this->FromEventDate = $fromEventDate;
        }
        return $this;
    }
    /**
     * Get ShowIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ShowIds|null
     */
    public function getShowIds()
    {
        return isset($this->ShowIds) ? $this->ShowIds : null;
    }
    /**
     * Set ShowIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ShowIds $showIds
     * @return \patest\StructType\BizAction_Sales_TransactionCancellationForMultiEvents_Request
     */
    public function setShowIds(\patest\StructType\ShowIds $showIds = null)
    {
        if (is_null($showIds) || (is_array($showIds) && empty($showIds))) {
            unset($this->ShowIds);
        } else {
            $this->ShowIds = $showIds;
        }
        return $this;
    }
    /**
     * Get ToEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToEventDate()
    {
        return isset($this->ToEventDate) ? $this->ToEventDate : null;
    }
    /**
     * Set ToEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toEventDate
     * @return \patest\StructType\BizAction_Sales_TransactionCancellationForMultiEvents_Request
     */
    public function setToEventDate($toEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($toEventDate) && !is_string($toEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toEventDate, true), gettype($toEventDate)), __LINE__);
        }
        if (is_null($toEventDate) || (is_array($toEventDate) && empty($toEventDate))) {
            unset($this->ToEventDate);
        } else {
            $this->ToEventDate = $toEventDate;
        }
        return $this;
    }
}
