<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.PriceListExport.Request StructType
 * @subpackage Structs
 */
class BizAction_Sales_PriceListExport_Request extends AnyEntity
{
    /**
     * The AdditionalPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Sales_PriceListExport_AdditionalPriceType
     */
    public $AdditionalPriceTypes;
    /**
     * The Calculate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Calculate;
    /**
     * The PriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelIds
     */
    public $PriceLevelIds;
    /**
     * The PriceListIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceListIds
     */
    public $PriceListIds;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypeIds
     */
    public $PriceTypeIds;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for BizAction.Sales.PriceListExport.Request
     * @uses BizAction_Sales_PriceListExport_Request::setAdditionalPriceTypes()
     * @uses BizAction_Sales_PriceListExport_Request::setCalculate()
     * @uses BizAction_Sales_PriceListExport_Request::setPriceLevelIds()
     * @uses BizAction_Sales_PriceListExport_Request::setPriceListIds()
     * @uses BizAction_Sales_PriceListExport_Request::setPriceTypeIds()
     * @uses BizAction_Sales_PriceListExport_Request::setType()
     * @param \patest\StructType\RecordSetOfBizAction_Sales_PriceListExport_AdditionalPriceType $additionalPriceTypes
     * @param bool $calculate
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @param \patest\StructType\PriceListIds $priceListIds
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @param string $type
     */
    public function __construct(\patest\StructType\RecordSetOfBizAction_Sales_PriceListExport_AdditionalPriceType $additionalPriceTypes = null, $calculate = null, \patest\StructType\PriceLevelIds $priceLevelIds = null, \patest\StructType\PriceListIds $priceListIds = null, \patest\StructType\PriceTypeIds $priceTypeIds = null, $type = null)
    {
        $this
            ->setAdditionalPriceTypes($additionalPriceTypes)
            ->setCalculate($calculate)
            ->setPriceLevelIds($priceLevelIds)
            ->setPriceListIds($priceListIds)
            ->setPriceTypeIds($priceTypeIds)
            ->setType($type);
    }
    /**
     * Get AdditionalPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Sales_PriceListExport_AdditionalPriceType|null
     */
    public function getAdditionalPriceTypes()
    {
        return isset($this->AdditionalPriceTypes) ? $this->AdditionalPriceTypes : null;
    }
    /**
     * Set AdditionalPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Sales_PriceListExport_AdditionalPriceType $additionalPriceTypes
     * @return \patest\StructType\BizAction_Sales_PriceListExport_Request
     */
    public function setAdditionalPriceTypes(\patest\StructType\RecordSetOfBizAction_Sales_PriceListExport_AdditionalPriceType $additionalPriceTypes = null)
    {
        if (is_null($additionalPriceTypes) || (is_array($additionalPriceTypes) && empty($additionalPriceTypes))) {
            unset($this->AdditionalPriceTypes);
        } else {
            $this->AdditionalPriceTypes = $additionalPriceTypes;
        }
        return $this;
    }
    /**
     * Get Calculate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCalculate()
    {
        return isset($this->Calculate) ? $this->Calculate : null;
    }
    /**
     * Set Calculate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $calculate
     * @return \patest\StructType\BizAction_Sales_PriceListExport_Request
     */
    public function setCalculate($calculate = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculate) && !is_bool($calculate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calculate, true), gettype($calculate)), __LINE__);
        }
        if (is_null($calculate) || (is_array($calculate) && empty($calculate))) {
            unset($this->Calculate);
        } else {
            $this->Calculate = $calculate;
        }
        return $this;
    }
    /**
     * Get PriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelIds|null
     */
    public function getPriceLevelIds()
    {
        return isset($this->PriceLevelIds) ? $this->PriceLevelIds : null;
    }
    /**
     * Set PriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @return \patest\StructType\BizAction_Sales_PriceListExport_Request
     */
    public function setPriceLevelIds(\patest\StructType\PriceLevelIds $priceLevelIds = null)
    {
        if (is_null($priceLevelIds) || (is_array($priceLevelIds) && empty($priceLevelIds))) {
            unset($this->PriceLevelIds);
        } else {
            $this->PriceLevelIds = $priceLevelIds;
        }
        return $this;
    }
    /**
     * Get PriceListIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceListIds|null
     */
    public function getPriceListIds()
    {
        return isset($this->PriceListIds) ? $this->PriceListIds : null;
    }
    /**
     * Set PriceListIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceListIds $priceListIds
     * @return \patest\StructType\BizAction_Sales_PriceListExport_Request
     */
    public function setPriceListIds(\patest\StructType\PriceListIds $priceListIds = null)
    {
        if (is_null($priceListIds) || (is_array($priceListIds) && empty($priceListIds))) {
            unset($this->PriceListIds);
        } else {
            $this->PriceListIds = $priceListIds;
        }
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypeIds|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @return \patest\StructType\BizAction_Sales_PriceListExport_Request
     */
    public function setPriceTypeIds(\patest\StructType\PriceTypeIds $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceListFileType::valueIsValid()
     * @uses \patest\EnumType\PriceListFileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\BizAction_Sales_PriceListExport_Request
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceListFileType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceListFileType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\PriceListFileType::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
