<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.PaymentBreakdownCalculator.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Sales_PaymentBreakdownCalculator_Request extends AnyEntity
{
    /**
     * The EnableFeesCalculation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnableFeesCalculation;
    /**
     * The EnableMainCalculation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnableMainCalculation;
    /**
     * The Mode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mode;
    /**
     * The PopulationSelector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PopulationSelector;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The UntilDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilDate;
    /**
     * The WorkerCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WorkerCount;
    /**
     * Constructor method for BizAction.Sales.PaymentBreakdownCalculator.Request
     * @uses BizAction_Sales_PaymentBreakdownCalculator_Request::setEnableFeesCalculation()
     * @uses BizAction_Sales_PaymentBreakdownCalculator_Request::setEnableMainCalculation()
     * @uses BizAction_Sales_PaymentBreakdownCalculator_Request::setMode()
     * @uses BizAction_Sales_PaymentBreakdownCalculator_Request::setPopulationSelector()
     * @uses BizAction_Sales_PaymentBreakdownCalculator_Request::setStartDate()
     * @uses BizAction_Sales_PaymentBreakdownCalculator_Request::setUntilDate()
     * @uses BizAction_Sales_PaymentBreakdownCalculator_Request::setWorkerCount()
     * @param bool $enableFeesCalculation
     * @param bool $enableMainCalculation
     * @param string $mode
     * @param string $populationSelector
     * @param string $startDate
     * @param string $untilDate
     * @param int $workerCount
     */
    public function __construct($enableFeesCalculation = null, $enableMainCalculation = null, $mode = null, $populationSelector = null, $startDate = null, $untilDate = null, $workerCount = null)
    {
        $this
            ->setEnableFeesCalculation($enableFeesCalculation)
            ->setEnableMainCalculation($enableMainCalculation)
            ->setMode($mode)
            ->setPopulationSelector($populationSelector)
            ->setStartDate($startDate)
            ->setUntilDate($untilDate)
            ->setWorkerCount($workerCount);
    }
    /**
     * Get EnableFeesCalculation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnableFeesCalculation()
    {
        return isset($this->EnableFeesCalculation) ? $this->EnableFeesCalculation : null;
    }
    /**
     * Set EnableFeesCalculation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enableFeesCalculation
     * @return \patest\StructType\BizAction_Sales_PaymentBreakdownCalculator_Request
     */
    public function setEnableFeesCalculation($enableFeesCalculation = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableFeesCalculation) && !is_bool($enableFeesCalculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableFeesCalculation, true), gettype($enableFeesCalculation)), __LINE__);
        }
        if (is_null($enableFeesCalculation) || (is_array($enableFeesCalculation) && empty($enableFeesCalculation))) {
            unset($this->EnableFeesCalculation);
        } else {
            $this->EnableFeesCalculation = $enableFeesCalculation;
        }
        return $this;
    }
    /**
     * Get EnableMainCalculation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnableMainCalculation()
    {
        return isset($this->EnableMainCalculation) ? $this->EnableMainCalculation : null;
    }
    /**
     * Set EnableMainCalculation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enableMainCalculation
     * @return \patest\StructType\BizAction_Sales_PaymentBreakdownCalculator_Request
     */
    public function setEnableMainCalculation($enableMainCalculation = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableMainCalculation) && !is_bool($enableMainCalculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableMainCalculation, true), gettype($enableMainCalculation)), __LINE__);
        }
        if (is_null($enableMainCalculation) || (is_array($enableMainCalculation) && empty($enableMainCalculation))) {
            unset($this->EnableMainCalculation);
        } else {
            $this->EnableMainCalculation = $enableMainCalculation;
        }
        return $this;
    }
    /**
     * Get Mode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMode()
    {
        return isset($this->Mode) ? $this->Mode : null;
    }
    /**
     * Set Mode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LiaRecalculationMode::valueIsValid()
     * @uses \patest\EnumType\LiaRecalculationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mode
     * @return \patest\StructType\BizAction_Sales_PaymentBreakdownCalculator_Request
     */
    public function setMode($mode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LiaRecalculationMode::valueIsValid($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LiaRecalculationMode', is_array($mode) ? implode(', ', $mode) : var_export($mode, true), implode(', ', \patest\EnumType\LiaRecalculationMode::getValidValues())), __LINE__);
        }
        if (is_null($mode) || (is_array($mode) && empty($mode))) {
            unset($this->Mode);
        } else {
            $this->Mode = $mode;
        }
        return $this;
    }
    /**
     * Get PopulationSelector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPopulationSelector()
    {
        return isset($this->PopulationSelector) ? $this->PopulationSelector : null;
    }
    /**
     * Set PopulationSelector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $populationSelector
     * @return \patest\StructType\BizAction_Sales_PaymentBreakdownCalculator_Request
     */
    public function setPopulationSelector($populationSelector = null)
    {
        // validation for constraint: string
        if (!is_null($populationSelector) && !is_string($populationSelector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($populationSelector, true), gettype($populationSelector)), __LINE__);
        }
        if (is_null($populationSelector) || (is_array($populationSelector) && empty($populationSelector))) {
            unset($this->PopulationSelector);
        } else {
            $this->PopulationSelector = $populationSelector;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\BizAction_Sales_PaymentBreakdownCalculator_Request
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get UntilDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilDate()
    {
        return isset($this->UntilDate) ? $this->UntilDate : null;
    }
    /**
     * Set UntilDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilDate
     * @return \patest\StructType\BizAction_Sales_PaymentBreakdownCalculator_Request
     */
    public function setUntilDate($untilDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilDate) && !is_string($untilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDate, true), gettype($untilDate)), __LINE__);
        }
        if (is_null($untilDate) || (is_array($untilDate) && empty($untilDate))) {
            unset($this->UntilDate);
        } else {
            $this->UntilDate = $untilDate;
        }
        return $this;
    }
    /**
     * Get WorkerCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWorkerCount()
    {
        return isset($this->WorkerCount) ? $this->WorkerCount : null;
    }
    /**
     * Set WorkerCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $workerCount
     * @return \patest\StructType\BizAction_Sales_PaymentBreakdownCalculator_Request
     */
    public function setWorkerCount($workerCount = null)
    {
        // validation for constraint: int
        if (!is_null($workerCount) && !(is_int($workerCount) || ctype_digit($workerCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($workerCount, true), gettype($workerCount)), __LINE__);
        }
        if (is_null($workerCount) || (is_array($workerCount) && empty($workerCount))) {
            unset($this->WorkerCount);
        } else {
            $this->WorkerCount = $workerCount;
        }
        return $this;
    }
}
