<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.BulkReturnTransactionCommissions.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Sales_BulkReturnTransactionCommissions_Request extends BizAction_Foundation_BulkOperation_Request
{
    /**
     * The DepositCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositCategoryId;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodSubType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodSubType;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The ReturnToOriginalPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnToOriginalPayment;
    /**
     * The UseReimbursementRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseReimbursementRules;
    /**
     * Constructor method for BizAction.Sales.BulkReturnTransactionCommissions.Request
     * @uses BizAction_Sales_BulkReturnTransactionCommissions_Request::setDepositCategoryId()
     * @uses BizAction_Sales_BulkReturnTransactionCommissions_Request::setPaymentMethodId()
     * @uses BizAction_Sales_BulkReturnTransactionCommissions_Request::setPaymentMethodSubType()
     * @uses BizAction_Sales_BulkReturnTransactionCommissions_Request::setPaymentMethodType()
     * @uses BizAction_Sales_BulkReturnTransactionCommissions_Request::setReturnToOriginalPayment()
     * @uses BizAction_Sales_BulkReturnTransactionCommissions_Request::setUseReimbursementRules()
     * @param string $depositCategoryId
     * @param string $paymentMethodId
     * @param string $paymentMethodSubType
     * @param string $paymentMethodType
     * @param bool $returnToOriginalPayment
     * @param bool $useReimbursementRules
     */
    public function __construct($depositCategoryId = null, $paymentMethodId = null, $paymentMethodSubType = null, $paymentMethodType = null, $returnToOriginalPayment = null, $useReimbursementRules = null)
    {
        $this
            ->setDepositCategoryId($depositCategoryId)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodSubType($paymentMethodSubType)
            ->setPaymentMethodType($paymentMethodType)
            ->setReturnToOriginalPayment($returnToOriginalPayment)
            ->setUseReimbursementRules($useReimbursementRules);
    }
    /**
     * Get DepositCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositCategoryId()
    {
        return isset($this->DepositCategoryId) ? $this->DepositCategoryId : null;
    }
    /**
     * Set DepositCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositCategoryId
     * @return \patest\StructType\BizAction_Sales_BulkReturnTransactionCommissions_Request
     */
    public function setDepositCategoryId($depositCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($depositCategoryId) && !is_string($depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositCategoryId, true), gettype($depositCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositCategoryId, true)), __LINE__);
        }
        if (is_null($depositCategoryId) || (is_array($depositCategoryId) && empty($depositCategoryId))) {
            unset($this->DepositCategoryId);
        } else {
            $this->DepositCategoryId = $depositCategoryId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Sales_BulkReturnTransactionCommissions_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodSubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodSubType()
    {
        return isset($this->PaymentMethodSubType) ? $this->PaymentMethodSubType : null;
    }
    /**
     * Set PaymentMethodSubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodSubType
     * @return \patest\StructType\BizAction_Sales_BulkReturnTransactionCommissions_Request
     */
    public function setPaymentMethodSubType($paymentMethodSubType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodSubType) && !is_string($paymentMethodSubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodSubType, true), gettype($paymentMethodSubType)), __LINE__);
        }
        if (is_null($paymentMethodSubType) || (is_array($paymentMethodSubType) && empty($paymentMethodSubType))) {
            unset($this->PaymentMethodSubType);
        } else {
            $this->PaymentMethodSubType = $paymentMethodSubType;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\BizAction_Sales_BulkReturnTransactionCommissions_Request
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get ReturnToOriginalPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnToOriginalPayment()
    {
        return isset($this->ReturnToOriginalPayment) ? $this->ReturnToOriginalPayment : null;
    }
    /**
     * Set ReturnToOriginalPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnToOriginalPayment
     * @return \patest\StructType\BizAction_Sales_BulkReturnTransactionCommissions_Request
     */
    public function setReturnToOriginalPayment($returnToOriginalPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnToOriginalPayment) && !is_bool($returnToOriginalPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnToOriginalPayment, true), gettype($returnToOriginalPayment)), __LINE__);
        }
        if (is_null($returnToOriginalPayment) || (is_array($returnToOriginalPayment) && empty($returnToOriginalPayment))) {
            unset($this->ReturnToOriginalPayment);
        } else {
            $this->ReturnToOriginalPayment = $returnToOriginalPayment;
        }
        return $this;
    }
    /**
     * Get UseReimbursementRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseReimbursementRules()
    {
        return isset($this->UseReimbursementRules) ? $this->UseReimbursementRules : null;
    }
    /**
     * Set UseReimbursementRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useReimbursementRules
     * @return \patest\StructType\BizAction_Sales_BulkReturnTransactionCommissions_Request
     */
    public function setUseReimbursementRules($useReimbursementRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($useReimbursementRules) && !is_bool($useReimbursementRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useReimbursementRules, true), gettype($useReimbursementRules)), __LINE__);
        }
        if (is_null($useReimbursementRules) || (is_array($useReimbursementRules) && empty($useReimbursementRules))) {
            unset($this->UseReimbursementRules);
        } else {
            $this->UseReimbursementRules = $useReimbursementRules;
        }
        return $this;
    }
}
